/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.model.status;

import org.bidib.jbidibc.messages.enums.AddressTypeEnum;
import org.bidib.jbidibc.messages.enums.DirectionEnum;
import org.bidib.wizard.model.status.BidibStatus;

public enum DirectionStatus implements BidibStatus
{
    FORWARD(DirectionEnum.FORWARD, "forward"),
    BACKWARD(DirectionEnum.BACKWARD, "backward");

    private final DirectionEnum type;
    private final String key;

    private DirectionStatus(DirectionEnum type, String key) {
        this.type = type;
        this.key = key;
    }

    public DirectionEnum getType() {
        return this.type;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    public static DirectionStatus valueOf(DirectionEnum type) {
        DirectionStatus result = null;
        for (DirectionStatus e : DirectionStatus.values()) {
            if (e.type != type) continue;
            result = e;
            break;
        }
        if (result == null) {
            throw new IllegalArgumentException("cannot map " + type + " to a direction");
        }
        return result;
    }

    public static DirectionStatus valueOf(AddressTypeEnum type) {
        DirectionStatus result = null;
        switch (type) {
            case LOCOMOTIVE_BACKWARD: {
                result = BACKWARD;
                break;
            }
            case LOCOMOTIVE_FORWARD: {
                result = FORWARD;
                break;
            }
            default: {
                throw new IllegalArgumentException("cannot map " + type + " to a direction");
            }
        }
        return result;
    }

    public DirectionStatus[] getValues() {
        return new DirectionStatus[]{FORWARD, BACKWARD};
    }
}

