/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.model.status;

import org.bidib.jbidibc.messages.enums.InputPortEnum;
import org.bidib.wizard.model.status.BidibStatus;

public enum InputPortStatus implements BidibStatus
{
    ON(InputPortEnum.ON, "on"),
    OFF(InputPortEnum.OFF, "off");

    private final InputPortEnum type;
    private final String key;

    private InputPortStatus(InputPortEnum type, String key) {
        this.type = type;
        this.key = key;
    }

    public InputPortEnum getType() {
        return this.type;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    public String toString() {
        return this.type.toString();
    }

    public static InputPortStatus valueOf(InputPortEnum type) {
        InputPortStatus result = null;
        for (InputPortStatus e : InputPortStatus.values()) {
            if (e.type != type) continue;
            result = e;
            break;
        }
        if (result == null) {
            throw new IllegalArgumentException("cannot map " + type + " to an input port status");
        }
        return result;
    }

    public static InputPortStatus fromString(String type) {
        InputPortStatus result = null;
        for (InputPortStatus e : InputPortStatus.values()) {
            if (!e.key.equalsIgnoreCase(type)) continue;
            result = e;
            break;
        }
        if (result == null) {
            throw new IllegalArgumentException("cannot map " + type + " to a input port status");
        }
        return result;
    }

    public InputPortStatus[] getValues() {
        return new InputPortStatus[]{ON, OFF};
    }
}

