/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.model.status;

import org.bidib.jbidibc.messages.enums.ServoPortEnum;
import org.bidib.wizard.model.status.BidibStatus;

public enum ServoPortStatus implements BidibStatus
{
    START(ServoPortEnum.START, "start"),
    TEST(ServoPortEnum.TEST, "test");

    private final ServoPortEnum type;
    private final String key;

    private ServoPortStatus(ServoPortEnum type, String key) {
        this.type = type;
        this.key = key;
    }

    public ServoPortEnum getType() {
        return this.type;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    public static ServoPortStatus valueOf(ServoPortEnum type) {
        ServoPortStatus result = null;
        for (ServoPortStatus e : ServoPortStatus.values()) {
            if (e.type != type) continue;
            result = e;
            break;
        }
        if (result == null) {
            throw new IllegalArgumentException("cannot map " + type + " to a servo port status");
        }
        return result;
    }

    public static ServoPortStatus fromString(String type) {
        ServoPortStatus result = null;
        for (ServoPortStatus e : ServoPortStatus.values()) {
            if (!e.key.equalsIgnoreCase(type)) continue;
            result = e;
            break;
        }
        if (result == null) {
            throw new IllegalArgumentException("cannot map " + type + " to a servo port status");
        }
        return result;
    }

    public ServoPortStatus[] getValues() {
        return new ServoPortStatus[]{START, TEST};
    }

    public ServoPortStatus[] getMacroValues() {
        return new ServoPortStatus[]{START};
    }
}

