/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.model.status;

import org.bidib.jbidibc.messages.enums.SoundPortEnum;
import org.bidib.wizard.model.status.BidibStatus;

public enum SoundPortStatus implements BidibStatus
{
    PLAY(SoundPortEnum.PLAY, "play"),
    STOP(SoundPortEnum.STOP, "stop"),
    TEST(SoundPortEnum.TEST, "test");

    private final SoundPortEnum type;
    private final String key;

    private SoundPortStatus(SoundPortEnum type, String key) {
        this.type = type;
        this.key = key;
    }

    public SoundPortEnum getType() {
        return this.type;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    public static SoundPortStatus valueOf(SoundPortEnum type) {
        SoundPortStatus result = null;
        for (SoundPortStatus e : SoundPortStatus.values()) {
            if (e.type != type) continue;
            result = e;
            break;
        }
        if (result == null) {
            throw new IllegalArgumentException("cannot map " + type + " to a sound port status");
        }
        return result;
    }

    public static SoundPortStatus fromString(String type) {
        SoundPortStatus result = null;
        for (SoundPortStatus e : SoundPortStatus.values()) {
            if (!e.key.equalsIgnoreCase(type)) continue;
            result = e;
            break;
        }
        if (result == null) {
            throw new IllegalArgumentException("cannot map " + type + " to a sound port status");
        }
        return result;
    }

    public SoundPortStatus[] getValues() {
        return new SoundPortStatus[]{PLAY, STOP, TEST};
    }

    public SoundPortStatus[] getMacroValues() {
        return new SoundPortStatus[]{PLAY, STOP};
    }
}

