/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.model.status;

import org.bidib.jbidibc.messages.enums.SpeedStepsEnum;
import org.bidib.wizard.model.status.BidibStatus;

public enum SpeedSteps implements BidibStatus
{
    DCC14(14, "14", SpeedStepsEnum.DCC14),
    DCC28(28, "28", SpeedStepsEnum.DCC28),
    DCC128(127, "128", SpeedStepsEnum.DCC128),
    DCC_SDF(127, "DCC_SDF", SpeedStepsEnum.DCC_SDF),
    MM14(14, "MM14", SpeedStepsEnum.MM14),
    MM27a(27, "MM27a", SpeedStepsEnum.MM27a),
    MM27b(27, "MM27b", SpeedStepsEnum.MM27b),
    M4(128, "M4", SpeedStepsEnum.M4);

    private final int steps;
    private final String key;
    private final SpeedStepsEnum type;

    private SpeedSteps(int steps, String key, SpeedStepsEnum type) {
        this.steps = steps;
        this.key = key;
        this.type = type;
    }

    public int getSteps() {
        return this.steps;
    }

    public SpeedStepsEnum getType() {
        return this.type;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    public static SpeedSteps valueOf(SpeedStepsEnum type) {
        SpeedSteps result = null;
        for (SpeedSteps e : SpeedSteps.values()) {
            if (e.type != type) continue;
            result = e;
            break;
        }
        if (result == null) {
            throw new IllegalArgumentException("cannot map " + type + " to a speed step");
        }
        return result;
    }

    public static int valueOf(SpeedSteps speedSteps) {
        int steps = speedSteps.steps;
        if (steps == 127) {
            steps = 128;
        }
        return steps;
    }

    public static SpeedSteps valueOf(int speedSteps) {
        SpeedSteps result = null;
        if (speedSteps == 128) {
            speedSteps = 127;
        }
        for (SpeedSteps e : SpeedSteps.values()) {
            if (e.steps != speedSteps) continue;
            result = e;
            break;
        }
        if (result == null) {
            throw new IllegalArgumentException("cannot map " + speedSteps + " to a speed step");
        }
        return result;
    }

    public static SpeedSteps parse(String speedSteps) {
        SpeedSteps result = null;
        for (SpeedSteps e : SpeedSteps.values()) {
            if (!e.name().equalsIgnoreCase(speedSteps)) continue;
            result = e;
            break;
        }
        if (result == null) {
            throw new IllegalArgumentException("cannot map '" + speedSteps + "' to a speed step");
        }
        return result;
    }

    public static SpeedSteps fromBidibFormat(int format) {
        SpeedSteps result = null;
        switch (format) {
            case 0: {
                result = DCC14;
                break;
            }
            case 1: {
                result = DCC_SDF;
                break;
            }
            case 2: {
                result = DCC28;
                break;
            }
            case 3: {
                result = DCC128;
                break;
            }
            case 4: {
                result = MM14;
                break;
            }
            case 5: {
                result = MM27a;
                break;
            }
            case 6: {
                result = MM27b;
                break;
            }
            case 7: {
                result = M4;
                break;
            }
        }
        return result;
    }

    public SpeedSteps[] getValues() {
        return new SpeedSteps[]{DCC14, DCC28, DCC128, DCC_SDF};
    }

    public static SpeedSteps fromKey(String key) {
        SpeedSteps result = null;
        for (SpeedSteps e : SpeedSteps.values()) {
            if (!e.key.equals(key)) continue;
            result = e;
            break;
        }
        if (result == null) {
            throw new IllegalArgumentException("cannot map " + key + " to a speed step");
        }
        return result;
    }
}

