/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.model.status;

import org.bidib.jbidibc.messages.enums.SwitchPortEnum;
import org.bidib.wizard.model.status.BidibStatus;

public enum SwitchPortStatus implements BidibStatus
{
    ON(SwitchPortEnum.ON, "on"),
    OFF(SwitchPortEnum.OFF, "off"),
    TEST(SwitchPortEnum.TEST, "test");

    private final SwitchPortEnum type;
    private final String key;

    private SwitchPortStatus(SwitchPortEnum type, String key) {
        this.type = type;
        this.key = key;
    }

    public SwitchPortEnum getType() {
        return this.type;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    public static SwitchPortStatus valueOf(SwitchPortEnum type) {
        SwitchPortStatus result = null;
        for (SwitchPortStatus e : SwitchPortStatus.values()) {
            if (e.type != type) continue;
            result = e;
            break;
        }
        if (result == null) {
            throw new IllegalArgumentException("cannot map " + type + " to a switch port status");
        }
        return result;
    }

    public static SwitchPortStatus fromString(String type) {
        SwitchPortStatus result = null;
        for (SwitchPortStatus e : SwitchPortStatus.values()) {
            if (!e.key.equalsIgnoreCase(type)) continue;
            result = e;
            break;
        }
        if (result == null) {
            throw new IllegalArgumentException("cannot map " + type + " to a switch port status");
        }
        return result;
    }

    public SwitchPortStatus[] getValues() {
        return new SwitchPortStatus[]{ON, OFF, TEST};
    }

    public SwitchPortStatus[] getMacroValues() {
        return new SwitchPortStatus[]{ON, OFF};
    }
}

