/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.model.stringdata;

import com.jgoodies.binding.beans.Model;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.bidib.wizard.model.stringdata.StoredStrings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoredStringsImpl
extends Model
implements StoredStrings {
    private static final Logger LOGGER = LoggerFactory.getLogger(StoredStringsImpl.class);
    private static final long serialVersionUID = 1L;
    private final int namespace;
    private int maxItems;
    private int maxLength;
    private final Map<Integer, String> storedStrings = new HashMap<Integer, String>();

    public StoredStringsImpl(int namespace) {
        this.namespace = namespace;
    }

    @Override
    public int getNamespace() {
        return this.namespace;
    }

    @Override
    public int getMaxItems() {
        return this.maxItems;
    }

    @Override
    public void setMaxItems(int maxItems) {
        int oldValue = this.maxItems;
        this.maxItems = maxItems;
        this.firePropertyChange("maxItems", oldValue, this.maxItems);
    }

    @Override
    public int getMaxLength() {
        return this.maxLength;
    }

    @Override
    public void setMaxLength(int maxLength) {
        int oldValue = this.maxLength;
        this.maxLength = maxLength;
        this.firePropertyChange("maxLength", oldValue, this.maxLength);
    }

    @Override
    public Map<Integer, String> getStoredStrings() {
        return Collections.unmodifiableMap(this.storedStrings);
    }

    @Override
    public String getStoredString(int index) {
        return this.storedStrings.get(index);
    }

    @Override
    public void setStoredStrings(Map<Integer, String> storedStrings) {
        Map<Integer, String> oldValue = this.getStoredStrings();
        this.storedStrings.clear();
        if (storedStrings != null) {
            this.storedStrings.putAll(storedStrings);
        }
        this.firePropertyChange("storedStrings", oldValue, this.storedStrings);
    }

    @Override
    public void setStoredString(int index, String value) {
        if (index < this.maxItems) {
            String oldValue = this.getStoredString(index);
            this.storedStrings.put(index, value);
            this.fireIndexedPropertyChange("storedStrings", index, oldValue, value);
        } else {
            LOGGER.warn("Set the stored string failed because the index is out of bounds.");
        }
    }
}

