/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api;

import com.digi.xbee.api.BluetoothAuthentication;
import com.digi.xbee.api.DataReader;
import com.digi.xbee.api.Raw802Device;
import com.digi.xbee.api.RemoteXBeeDevice;
import com.digi.xbee.api.XBee;
import com.digi.xbee.api.XBeeNetwork;
import com.digi.xbee.api.connection.ConnectionType;
import com.digi.xbee.api.connection.IConnectionInterface;
import com.digi.xbee.api.connection.bluetooth.AbstractBluetoothInterface;
import com.digi.xbee.api.connection.serial.AbstractSerialPort;
import com.digi.xbee.api.connection.serial.SerialPortParameters;
import com.digi.xbee.api.exceptions.ATCommandException;
import com.digi.xbee.api.exceptions.BluetoothAuthenticationException;
import com.digi.xbee.api.exceptions.InterfaceAlreadyOpenException;
import com.digi.xbee.api.exceptions.InterfaceNotOpenException;
import com.digi.xbee.api.exceptions.InvalidOperatingModeException;
import com.digi.xbee.api.exceptions.OperationNotSupportedException;
import com.digi.xbee.api.exceptions.TimeoutException;
import com.digi.xbee.api.exceptions.TransmitException;
import com.digi.xbee.api.exceptions.XBeeException;
import com.digi.xbee.api.io.IOLine;
import com.digi.xbee.api.io.IOMode;
import com.digi.xbee.api.io.IOSample;
import com.digi.xbee.api.io.IOValue;
import com.digi.xbee.api.listeners.IDataReceiveListener;
import com.digi.xbee.api.listeners.IExplicitDataReceiveListener;
import com.digi.xbee.api.listeners.IIOSampleReceiveListener;
import com.digi.xbee.api.listeners.IIPDataReceiveListener;
import com.digi.xbee.api.listeners.IModemStatusReceiveListener;
import com.digi.xbee.api.listeners.IPacketReceiveListener;
import com.digi.xbee.api.listeners.ISMSReceiveListener;
import com.digi.xbee.api.listeners.IUserDataRelayReceiveListener;
import com.digi.xbee.api.listeners.relay.IBluetoothDataReceiveListener;
import com.digi.xbee.api.listeners.relay.IMicroPythonDataReceiveListener;
import com.digi.xbee.api.listeners.relay.ISerialDataReceiveListener;
import com.digi.xbee.api.models.APIOutputMode;
import com.digi.xbee.api.models.ATCommand;
import com.digi.xbee.api.models.ATCommandResponse;
import com.digi.xbee.api.models.ATCommandStatus;
import com.digi.xbee.api.models.AssociationIndicationStatus;
import com.digi.xbee.api.models.ExplicitXBeeMessage;
import com.digi.xbee.api.models.HardwareVersion;
import com.digi.xbee.api.models.ModemStatusEvent;
import com.digi.xbee.api.models.OperatingMode;
import com.digi.xbee.api.models.PowerLevel;
import com.digi.xbee.api.models.RestFulStatusEnum;
import com.digi.xbee.api.models.XBee16BitAddress;
import com.digi.xbee.api.models.XBee64BitAddress;
import com.digi.xbee.api.models.XBeeLocalInterface;
import com.digi.xbee.api.models.XBeeMessage;
import com.digi.xbee.api.models.XBeePacketsQueue;
import com.digi.xbee.api.models.XBeeProtocol;
import com.digi.xbee.api.models.XBeeTransmitStatus;
import com.digi.xbee.api.packet.APIFrameType;
import com.digi.xbee.api.packet.XBeeAPIPacket;
import com.digi.xbee.api.packet.XBeePacket;
import com.digi.xbee.api.packet.common.ATCommandPacket;
import com.digi.xbee.api.packet.common.ATCommandQueuePacket;
import com.digi.xbee.api.packet.common.ATCommandResponsePacket;
import com.digi.xbee.api.packet.common.ExplicitAddressingPacket;
import com.digi.xbee.api.packet.common.ExplicitRxIndicatorPacket;
import com.digi.xbee.api.packet.common.IODataSampleRxIndicatorPacket;
import com.digi.xbee.api.packet.common.ReceivePacket;
import com.digi.xbee.api.packet.common.RemoteATCommandPacket;
import com.digi.xbee.api.packet.common.RemoteATCommandResponsePacket;
import com.digi.xbee.api.packet.common.TransmitPacket;
import com.digi.xbee.api.packet.common.TransmitStatusPacket;
import com.digi.xbee.api.packet.raw.RX16IOPacket;
import com.digi.xbee.api.packet.raw.RX16Packet;
import com.digi.xbee.api.packet.raw.RX64IOPacket;
import com.digi.xbee.api.packet.raw.RX64Packet;
import com.digi.xbee.api.packet.raw.TX64Packet;
import com.digi.xbee.api.packet.raw.TXStatusPacket;
import com.digi.xbee.api.packet.relay.UserDataRelayPacket;
import com.digi.xbee.api.packet.thread.CoAPRxResponsePacket;
import com.digi.xbee.api.packet.thread.CoAPTxRequestPacket;
import com.digi.xbee.api.packet.thread.IPv6RemoteATCommandRequestPacket;
import com.digi.xbee.api.packet.thread.IPv6RemoteATCommandResponsePacket;
import com.digi.xbee.api.utils.ByteUtils;
import com.digi.xbee.api.utils.HexUtils;
import com.digi.xbee.api.utils.srp.SrpUtils;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.UnknownHostException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractXBeeDevice {
    private static String COMMAND_MODE_CHAR = "+";
    private static String COMMAND_MODE_OK = "OK\r";
    private static String COMMAND_MODE_EXIT = "ATCN\r";
    private static String COMMAND_MODE_AP = "ATAP\r";
    private static int TIMEOUT_RESET = 5000;
    protected static int TIMEOUT_READ_PACKET = 3000;
    protected XBeeNetwork network;
    private Object resetLock = new Object();
    private boolean modemStatusReceived = false;
    protected String bluetoothPassword;
    protected static final int DEFAULT_RECEIVE_TIMETOUT = 2000;
    protected static final int TIMEOUT_BEFORE_COMMAND_MODE = 1200;
    protected static final int DEFAULT_GUARD_TIME = 1500;
    protected IConnectionInterface connectionInterface;
    protected DataReader dataReader = null;
    protected XBeeProtocol xbeeProtocol = XBeeProtocol.UNKNOWN;
    protected OperatingMode operatingMode = OperatingMode.UNKNOWN;
    protected XBee16BitAddress xbee16BitAddress = XBee16BitAddress.UNKNOWN_ADDRESS;
    protected XBee64BitAddress xbee64BitAddress = XBee64BitAddress.UNKNOWN_ADDRESS;
    protected Inet6Address ipv6Address = null;
    protected int currentFrameID = 255;
    protected int receiveTimeout = 2000;
    protected AbstractXBeeDevice localXBeeDevice;
    protected Logger logger;
    private String nodeID;
    private String firmwareVersion;
    private HardwareVersion hardwareVersion;
    private Object ioLock = new Object();
    private boolean ioPacketReceived = false;
    private boolean applyConfigurationChanges = true;
    private byte[] ioPacketPayload;
    private IPacketReceiveListener IOPacketReceiveListener = new IPacketReceiveListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void packetReceived(XBeePacket receivedPacket) {
            if (!(receivedPacket instanceof XBeeAPIPacket)) {
                return;
            }
            if (AbstractXBeeDevice.this.ioPacketReceived) {
                return;
            }
            switch (((XBeeAPIPacket)receivedPacket).getFrameType()) {
                case IO_DATA_SAMPLE_RX_INDICATOR: {
                    AbstractXBeeDevice.access$102(AbstractXBeeDevice.this, ((IODataSampleRxIndicatorPacket)receivedPacket).getRFData());
                    break;
                }
                case RX_IO_16: {
                    AbstractXBeeDevice.access$102(AbstractXBeeDevice.this, ((RX16IOPacket)receivedPacket).getRFData());
                    break;
                }
                case RX_IO_64: {
                    AbstractXBeeDevice.access$102(AbstractXBeeDevice.this, ((RX64IOPacket)receivedPacket).getRFData());
                    break;
                }
                default: {
                    return;
                }
            }
            AbstractXBeeDevice.this.ioPacketReceived = true;
            Object object = AbstractXBeeDevice.this.ioLock;
            synchronized (object) {
                AbstractXBeeDevice.this.ioLock.notify();
            }
        }
    };
    private IModemStatusReceiveListener resetStatusListener = new IModemStatusReceiveListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void modemStatusEventReceived(ModemStatusEvent modemStatusEvent) {
            if (modemStatusEvent == ModemStatusEvent.STATUS_HARDWARE_RESET || modemStatusEvent == ModemStatusEvent.STATUS_WATCHDOG_TIMER_RESET) {
                AbstractXBeeDevice.this.modemStatusReceived = true;
                Object object = AbstractXBeeDevice.this.resetLock;
                synchronized (object) {
                    AbstractXBeeDevice.this.resetLock.notify();
                }
            }
        }
    };

    public AbstractXBeeDevice(String port, int baudRate) {
        this(XBee.createConnectiontionInterface(port, baudRate));
    }

    public AbstractXBeeDevice(String port, int baudRate, int dataBits, int stopBits, int parity, int flowControl) {
        this(port, new SerialPortParameters(baudRate, dataBits, stopBits, parity, flowControl));
    }

    public AbstractXBeeDevice(String port, SerialPortParameters serialPortParameters) {
        this(XBee.createConnectiontionInterface(port, serialPortParameters));
    }

    public AbstractXBeeDevice(IConnectionInterface connectionInterface) {
        if (connectionInterface == null) {
            throw new NullPointerException("ConnectionInterface cannot be null.");
        }
        this.connectionInterface = connectionInterface;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.logger.debug(this.toString() + "Using the connection interface {}.", (Object)connectionInterface.getClass().getSimpleName());
    }

    public AbstractXBeeDevice(AbstractXBeeDevice localXBeeDevice, XBee64BitAddress addr64) {
        this(localXBeeDevice, addr64, null, null);
    }

    public AbstractXBeeDevice(AbstractXBeeDevice localXBeeDevice, XBee64BitAddress addr64, XBee16BitAddress addr16, String id) {
        if (localXBeeDevice == null) {
            throw new NullPointerException("Local XBee device cannot be null.");
        }
        if (addr64 == null) {
            throw new NullPointerException("XBee 64-bit address of the device cannot be null.");
        }
        if (localXBeeDevice.isRemote()) {
            throw new IllegalArgumentException("The given local XBee device is remote.");
        }
        this.localXBeeDevice = localXBeeDevice;
        this.connectionInterface = localXBeeDevice.getConnectionInterface();
        this.xbee64BitAddress = addr64;
        this.xbee16BitAddress = addr16;
        if (addr16 == null) {
            this.xbee16BitAddress = XBee16BitAddress.UNKNOWN_ADDRESS;
        }
        this.nodeID = id;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.logger.debug(this.toString() + "Using the connection interface {}.", (Object)this.connectionInterface.getClass().getSimpleName());
    }

    public AbstractXBeeDevice(AbstractXBeeDevice localXBeeDevice, Inet6Address ipv6Addr) {
        this(localXBeeDevice, ipv6Addr, null);
    }

    public AbstractXBeeDevice(AbstractXBeeDevice localXBeeDevice, Inet6Address ipv6Addr, String id) {
        if (localXBeeDevice == null) {
            throw new NullPointerException("Local XBee device cannot be null.");
        }
        if (ipv6Addr == null) {
            throw new NullPointerException("XBee IPv6 address of the device cannot be null.");
        }
        if (localXBeeDevice.isRemote()) {
            throw new IllegalArgumentException("The given local XBee device is remote.");
        }
        this.localXBeeDevice = localXBeeDevice;
        this.connectionInterface = localXBeeDevice.getConnectionInterface();
        this.ipv6Address = ipv6Addr;
        this.nodeID = id;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.logger.debug(this.toString() + "Using the connection interface {}.", (Object)this.connectionInterface.getClass().getSimpleName());
    }

    public IConnectionInterface getConnectionInterface() {
        return this.connectionInterface;
    }

    public abstract boolean isRemote();

    public void readDeviceInfo() throws TimeoutException, XBeeException {
        byte[] response = null;
        if (this.xbee64BitAddress == null || this.xbee64BitAddress.equals(XBee64BitAddress.UNKNOWN_ADDRESS)) {
            response = this.getParameter("SH");
            String addressHigh = HexUtils.byteArrayToHexString(response);
            response = this.getParameter("SL");
            String addressLow = HexUtils.byteArrayToHexString(response);
            while (addressLow.length() < 8) {
                addressLow = "0" + addressLow;
            }
            this.xbee64BitAddress = new XBee64BitAddress(addressHigh + addressLow);
        }
        response = this.getParameter("NI");
        this.nodeID = new String(response);
        if (this.hardwareVersion == null) {
            response = this.getParameter("HV");
            this.hardwareVersion = HardwareVersion.get(response[0]);
        }
        response = this.getParameter("VR");
        this.firmwareVersion = HexUtils.byteArrayToHexString(response);
        XBeeProtocol origProtocol = this.getXBeeProtocol();
        this.xbeeProtocol = XBeeProtocol.determineProtocol(this.hardwareVersion, this.firmwareVersion);
        if (origProtocol != XBeeProtocol.UNKNOWN && origProtocol != this.xbeeProtocol) {
            throw new XBeeException("Error reading device information: Your module seems to be " + (Object)((Object)this.xbeeProtocol) + " and NOT " + (Object)((Object)origProtocol) + ". Check if you are using the appropriate device class.");
        }
        XBeeProtocol protocol = this.getXBeeProtocol();
        if (protocol == XBeeProtocol.ZIGBEE || protocol == XBeeProtocol.RAW_802_15_4 || protocol == XBeeProtocol.XTEND || protocol == XBeeProtocol.SMART_ENERGY || protocol == XBeeProtocol.ZNET) {
            response = this.getParameter("MY");
            this.xbee16BitAddress = new XBee16BitAddress(response);
        }
    }

    public XBee16BitAddress get16BitAddress() {
        return this.xbee16BitAddress;
    }

    public XBee64BitAddress get64BitAddress() {
        return this.xbee64BitAddress;
    }

    public Inet6Address getIPv6Address() {
        return this.ipv6Address;
    }

    protected OperatingMode getOperatingMode() {
        if (this.isRemote()) {
            return this.localXBeeDevice.getOperatingMode();
        }
        return this.operatingMode;
    }

    public XBeeProtocol getXBeeProtocol() {
        return this.xbeeProtocol;
    }

    public String getNodeID() {
        return this.nodeID;
    }

    public void setNodeID(String nodeID) throws TimeoutException, XBeeException {
        if (nodeID == null) {
            throw new NullPointerException("Node ID cannot be null.");
        }
        if (nodeID.length() > 20) {
            throw new IllegalArgumentException("Node ID length must be less than 21.");
        }
        this.setParameter("NI", nodeID.getBytes());
        this.nodeID = nodeID;
    }

    public String getFirmwareVersion() {
        return this.firmwareVersion;
    }

    public HardwareVersion getHardwareVersion() {
        return this.hardwareVersion;
    }

    public void updateDeviceDataFrom(AbstractXBeeDevice device) {
        XBee16BitAddress addr16;
        XBee64BitAddress addr64;
        if (device.getNodeID() != null) {
            this.nodeID = device.getNodeID();
        }
        if (!((addr64 = device.get64BitAddress()) == null || addr64.equals(XBee64BitAddress.UNKNOWN_ADDRESS) || addr64.equals(this.xbee64BitAddress) || this.xbee64BitAddress != null && !this.xbee64BitAddress.equals(XBee64BitAddress.UNKNOWN_ADDRESS))) {
            this.xbee64BitAddress = addr64;
        }
        if ((addr16 = device.get16BitAddress()) != null && !addr16.equals(this.xbee16BitAddress)) {
            this.xbee16BitAddress = addr16;
        }
    }

    protected void addPacketListener(IPacketReceiveListener listener) {
        if (listener == null) {
            throw new NullPointerException("Listener cannot be null.");
        }
        if (this.dataReader == null) {
            return;
        }
        this.dataReader.addPacketReceiveListener(listener);
    }

    protected void removePacketListener(IPacketReceiveListener listener) {
        if (listener == null) {
            throw new NullPointerException("Listener cannot be null.");
        }
        if (this.dataReader == null) {
            return;
        }
        this.dataReader.removePacketReceiveListener(listener);
    }

    protected void addDataListener(IDataReceiveListener listener) {
        if (listener == null) {
            throw new NullPointerException("Listener cannot be null.");
        }
        if (this.dataReader == null) {
            return;
        }
        this.dataReader.addDataReceiveListener(listener);
    }

    protected void removeDataListener(IDataReceiveListener listener) {
        if (listener == null) {
            throw new NullPointerException("Listener cannot be null.");
        }
        if (this.dataReader == null) {
            return;
        }
        this.dataReader.removeDataReceiveListener(listener);
    }

    protected void addIOSampleListener(IIOSampleReceiveListener listener) {
        if (listener == null) {
            throw new NullPointerException("Listener cannot be null.");
        }
        if (this.dataReader == null) {
            return;
        }
        this.dataReader.addIOSampleReceiveListener(listener);
    }

    protected void removeIOSampleListener(IIOSampleReceiveListener listener) {
        if (listener == null) {
            throw new NullPointerException("Listener cannot be null.");
        }
        if (this.dataReader == null) {
            return;
        }
        this.dataReader.removeIOSampleReceiveListener(listener);
    }

    protected void addModemStatusListener(IModemStatusReceiveListener listener) {
        if (listener == null) {
            throw new NullPointerException("Listener cannot be null.");
        }
        if (this.dataReader == null) {
            return;
        }
        this.dataReader.addModemStatusReceiveListener(listener);
    }

    protected void removeModemStatusListener(IModemStatusReceiveListener listener) {
        if (listener == null) {
            throw new NullPointerException("Listener cannot be null.");
        }
        if (this.dataReader == null) {
            return;
        }
        this.dataReader.removeModemStatusReceiveListener(listener);
    }

    protected void addExplicitDataListener(IExplicitDataReceiveListener listener) {
        if (listener == null) {
            throw new NullPointerException("Listener cannot be null.");
        }
        if (this.dataReader == null) {
            return;
        }
        this.dataReader.addExplicitDataReceiveListener(listener);
    }

    protected void removeExplicitDataListener(IExplicitDataReceiveListener listener) {
        if (listener == null) {
            throw new NullPointerException("Listener cannot be null.");
        }
        if (this.dataReader == null) {
            return;
        }
        this.dataReader.removeExplicitDataReceiveListener(listener);
    }

    protected void addIPDataListener(IIPDataReceiveListener listener) {
        if (listener == null) {
            throw new NullPointerException("Listener cannot be null.");
        }
        if (this.dataReader == null) {
            return;
        }
        this.dataReader.addIPDataReceiveListener(listener);
    }

    protected void removeIPDataListener(IIPDataReceiveListener listener) {
        if (listener == null) {
            throw new NullPointerException("Listener cannot be null.");
        }
        if (this.dataReader == null) {
            return;
        }
        this.dataReader.removeIPDataReceiveListener(listener);
    }

    protected void addSMSListener(ISMSReceiveListener listener) {
        if (listener == null) {
            throw new NullPointerException("Listener cannot be null.");
        }
        if (this.dataReader == null) {
            return;
        }
        this.dataReader.addSMSReceiveListener(listener);
    }

    protected void removeSMSListener(ISMSReceiveListener listener) {
        if (listener == null) {
            throw new NullPointerException("Listener cannot be null.");
        }
        if (this.dataReader == null) {
            return;
        }
        this.dataReader.removeSMSReceiveListener(listener);
    }

    protected void addUserDataRelayListener(IUserDataRelayReceiveListener listener) {
        if (listener == null) {
            throw new NullPointerException("Listener cannot be null.");
        }
        if (this.dataReader == null) {
            return;
        }
        this.dataReader.addUserDataRelayReceiveListener(listener);
    }

    protected void removeUserDataRelayListener(IUserDataRelayReceiveListener listener) {
        if (listener == null) {
            throw new NullPointerException("Listener cannot be null.");
        }
        if (this.dataReader == null) {
            return;
        }
        this.dataReader.removeUserDataRelayReceiveListener(listener);
    }

    protected void addBluetoothDataListener(IBluetoothDataReceiveListener listener) {
        if (listener == null) {
            throw new NullPointerException("Listener cannot be null.");
        }
        if (this.dataReader == null) {
            return;
        }
        this.dataReader.addBluetoothDataReceiveListener(listener);
    }

    protected void removeBluetoothDataListener(IBluetoothDataReceiveListener listener) {
        if (listener == null) {
            throw new NullPointerException("Listener cannot be null.");
        }
        if (this.dataReader == null) {
            return;
        }
        this.dataReader.removeBluetoothDataReceiveListener(listener);
    }

    protected void addMicroPythonDataListener(IMicroPythonDataReceiveListener listener) {
        if (listener == null) {
            throw new NullPointerException("Listener cannot be null.");
        }
        if (this.dataReader == null) {
            return;
        }
        this.dataReader.addMicroPythonDataReceiveListener(listener);
    }

    protected void removeMicroPythonDataListener(IMicroPythonDataReceiveListener listener) {
        if (listener == null) {
            throw new NullPointerException("Listener cannot be null.");
        }
        if (this.dataReader == null) {
            return;
        }
        this.dataReader.removeMicroPythonDataReceiveListener(listener);
    }

    protected void addSerialDataListener(ISerialDataReceiveListener listener) {
        if (listener == null) {
            throw new NullPointerException("Listener cannot be null.");
        }
        if (this.dataReader == null) {
            return;
        }
        this.dataReader.addSerialDataReceiveListener(listener);
    }

    protected void removeSerialDataListener(ISerialDataReceiveListener listener) {
        if (listener == null) {
            throw new NullPointerException("Listener cannot be null.");
        }
        if (this.dataReader == null) {
            return;
        }
        this.dataReader.removeSerialDataReceiveListener(listener);
    }

    protected ATCommandResponse sendATCommand(ATCommand command) throws InvalidOperatingModeException, TimeoutException, IOException {
        XBeeAPIPacket packet;
        if (command == null) {
            throw new NullPointerException("AT command cannot be null.");
        }
        if (!this.connectionInterface.isOpen()) {
            throw new InterfaceNotOpenException();
        }
        ATCommandResponse response = null;
        OperatingMode operatingMode = this.getOperatingMode();
        switch (operatingMode) {
            default: {
                throw new InvalidOperatingModeException(operatingMode);
            }
            case API: 
            case API_ESCAPE: 
        }
        if (this.isRemote()) {
            int remoteATCommandOptions = 0;
            if (this.isApplyConfigurationChangesEnabled()) {
                remoteATCommandOptions |= 2;
            }
            if (this.getXBeeProtocol() == XBeeProtocol.THREAD) {
                packet = new IPv6RemoteATCommandRequestPacket(this.getNextFrameID(), this.ipv6Address, remoteATCommandOptions, command.getCommand(), command.getParameter());
            } else {
                XBee16BitAddress remote16BitAddress = this.get16BitAddress();
                if (remote16BitAddress == null) {
                    remote16BitAddress = XBee16BitAddress.UNKNOWN_ADDRESS;
                }
                packet = new RemoteATCommandPacket(this.getNextFrameID(), this.get64BitAddress(), remote16BitAddress, remoteATCommandOptions, command.getCommand(), command.getParameter());
            }
        } else {
            packet = this.isApplyConfigurationChangesEnabled() ? new ATCommandPacket(this.getNextFrameID(), command.getCommand(), command.getParameter()) : new ATCommandQueuePacket(this.getNextFrameID(), command.getCommand(), command.getParameter());
        }
        if (command.getParameter() == null) {
            this.logger.debug(this.toString() + "Sending AT command '{}'.", (Object)command.getCommand());
        } else {
            this.logger.debug(this.toString() + "Sending AT command '{} {}'.", (Object)command.getCommand(), (Object)HexUtils.prettyHexString(command.getParameter()));
        }
        try {
            XBeeAPIPacket r;
            XBeePacket answerPacket = this.isRemote() ? this.localXBeeDevice.sendXBeePacket(packet) : this.sendXBeePacket(packet);
            if (answerPacket instanceof ATCommandResponsePacket) {
                r = (ATCommandResponsePacket)answerPacket;
                response = new ATCommandResponse(command, ((ATCommandResponsePacket)r).getCommandValue(), ((ATCommandResponsePacket)r).getStatus());
            } else if (answerPacket instanceof RemoteATCommandResponsePacket) {
                r = (RemoteATCommandResponsePacket)answerPacket;
                response = new ATCommandResponse(command, ((RemoteATCommandResponsePacket)r).getCommandValue(), ((RemoteATCommandResponsePacket)r).getStatus());
            } else if (answerPacket instanceof IPv6RemoteATCommandResponsePacket) {
                r = (IPv6RemoteATCommandResponsePacket)answerPacket;
                response = new ATCommandResponse(command, ((IPv6RemoteATCommandResponsePacket)r).getCommandValue(), ((IPv6RemoteATCommandResponsePacket)r).getStatus());
            }
            if (response != null && response.getResponse() != null) {
                this.logger.debug(this.toString() + "AT command response: {}.", (Object)HexUtils.prettyHexString(response.getResponse()));
            } else {
                this.logger.debug(this.toString() + "AT command response: null.");
            }
        }
        catch (ClassCastException e) {
            this.logger.error("Received an invalid packet type after sending an AT command packet." + e);
        }
        return response;
    }

    protected void sendXBeePacketAsync(XBeePacket packet) throws InvalidOperatingModeException, IOException {
        this.sendXBeePacket(packet, null);
    }

    protected void sendXBeePacket(XBeePacket packet, IPacketReceiveListener packetReceiveListener) throws InvalidOperatingModeException, IOException {
        if (packet == null) {
            throw new NullPointerException("XBee packet cannot be null.");
        }
        if (!this.connectionInterface.isOpen()) {
            throw new InterfaceNotOpenException();
        }
        OperatingMode operatingMode = this.getOperatingMode();
        switch (operatingMode) {
            default: {
                throw new InvalidOperatingModeException(operatingMode);
            }
            case API: 
            case API_ESCAPE: 
        }
        if (packet instanceof XBeeAPIPacket) {
            this.insertFrameID(packet);
            XBeeAPIPacket apiPacket = (XBeeAPIPacket)packet;
            if (packetReceiveListener != null && apiPacket.needsAPIFrameID()) {
                this.dataReader.addPacketReceiveListener(packetReceiveListener, apiPacket.getFrameID());
            } else if (packetReceiveListener != null) {
                this.dataReader.addPacketReceiveListener(packetReceiveListener);
            }
        }
        this.writePacket(packet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected XBeePacket sendXBeePacket(XBeePacket packet) throws InvalidOperatingModeException, TimeoutException, IOException {
        if (packet == null) {
            throw new NullPointerException("XBee packet cannot be null.");
        }
        if (!this.connectionInterface.isOpen()) {
            throw new InterfaceNotOpenException();
        }
        OperatingMode operatingMode = this.getOperatingMode();
        switch (operatingMode) {
            default: {
                throw new InvalidOperatingModeException(operatingMode);
            }
            case API: 
            case API_ESCAPE: 
        }
        ArrayList<XBeePacket> responseList = new ArrayList<XBeePacket>();
        if (packet instanceof XBeeAPIPacket) {
            if (!((XBeeAPIPacket)packet).needsAPIFrameID()) {
                this.sendXBeePacketAsync(packet);
                return null;
            }
        } else {
            this.sendXBeePacketAsync(packet);
            return null;
        }
        this.insertFrameID(packet);
        IPacketReceiveListener packetReceiveListener = this.createPacketReceivedListener(packet, responseList);
        this.addPacketListener(packetReceiveListener);
        this.writePacket(packet);
        try {
            Object object = responseList;
            synchronized (object) {
                try {
                    responseList.wait(this.receiveTimeout);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (responseList.size() < 1) {
                throw new TimeoutException();
            }
            object = responseList.get(0);
            return object;
        }
        finally {
            this.removePacketListener(packetReceiveListener);
        }
    }

    private void insertFrameID(XBeePacket xbeePacket) {
        if (xbeePacket instanceof XBeeAPIPacket) {
            return;
        }
        XBeeAPIPacket apiPacket = (XBeeAPIPacket)xbeePacket;
        if (apiPacket.needsAPIFrameID() && apiPacket.getFrameID() == 9999) {
            apiPacket.setFrameID(this.getNextFrameID());
        }
    }

    private IPacketReceiveListener createPacketReceivedListener(final XBeePacket sentPacket, final ArrayList<XBeePacket> responseList) {
        IPacketReceiveListener packetReceiveListener = new IPacketReceiveListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void packetReceived(XBeePacket receivedPacket) {
                if (((XBeeAPIPacket)receivedPacket).checkFrameID(((XBeeAPIPacket)sentPacket).getFrameID())) {
                    if (sentPacket instanceof XBeeAPIPacket && receivedPacket instanceof XBeeAPIPacket) {
                        XBeeAPIPacket sentAPIPacket = (XBeeAPIPacket)sentPacket;
                        XBeeAPIPacket receivedAPIPacket = (XBeeAPIPacket)receivedPacket;
                        if (sentAPIPacket.getFrameType() == APIFrameType.AT_COMMAND) {
                            if (receivedAPIPacket.getFrameType() != APIFrameType.AT_COMMAND_RESPONSE) {
                                return;
                            }
                            if (!((ATCommandPacket)sentAPIPacket).getCommand().equalsIgnoreCase(((ATCommandResponsePacket)receivedPacket).getCommand())) {
                                return;
                            }
                        }
                        if (sentAPIPacket.getFrameType() == APIFrameType.REMOTE_AT_COMMAND_REQUEST) {
                            if (receivedAPIPacket.getFrameType() != APIFrameType.REMOTE_AT_COMMAND_RESPONSE) {
                                return;
                            }
                            if (!((RemoteATCommandPacket)sentAPIPacket).getCommand().equalsIgnoreCase(((RemoteATCommandResponsePacket)receivedPacket).getCommand())) {
                                return;
                            }
                        }
                    }
                    if (!sentPacket.equals(receivedPacket)) {
                        responseList.add(receivedPacket);
                        ArrayList arrayList = responseList;
                        synchronized (arrayList) {
                            responseList.notify();
                        }
                    }
                }
            }
        };
        return packetReceiveListener;
    }

    private void writePacket(XBeePacket packet) throws IOException {
        this.logger.debug(this.toString() + "Sending XBee packet: \n{}", (Object)packet.toPrettyString());
        switch (this.getOperatingMode()) {
            default: {
                this.connectionInterface.writeData(packet.generateByteArray());
                break;
            }
            case API_ESCAPE: {
                this.connectionInterface.writeData(packet.generateByteArrayEscaped());
            }
        }
    }

    protected synchronized int getNextFrameID() {
        if (this.isRemote()) {
            return this.localXBeeDevice.getNextFrameID();
        }
        this.currentFrameID = this.currentFrameID == 255 ? 1 : ++this.currentFrameID;
        return this.currentFrameID;
    }

    protected void sendAndCheckXBeePacket(XBeePacket packet, boolean asyncTransmission) throws TransmitException, XBeeException {
        XBeePacket receivedPacket = null;
        try {
            if (asyncTransmission) {
                this.sendXBeePacketAsync(packet);
            } else {
                receivedPacket = this.sendXBeePacket(packet);
            }
        }
        catch (IOException e) {
            throw new XBeeException("Error writing in the communication interface.", e);
        }
        if (asyncTransmission) {
            return;
        }
        if (receivedPacket == null) {
            throw new TransmitException(null);
        }
        XBeeTransmitStatus status = null;
        if (receivedPacket instanceof TransmitStatusPacket) {
            status = ((TransmitStatusPacket)receivedPacket).getTransmitStatus();
        } else if (receivedPacket instanceof TXStatusPacket) {
            status = ((TXStatusPacket)receivedPacket).getTransmitStatus();
        }
        if (status != XBeeTransmitStatus.SUCCESS && status != XBeeTransmitStatus.SELF_ADDRESSED) {
            throw new TransmitException(status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] sendAndCheckCoAPPacket(CoAPTxRequestPacket packet, boolean asyncTransmission) throws TransmitException, XBeeException {
        ArrayList<CoAPRxResponsePacket> coapResponsePackets = new ArrayList<CoAPRxResponsePacket>();
        IPacketReceiveListener listener = this.createCoAPResponseListener(coapResponsePackets);
        this.addPacketListener(listener);
        XBeePacket receivedPacket = null;
        try {
            if (asyncTransmission) {
                this.sendXBeePacketAsync(packet);
            } else {
                receivedPacket = this.sendXBeePacket(packet);
            }
        }
        catch (IOException e) {
            throw new XBeeException("Error writing in the communication interface.", e);
        }
        if (asyncTransmission) {
            return null;
        }
        if (receivedPacket == null) {
            throw new TransmitException(null);
        }
        XBeeTransmitStatus status = null;
        if (receivedPacket instanceof TXStatusPacket) {
            status = ((TXStatusPacket)receivedPacket).getTransmitStatus();
        }
        if (status == null || status != XBeeTransmitStatus.SUCCESS && status != XBeeTransmitStatus.SELF_ADDRESSED) {
            throw new TransmitException(status);
        }
        CoAPRxResponsePacket coapRxPacket = null;
        try {
            coapRxPacket = this.waitForCoAPRxResponsePacket(coapResponsePackets);
        }
        finally {
            this.removePacketListener(listener);
        }
        if (coapRxPacket == null) {
            throw new XBeeException("CoAP response was null.");
        }
        return coapRxPacket.getData();
    }

    private IPacketReceiveListener createCoAPResponseListener(final ArrayList<CoAPRxResponsePacket> coapResponsePackets) {
        IPacketReceiveListener listener = new IPacketReceiveListener(){

            @Override
            public void packetReceived(XBeePacket receivedPacket) {
                if (receivedPacket instanceof CoAPRxResponsePacket) {
                    coapResponsePackets.add((CoAPRxResponsePacket)receivedPacket);
                    coapResponsePackets.notifyAll();
                }
            }
        };
        return listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoAPRxResponsePacket waitForCoAPRxResponsePacket(ArrayList<CoAPRxResponsePacket> coapResponsePackets) throws XBeeException {
        ArrayList<CoAPRxResponsePacket> arrayList = coapResponsePackets;
        synchronized (arrayList) {
            try {
                coapResponsePackets.wait(this.receiveTimeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (!coapResponsePackets.isEmpty()) {
            RestFulStatusEnum responseStatus = coapResponsePackets.get(0).getStatus();
            if (responseStatus != RestFulStatusEnum.SUCCESS && responseStatus != RestFulStatusEnum.CREATED && responseStatus != RestFulStatusEnum.ACCEPTED && responseStatus != RestFulStatusEnum.NON_AUTHORITATIVE && responseStatus != RestFulStatusEnum.NO_CONTENT && responseStatus != RestFulStatusEnum.RESET_CONTENT) {
                throw new XBeeException("CoAP response had an unexpected status: " + responseStatus.toString());
            }
        } else {
            throw new XBeeException("CoAP response was not received.");
        }
        return coapResponsePackets.get(0);
    }

    public void setIOConfiguration(IOLine ioLine, IOMode ioMode) throws TimeoutException, XBeeException {
        if (ioLine == null) {
            throw new NullPointerException("IO line cannot be null.");
        }
        if (ioMode == null) {
            throw new NullPointerException("IO mode cannot be null.");
        }
        if (!this.connectionInterface.isOpen()) {
            throw new InterfaceNotOpenException();
        }
        this.setParameter(ioLine.getConfigurationATCommand(), new byte[]{(byte)ioMode.getID()});
    }

    public IOMode getIOConfiguration(IOLine ioLine) throws TimeoutException, XBeeException {
        if (ioLine == null) {
            throw new NullPointerException("DIO pin cannot be null.");
        }
        if (!this.connectionInterface.isOpen()) {
            throw new InterfaceNotOpenException();
        }
        byte ioModeValue = this.getParameter(ioLine.getConfigurationATCommand())[0];
        IOMode dioMode = IOMode.getIOMode(ioModeValue, ioLine);
        if (dioMode == null) {
            throw new OperationNotSupportedException("Received configuration mode '" + HexUtils.integerToHexString(ioModeValue, 1) + "' is not valid.");
        }
        return dioMode;
    }

    public void setDIOValue(IOLine ioLine, IOValue ioValue) throws TimeoutException, XBeeException {
        if (ioLine == null) {
            throw new NullPointerException("IO line cannot be null.");
        }
        if (ioValue == null) {
            throw new NullPointerException("IO value cannot be null.");
        }
        if (!this.connectionInterface.isOpen()) {
            throw new InterfaceNotOpenException();
        }
        this.setParameter(ioLine.getConfigurationATCommand(), new byte[]{(byte)ioValue.getID()});
    }

    public IOValue getDIOValue(IOLine ioLine) throws TimeoutException, XBeeException {
        if (ioLine == null) {
            throw new NullPointerException("IO line cannot be null.");
        }
        IOSample ioSample = this.readIOSample();
        if (!ioSample.hasDigitalValues() || !ioSample.getDigitalValues().containsKey((Object)ioLine)) {
            throw new OperationNotSupportedException("Answer does not contain digital data for " + ioLine.getName() + ".");
        }
        return ioSample.getDigitalValues().get((Object)ioLine);
    }

    public void setPWMDutyCycle(IOLine ioLine, double dutyCycle) throws TimeoutException, XBeeException {
        if (ioLine == null) {
            throw new NullPointerException("IO line cannot be null.");
        }
        if (!ioLine.hasPWMCapability()) {
            throw new IllegalArgumentException("Provided IO line does not have PWM capability.");
        }
        if (dutyCycle < 0.0 || dutyCycle > 100.0) {
            throw new IllegalArgumentException("Duty Cycle must be between 0% and 100%.");
        }
        if (!this.connectionInterface.isOpen()) {
            throw new InterfaceNotOpenException();
        }
        int finaldutyCycle = (int)(dutyCycle * 1023.0 / 100.0);
        this.setParameter(ioLine.getPWMDutyCycleATCommand(), ByteUtils.intToByteArray(finaldutyCycle));
    }

    public double getPWMDutyCycle(IOLine ioLine) throws TimeoutException, XBeeException {
        if (ioLine == null) {
            throw new NullPointerException("IO line cannot be null.");
        }
        if (!ioLine.hasPWMCapability()) {
            throw new IllegalArgumentException("Provided IO line does not have PWM capability.");
        }
        if (!this.connectionInterface.isOpen()) {
            throw new InterfaceNotOpenException();
        }
        byte[] value = this.getParameter(ioLine.getPWMDutyCycleATCommand());
        int readValue = ByteUtils.byteArrayToInt(value);
        return (double)Math.round((double)readValue * 100.0 / 1023.0 * 100.0) / 100.0;
    }

    public int getADCValue(IOLine ioLine) throws TimeoutException, XBeeException {
        if (ioLine == null) {
            throw new NullPointerException("IO line cannot be null.");
        }
        IOSample ioSample = this.readIOSample();
        if (!ioSample.hasAnalogValues() || !ioSample.getAnalogValues().containsKey((Object)ioLine)) {
            throw new OperationNotSupportedException("Answer does not contain analog data for " + ioLine.getName() + ".");
        }
        return ioSample.getAnalogValues().get((Object)ioLine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDestinationAddress(XBee64BitAddress xbee64BitAddress) throws TimeoutException, XBeeException {
        if (xbee64BitAddress == null) {
            throw new NullPointerException("Address cannot be null.");
        }
        boolean applyChanges = this.isApplyConfigurationChangesEnabled();
        if (applyChanges) {
            this.enableApplyConfigurationChanges(false);
        }
        byte[] address = xbee64BitAddress.getValue();
        try {
            this.setParameter("DH", Arrays.copyOfRange(address, 0, 4));
            this.setParameter("DL", Arrays.copyOfRange(address, 4, 8));
            this.applyChanges();
        }
        finally {
            this.enableApplyConfigurationChanges(applyChanges);
        }
    }

    public XBee64BitAddress getDestinationAddress() throws TimeoutException, XBeeException {
        byte[] dh = this.getParameter("DH");
        byte[] dl = this.getParameter("DL");
        byte[] address = new byte[dh.length + dl.length];
        System.arraycopy(dh, 0, address, 0, dh.length);
        System.arraycopy(dl, 0, address, dh.length, dl.length);
        return new XBee64BitAddress(address);
    }

    public void setIPv6DestinationAddress(Inet6Address ipv6Address) throws TimeoutException, XBeeException {
        if (ipv6Address == null) {
            throw new NullPointerException("Destination IPv6 address cannot be null.");
        }
        this.setParameter("DL", ipv6Address.getAddress());
    }

    public Inet6Address getIPv6DestinationAddress() throws TimeoutException, XBeeException {
        try {
            return (Inet6Address)Inet6Address.getByAddress(this.getParameter("DL"));
        }
        catch (UnknownHostException e) {
            throw new XBeeException(e);
        }
    }

    public void setIOSamplingRate(int rate) throws TimeoutException, XBeeException {
        if (rate < 0 || rate > 65535) {
            throw new IllegalArgumentException("Rate must be between 0 and 0xFFFF.");
        }
        if (!this.connectionInterface.isOpen()) {
            throw new InterfaceNotOpenException();
        }
        this.setParameter("IR", ByteUtils.intToByteArray(rate));
    }

    public int getIOSamplingRate() throws TimeoutException, XBeeException {
        if (!this.connectionInterface.isOpen()) {
            throw new InterfaceNotOpenException();
        }
        byte[] rate = this.getParameter("IR");
        return ByteUtils.byteArrayToInt(rate);
    }

    public void setDIOChangeDetection(Set<IOLine> lines) throws TimeoutException, XBeeException {
        if (!this.connectionInterface.isOpen()) {
            throw new InterfaceNotOpenException();
        }
        byte[] bitfield = new byte[2];
        if (lines != null) {
            for (IOLine line : lines) {
                int i = line.getIndex();
                if (i < 8) {
                    bitfield[1] = (byte)(bitfield[1] | 1 << i);
                    continue;
                }
                bitfield[0] = (byte)(bitfield[0] | 1 << i - 8);
            }
        }
        this.setParameter("IC", bitfield);
    }

    public Set<IOLine> getDIOChangeDetection() throws TimeoutException, XBeeException {
        if (!this.connectionInterface.isOpen()) {
            throw new InterfaceNotOpenException();
        }
        byte[] bitfield = this.getParameter("IC");
        TreeSet<IOLine> lines = new TreeSet<IOLine>();
        int mask = (bitfield[0] << 8) + (bitfield[1] & 0xFF);
        for (int i = 0; i < 16; ++i) {
            if (!ByteUtils.isBitEnabled(mask, i)) continue;
            lines.add(IOLine.getDIO(i));
        }
        if (lines.size() > 0) {
            return lines;
        }
        return null;
    }

    public void applyChanges() throws TimeoutException, XBeeException {
        this.executeParameter("AC");
    }

    protected void checkATCommandResponseIsValid(ATCommandResponse response) throws ATCommandException {
        if (response == null || response.getResponseStatus() == null) {
            throw new ATCommandException(null);
        }
        if (response.getResponseStatus() != ATCommandStatus.OK) {
            throw new ATCommandException(response.getResponseStatus());
        }
    }

    public IOSample readIOSample() throws TimeoutException, XBeeException {
        IOSample ioSample;
        if (!this.connectionInterface.isOpen()) {
            throw new InterfaceNotOpenException();
        }
        byte[] samplePayload = null;
        if (!this.isRemote() && this.getXBeeProtocol() == XBeeProtocol.RAW_802_15_4) {
            this.executeParameter("IS");
            samplePayload = this.receiveRaw802IOPacket();
            if (samplePayload == null) {
                throw new TimeoutException("Timeout waiting for the IO response packet.");
            }
        } else {
            samplePayload = this.getParameter("IS");
        }
        try {
            ioSample = new IOSample(samplePayload);
        }
        catch (IllegalArgumentException e) {
            throw new XBeeException("Couldn't create the IO sample.", e);
        }
        catch (NullPointerException e) {
            throw new XBeeException("Couldn't create the IO sample.", e);
        }
        return ioSample;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] receiveRaw802IOPacket() {
        this.ioPacketReceived = false;
        this.ioPacketPayload = null;
        this.addPacketListener(this.IOPacketReceiveListener);
        Object object = this.ioLock;
        synchronized (object) {
            try {
                this.ioLock.wait(this.receiveTimeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.removePacketListener(this.IOPacketReceiveListener);
        if (this.ioPacketReceived) {
            return this.ioPacketPayload;
        }
        return null;
    }

    public abstract void reset() throws TimeoutException, XBeeException;

    public void setParameter(String parameter, byte[] parameterValue) throws TimeoutException, XBeeException {
        if (parameterValue == null) {
            throw new NullPointerException("Value of the parameter cannot be null.");
        }
        this.sendParameter(parameter, parameterValue);
    }

    public byte[] getParameter(String parameter) throws TimeoutException, XBeeException {
        byte[] parameterValue = this.sendParameter(parameter, null);
        if (parameterValue == null) {
            throw new OperationNotSupportedException("Couldn't get the '" + parameter + "' value.");
        }
        return parameterValue;
    }

    public void executeParameter(String parameter) throws TimeoutException, XBeeException {
        this.sendParameter(parameter, null);
    }

    private byte[] sendParameter(String parameter, byte[] parameterValue) throws TimeoutException, XBeeException {
        if (parameter == null) {
            throw new NullPointerException("Parameter cannot be null.");
        }
        if (parameter.length() != 2) {
            throw new IllegalArgumentException("Parameter must contain exactly 2 characters.");
        }
        ATCommand atCommand = new ATCommand(parameter, parameterValue);
        ATCommandResponse response = null;
        try {
            response = this.sendATCommand(atCommand);
        }
        catch (IOException e) {
            throw new XBeeException("Error writing in the communication interface.", e);
        }
        this.checkATCommandResponseIsValid(response);
        return response.getResponse();
    }

    public String toString() {
        String addr64;
        String id = this.getNodeID() == null ? "" : this.getNodeID();
        String string = addr64 = this.get64BitAddress() == null || this.get64BitAddress().equals(XBee64BitAddress.UNKNOWN_ADDRESS) ? "" : this.get64BitAddress().toString();
        if (id.length() == 0 && addr64.length() == 0) {
            return this.connectionInterface.toString();
        }
        StringBuilder message = new StringBuilder(this.connectionInterface.toString());
        message.append(addr64);
        if (id.length() > 0) {
            message.append(" (");
            message.append(id);
            message.append(")");
        }
        message.append(" - ");
        return message.toString();
    }

    public void enableApplyConfigurationChanges(boolean enabled) {
        this.applyConfigurationChanges = enabled;
    }

    public boolean isApplyConfigurationChangesEnabled() {
        return this.applyConfigurationChanges;
    }

    protected void set16BitAddress(XBee16BitAddress xbee16BitAddress) throws TimeoutException, XBeeException {
        if (xbee16BitAddress == null) {
            throw new NullPointerException("16-bit address canot be null.");
        }
        this.setParameter("MY", xbee16BitAddress.getValue());
        this.xbee16BitAddress = xbee16BitAddress;
    }

    public byte[] getPANID() throws TimeoutException, XBeeException {
        switch (this.getXBeeProtocol()) {
            case ZIGBEE: {
                return this.getParameter("OP");
            }
        }
        return this.getParameter("ID");
    }

    public void setPANID(byte[] panID) throws TimeoutException, XBeeException {
        if (panID == null) {
            throw new NullPointerException("PAN ID cannot be null.");
        }
        if (panID.length == 0) {
            throw new IllegalArgumentException("Length of the PAN ID cannot be 0.");
        }
        if (panID.length > 8) {
            throw new IllegalArgumentException("Length of the PAN ID cannot be longer than 8 bytes.");
        }
        this.setParameter("ID", panID);
    }

    public PowerLevel getPowerLevel() throws TimeoutException, XBeeException {
        byte[] powerLevelValue = this.getParameter("PL");
        return PowerLevel.get(ByteUtils.byteArrayToInt(powerLevelValue));
    }

    public void setPowerLevel(PowerLevel powerLevel) throws TimeoutException, XBeeException {
        if (powerLevel == null) {
            throw new NullPointerException("Power level cannot be null.");
        }
        this.setParameter("PL", ByteUtils.intToByteArray(powerLevel.getValue()));
    }

    protected AssociationIndicationStatus getAssociationIndicationStatus() throws TimeoutException, XBeeException {
        byte[] associationIndicationValue = this.getParameter("AI");
        return AssociationIndicationStatus.get(ByteUtils.byteArrayToInt(associationIndicationValue));
    }

    protected void forceDisassociate() throws TimeoutException, XBeeException {
        this.executeParameter("DA");
    }

    public void writeChanges() throws TimeoutException, XBeeException {
        this.executeParameter("WR");
    }

    public void enableBluetooth() throws TimeoutException, XBeeException {
        this.enableBluetooth(true);
    }

    public void disableBluetooth() throws TimeoutException, XBeeException {
        this.enableBluetooth(false);
    }

    private void enableBluetooth(boolean enable) throws TimeoutException, XBeeException {
        this.setParameter("BT", new byte[]{(byte)(enable ? 1 : 0)});
        this.writeChanges();
        this.applyChanges();
    }

    public String getBluetoothMacAddress() throws TimeoutException, XBeeException {
        return HexUtils.byteArrayToHexString(this.getParameter("BL"));
    }

    public void updateBluetoothPassword(String newPassword) throws TimeoutException, XBeeException {
        byte[] verifier;
        byte[] salt = SrpUtils.generateSalt();
        try {
            verifier = SrpUtils.generateVerifier(salt, newPassword);
        }
        catch (IOException | NoSuchAlgorithmException e) {
            throw new XBeeException(e);
        }
        this.setParameter("$S", salt);
        int index = 0;
        int atLength = verifier.length / 4;
        this.setParameter("$V", Arrays.copyOfRange(verifier, index, index + atLength));
        this.setParameter("$W", Arrays.copyOfRange(verifier, index += atLength, index + atLength));
        this.setParameter("$X", Arrays.copyOfRange(verifier, index += atLength, index + atLength));
        this.setParameter("$Y", Arrays.copyOfRange(verifier, index += atLength, index + atLength));
        this.writeChanges();
        this.applyChanges();
    }

    protected void open() throws XBeeException {
        this.logger.info(this.toString() + "Opening the connection interface...");
        if (this.isRemote()) {
            throw new OperationNotSupportedException("Remote devices cannot be open.");
        }
        if (this.connectionInterface.isOpen()) {
            throw new InterfaceAlreadyOpenException();
        }
        this.connectionInterface.open();
        this.logger.info(this.toString() + "Connection interface open.");
        this.dataReader = new DataReader(this.connectionInterface, this.operatingMode, this);
        this.dataReader.start();
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.connectionInterface.getConnectionType() == ConnectionType.BLUETOOTH) {
            this.operatingMode = OperatingMode.API;
            this.dataReader.setXBeeReaderMode(this.operatingMode);
            try {
                this.logger.info(this.toString() + "Starting Bluetooth authentication...");
                BluetoothAuthentication auth = new BluetoothAuthentication(this, this.bluetoothPassword);
                auth.authenticate();
                ((AbstractBluetoothInterface)this.connectionInterface).setEncryptionKeys(auth.getKey(), auth.getTxNonce(), auth.getRxNonce());
                this.logger.info(this.toString() + "Authentication finished successfully.");
            }
            catch (BluetoothAuthenticationException e) {
                this.close();
                throw e;
            }
        } else {
            if (this.operatingMode == OperatingMode.UNKNOWN) {
                this.operatingMode = this.determineOperatingMode();
            }
            if (this.operatingMode == OperatingMode.UNKNOWN) {
                this.close();
                throw new InvalidOperatingModeException("Could not determine operating mode.");
            }
            if (this.operatingMode != OperatingMode.API && this.operatingMode != OperatingMode.API_ESCAPE) {
                this.close();
                throw new InvalidOperatingModeException(this.operatingMode);
            }
        }
        try {
            this.readDeviceInfo();
        }
        catch (ATCommandException e) {
            throw new XBeeException("Error reading device information.", e);
        }
    }

    protected void close() {
        if (this.dataReader != null && this.dataReader.isRunning()) {
            this.dataReader.stopReader();
        }
        this.connectionInterface.close();
        this.logger.info(this.toString() + "Connection interface closed.");
    }

    protected OperatingMode determineOperatingMode() throws OperationNotSupportedException {
        try {
            this.operatingMode = OperatingMode.API;
            this.dataReader.setXBeeReaderMode(this.operatingMode);
            ATCommandResponse response = this.sendATCommand(new ATCommand("AP"));
            if (response.getResponse() != null && response.getResponse().length > 0) {
                if (response.getResponse()[0] != OperatingMode.API.getID()) {
                    this.operatingMode = OperatingMode.API_ESCAPE;
                    this.dataReader.setXBeeReaderMode(this.operatingMode);
                }
                this.logger.debug(this.toString() + "Using {}.", (Object)this.operatingMode.getName());
                return this.operatingMode;
            }
        }
        catch (TimeoutException e) {
            this.operatingMode = OperatingMode.AT;
            this.dataReader.setXBeeReaderMode(this.operatingMode);
            try {
                Thread.sleep(1200L);
                if (this.enterATCommandMode()) {
                    this.operatingMode = this.getActualMode();
                    this.logger.debug(this.toString() + "Using {}.", (Object)this.operatingMode.getName());
                    this.dataReader.setXBeeReaderMode(this.operatingMode);
                    OperatingMode operatingMode = this.operatingMode;
                    return operatingMode;
                }
            }
            catch (TimeoutException e1) {
                this.logger.error(e1.getMessage(), (Throwable)e1);
            }
            catch (InvalidOperatingModeException e1) {
                this.logger.error(e1.getMessage(), (Throwable)e1);
            }
            catch (InterruptedException e1) {
                this.logger.error(e1.getMessage(), (Throwable)e1);
            }
            finally {
                this.exitATCommandMode();
            }
        }
        catch (InvalidOperatingModeException e) {
            this.logger.error("Invalid operating mode", (Throwable)e);
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return OperatingMode.UNKNOWN;
    }

    private boolean enterATCommandMode() throws InvalidOperatingModeException, TimeoutException {
        if (!this.connectionInterface.isOpen()) {
            throw new InterfaceNotOpenException();
        }
        if (this.operatingMode == OperatingMode.API || this.operatingMode == OperatingMode.API_ESCAPE) {
            throw new InvalidOperatingModeException("Invalid mode. Command mode can be only accessed while in AT mode.");
        }
        byte[] readData = new byte[256];
        try {
            this.connectionInterface.writeData(COMMAND_MODE_CHAR.getBytes());
            this.connectionInterface.writeData(COMMAND_MODE_CHAR.getBytes());
            this.connectionInterface.writeData(COMMAND_MODE_CHAR.getBytes());
            Thread.sleep(1500L);
            int readBytes = this.connectionInterface.readData(readData);
            if (readBytes < COMMAND_MODE_OK.length()) {
                throw new TimeoutException();
            }
            String readString = new String(readData, 0, readBytes);
            return readString.contains(COMMAND_MODE_OK);
        }
        catch (IOException | InterruptedException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private void exitATCommandMode() {
        if (!this.connectionInterface.isOpen()) {
            throw new InterfaceNotOpenException();
        }
        try {
            this.connectionInterface.writeData(COMMAND_MODE_EXIT.getBytes());
            Thread.sleep(1500L);
        }
        catch (IOException | InterruptedException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private OperatingMode getActualMode() throws InvalidOperatingModeException {
        if (!this.connectionInterface.isOpen()) {
            throw new InterfaceNotOpenException();
        }
        byte[] readData = new byte[256];
        try {
            if (this.connectionInterface instanceof AbstractSerialPort) {
                ((AbstractSerialPort)this.connectionInterface).purge();
            }
            this.connectionInterface.writeData(COMMAND_MODE_AP.getBytes());
            Thread.sleep(100L);
            int readBytes = this.connectionInterface.readData(readData);
            if (readBytes == 0) {
                return OperatingMode.UNKNOWN;
            }
            return OperatingMode.get(Integer.parseInt(new String(readData).trim(), 16));
        }
        catch (IOException | InterruptedException | NumberFormatException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return OperatingMode.UNKNOWN;
        }
    }

    protected boolean isOpen() {
        if (this.connectionInterface != null) {
            return this.connectionInterface.isOpen();
        }
        return false;
    }

    protected XBeeNetwork getNetwork() {
        if (this.isRemote()) {
            throw new RuntimeException("Remote devices do not have network.");
        }
        if (!this.isOpen()) {
            throw new InterfaceNotOpenException();
        }
        if (this.network == null) {
            this.network = new XBeeNetwork(this);
        }
        return this.network;
    }

    protected int getReceiveTimeout() {
        return this.receiveTimeout;
    }

    protected void setReceiveTimeout(int receiveTimeout) {
        if (receiveTimeout < 0) {
            throw new IllegalArgumentException("Receive timeout cannot be less than 0.");
        }
        this.receiveTimeout = receiveTimeout;
    }

    protected void sendDataAsync(XBee64BitAddress address, byte[] data) throws XBeeException {
        XBeeAPIPacket xbeePacket;
        if (address == null) {
            throw new NullPointerException("Address cannot be null");
        }
        if (data == null) {
            throw new NullPointerException("Data cannot be null");
        }
        if (this.isRemote()) {
            throw new OperationNotSupportedException("Cannot send data to a remote device from a remote device.");
        }
        this.logger.debug(this.toString() + "Sending data asynchronously to {} >> {}.", (Object)address, (Object)HexUtils.prettyHexString(data));
        switch (this.getXBeeProtocol()) {
            case RAW_802_15_4: {
                xbeePacket = new TX64Packet(this.getNextFrameID(), address, 0, data);
                break;
            }
            default: {
                xbeePacket = new TransmitPacket(this.getNextFrameID(), address, XBee16BitAddress.UNKNOWN_ADDRESS, 0, 0, data);
            }
        }
        this.sendAndCheckXBeePacket(xbeePacket, true);
    }

    protected void sendDataAsync(XBee64BitAddress address64Bit, XBee16BitAddress address16Bit, byte[] data) throws XBeeException {
        if (address64Bit == null) {
            throw new NullPointerException("64-bit address cannot be null");
        }
        if (address16Bit == null) {
            throw new NullPointerException("16-bit address cannot be null");
        }
        if (data == null) {
            throw new NullPointerException("Data cannot be null");
        }
        if (this.isRemote()) {
            throw new OperationNotSupportedException("Cannot send data to a remote device from a remote device.");
        }
        this.logger.debug(this.toString() + "Sending data asynchronously to {}[{}] >> {}.", new Object[]{address64Bit, address16Bit, HexUtils.prettyHexString(data)});
        TransmitPacket xbeePacket = new TransmitPacket(this.getNextFrameID(), address64Bit, address16Bit, 0, 0, data);
        this.sendAndCheckXBeePacket(xbeePacket, true);
    }

    protected void sendDataAsync(RemoteXBeeDevice remoteXBeeDevice, byte[] data) throws XBeeException {
        if (remoteXBeeDevice == null) {
            throw new NullPointerException("Remote XBee device cannot be null");
        }
        switch (this.getXBeeProtocol()) {
            case ZIGBEE: 
            case DIGI_POINT: {
                if (remoteXBeeDevice.get64BitAddress() != null && remoteXBeeDevice.get16BitAddress() != null) {
                    this.sendDataAsync(remoteXBeeDevice.get64BitAddress(), remoteXBeeDevice.get16BitAddress(), data);
                    break;
                }
                this.sendDataAsync(remoteXBeeDevice.get64BitAddress(), data);
                break;
            }
            case RAW_802_15_4: {
                if (this instanceof Raw802Device) {
                    if (remoteXBeeDevice.get64BitAddress() != null) {
                        ((Raw802Device)this).sendDataAsync(remoteXBeeDevice.get64BitAddress(), data);
                        break;
                    }
                    ((Raw802Device)this).sendDataAsync(remoteXBeeDevice.get16BitAddress(), data);
                    break;
                }
                this.sendDataAsync(remoteXBeeDevice.get64BitAddress(), data);
                break;
            }
            default: {
                this.sendDataAsync(remoteXBeeDevice.get64BitAddress(), data);
            }
        }
    }

    protected void sendData(XBee64BitAddress address, byte[] data) throws TimeoutException, XBeeException {
        XBeeAPIPacket xbeePacket;
        if (address == null) {
            throw new NullPointerException("Address cannot be null");
        }
        if (data == null) {
            throw new NullPointerException("Data cannot be null");
        }
        if (this.isRemote()) {
            throw new OperationNotSupportedException("Cannot send data to a remote device from a remote device.");
        }
        this.logger.debug(this.toString() + "Sending data to {} >> {}.", (Object)address, (Object)HexUtils.prettyHexString(data));
        switch (this.getXBeeProtocol()) {
            case RAW_802_15_4: {
                xbeePacket = new TX64Packet(this.getNextFrameID(), address, 0, data);
                break;
            }
            default: {
                xbeePacket = new TransmitPacket(this.getNextFrameID(), address, XBee16BitAddress.UNKNOWN_ADDRESS, 0, 0, data);
            }
        }
        this.sendAndCheckXBeePacket(xbeePacket, false);
    }

    protected void sendData(XBee64BitAddress address64Bit, XBee16BitAddress address16Bit, byte[] data) throws TimeoutException, XBeeException {
        if (address64Bit == null) {
            throw new NullPointerException("64-bit address cannot be null");
        }
        if (address16Bit == null) {
            throw new NullPointerException("16-bit address cannot be null");
        }
        if (data == null) {
            throw new NullPointerException("Data cannot be null");
        }
        if (this.isRemote()) {
            throw new OperationNotSupportedException("Cannot send data to a remote device from a remote device.");
        }
        this.logger.debug(this.toString() + "Sending data to {}[{}] >> {}.", new Object[]{address64Bit, address16Bit, HexUtils.prettyHexString(data)});
        TransmitPacket xbeePacket = new TransmitPacket(this.getNextFrameID(), address64Bit, address16Bit, 0, 0, data);
        this.sendAndCheckXBeePacket(xbeePacket, false);
    }

    protected void sendData(RemoteXBeeDevice remoteXBeeDevice, byte[] data) throws TimeoutException, XBeeException {
        if (remoteXBeeDevice == null) {
            throw new NullPointerException("Remote XBee device cannot be null");
        }
        switch (this.getXBeeProtocol()) {
            case ZIGBEE: 
            case DIGI_POINT: {
                if (remoteXBeeDevice.get64BitAddress() != null && remoteXBeeDevice.get16BitAddress() != null) {
                    this.sendData(remoteXBeeDevice.get64BitAddress(), remoteXBeeDevice.get16BitAddress(), data);
                    break;
                }
                this.sendData(remoteXBeeDevice.get64BitAddress(), data);
                break;
            }
            case RAW_802_15_4: {
                if (this instanceof Raw802Device) {
                    if (remoteXBeeDevice.get64BitAddress() != null) {
                        ((Raw802Device)this).sendData(remoteXBeeDevice.get64BitAddress(), data);
                        break;
                    }
                    ((Raw802Device)this).sendData(remoteXBeeDevice.get16BitAddress(), data);
                    break;
                }
                this.sendData(remoteXBeeDevice.get64BitAddress(), data);
                break;
            }
            default: {
                this.sendData(remoteXBeeDevice.get64BitAddress(), data);
            }
        }
    }

    protected void sendBroadcastData(byte[] data) throws TimeoutException, XBeeException {
        this.sendData(XBee64BitAddress.BROADCAST_ADDRESS, data);
    }

    protected void sendExplicitDataAsync(XBee64BitAddress address, int sourceEndpoint, int destEndpoint, int clusterID, int profileID, byte[] data) throws XBeeException {
        if (address == null) {
            throw new NullPointerException("Address cannot be null");
        }
        if (data == null) {
            throw new NullPointerException("Data cannot be null.");
        }
        if (sourceEndpoint < 0 || sourceEndpoint > 255) {
            throw new IllegalArgumentException("Source endpoint must be between 0 and 0xFF.");
        }
        if (destEndpoint < 0 || destEndpoint > 255) {
            throw new IllegalArgumentException("Destination endpoint must be between 0 and 0xFF.");
        }
        if (clusterID < 0 || clusterID > 65535) {
            throw new IllegalArgumentException("Cluster ID must be between 0 and 0xFFFF.");
        }
        if (profileID < 0 || profileID > 65535) {
            throw new IllegalArgumentException("Profile ID must be between 0 and 0xFFFF.");
        }
        if (this.isRemote()) {
            throw new OperationNotSupportedException("Cannot send explicit data to a remote device from a remote device.");
        }
        this.logger.debug(this.toString() + "Sending explicit data asynchronously to {} [{} - {} - {} - {}] >> {}.", new Object[]{address, String.format("%02X", sourceEndpoint), String.format("%02X", destEndpoint), String.format("%04X", clusterID), String.format("%04X", profileID), HexUtils.prettyHexString(data)});
        ExplicitAddressingPacket xbeePacket = new ExplicitAddressingPacket(this.getNextFrameID(), address, XBee16BitAddress.UNKNOWN_ADDRESS, sourceEndpoint, destEndpoint, clusterID, profileID, 0, 0, data);
        this.sendAndCheckXBeePacket(xbeePacket, true);
    }

    protected void sendExplicitDataAsync(XBee64BitAddress address64Bit, XBee16BitAddress address16Bit, int sourceEndpoint, int destEndpoint, int clusterID, int profileID, byte[] data) throws XBeeException {
        if (address64Bit == null) {
            throw new NullPointerException("64-bit address cannot be null.");
        }
        if (address16Bit == null) {
            throw new NullPointerException("16-bit address cannot be null.");
        }
        if (data == null) {
            throw new NullPointerException("Data cannot be null.");
        }
        if (sourceEndpoint < 0 || sourceEndpoint > 255) {
            throw new IllegalArgumentException("Source endpoint must be between 0 and 0xFF.");
        }
        if (destEndpoint < 0 || destEndpoint > 255) {
            throw new IllegalArgumentException("Destination endpoint must be between 0 and 0xFF.");
        }
        if (clusterID < 0 || clusterID > 65535) {
            throw new IllegalArgumentException("Cluster ID must be between 0 and 0xFFFF.");
        }
        if (profileID < 0 || profileID > 65535) {
            throw new IllegalArgumentException("Profile ID must be between 0 and 0xFFFF.");
        }
        if (this.isRemote()) {
            throw new OperationNotSupportedException("Cannot send explicit data to a remote device from a remote device.");
        }
        this.logger.debug(this.toString() + "Sending explicit data asynchronously to {}[{}] [{} - {} - {} - {}] >> {}.", new Object[]{address64Bit, address16Bit, String.format("%02X", sourceEndpoint), String.format("%02X", destEndpoint), String.format("%04X", clusterID), String.format("%04X", profileID), HexUtils.prettyHexString(data)});
        ExplicitAddressingPacket xbeePacket = new ExplicitAddressingPacket(this.getNextFrameID(), address64Bit, address16Bit, sourceEndpoint, destEndpoint, clusterID, profileID, 0, 0, data);
        this.sendAndCheckXBeePacket(xbeePacket, true);
    }

    protected void sendExplicitDataAsync(RemoteXBeeDevice remoteXBeeDevice, int sourceEndpoint, int destEndpoint, int clusterID, int profileID, byte[] data) throws XBeeException {
        if (remoteXBeeDevice == null) {
            throw new NullPointerException("Remote XBee device cannot be null");
        }
        switch (this.getXBeeProtocol()) {
            case ZIGBEE: 
            case DIGI_POINT: {
                if (remoteXBeeDevice.get64BitAddress() != null && remoteXBeeDevice.get16BitAddress() != null) {
                    this.sendExplicitDataAsync(remoteXBeeDevice.get64BitAddress(), remoteXBeeDevice.get16BitAddress(), sourceEndpoint, destEndpoint, clusterID, profileID, data);
                    break;
                }
                this.sendExplicitDataAsync(remoteXBeeDevice.get64BitAddress(), sourceEndpoint, destEndpoint, clusterID, profileID, data);
                break;
            }
            case RAW_802_15_4: {
                throw new OperationNotSupportedException("802.15.4. protocol does not support explicit data transmissions.");
            }
            default: {
                this.sendExplicitDataAsync(remoteXBeeDevice.get64BitAddress(), sourceEndpoint, destEndpoint, clusterID, profileID, data);
            }
        }
    }

    protected void sendExplicitData(XBee64BitAddress address, int sourceEndpoint, int destEndpoint, int clusterID, int profileID, byte[] data) throws TimeoutException, XBeeException {
        if (address == null) {
            throw new NullPointerException("Address cannot be null");
        }
        if (data == null) {
            throw new NullPointerException("Data cannot be null.");
        }
        if (sourceEndpoint < 0 || sourceEndpoint > 255) {
            throw new IllegalArgumentException("Source endpoint must be between 0 and 0xFF.");
        }
        if (destEndpoint < 0 || destEndpoint > 255) {
            throw new IllegalArgumentException("Destination endpoint must be between 0 and 0xFF.");
        }
        if (clusterID < 0 || clusterID > 65535) {
            throw new IllegalArgumentException("Cluster ID must be between 0 and 0xFFFF.");
        }
        if (profileID < 0 || profileID > 65535) {
            throw new IllegalArgumentException("Profile ID must be between 0 and 0xFFFF.");
        }
        if (this.isRemote()) {
            throw new OperationNotSupportedException("Cannot send explicit data to a remote device from a remote device.");
        }
        this.logger.debug(this.toString() + "Sending explicit data to {} [{} - {} - {} - {}] >> {}.", new Object[]{address, String.format("%02X", sourceEndpoint), String.format("%02X", destEndpoint), String.format("%04X", clusterID), String.format("%04X", profileID), HexUtils.prettyHexString(data)});
        ExplicitAddressingPacket xbeePacket = new ExplicitAddressingPacket(this.getNextFrameID(), address, XBee16BitAddress.UNKNOWN_ADDRESS, sourceEndpoint, destEndpoint, clusterID, profileID, 0, 0, data);
        this.sendAndCheckXBeePacket(xbeePacket, false);
    }

    protected void sendExplicitData(XBee64BitAddress address64Bit, XBee16BitAddress address16Bit, int sourceEndpoint, int destEndpoint, int clusterID, int profileID, byte[] data) throws TimeoutException, XBeeException {
        if (address64Bit == null) {
            throw new NullPointerException("64-bit address cannot be null");
        }
        if (address16Bit == null) {
            throw new NullPointerException("16-bit address cannot be null");
        }
        if (data == null) {
            throw new NullPointerException("Data cannot be null.");
        }
        if (sourceEndpoint < 0 || sourceEndpoint > 255) {
            throw new IllegalArgumentException("Source endpoint must be between 0 and 0xFF.");
        }
        if (destEndpoint < 0 || destEndpoint > 255) {
            throw new IllegalArgumentException("Destination endpoint must be between 0 and 0xFF.");
        }
        if (clusterID < 0 || clusterID > 65535) {
            throw new IllegalArgumentException("Cluster ID must be between 0 and 0xFFFF.");
        }
        if (profileID < 0 || profileID > 65535) {
            throw new IllegalArgumentException("Profile ID must be between 0 and 0xFFFF.");
        }
        if (this.isRemote()) {
            throw new OperationNotSupportedException("Cannot send explicit data to a remote device from a remote device.");
        }
        this.logger.debug(this.toString() + "Sending explicit data to {}[{}] [{} - {} - {} - {}] >> {}.", new Object[]{address64Bit, address16Bit, String.format("%02X", sourceEndpoint), String.format("%02X", destEndpoint), String.format("%04X", clusterID), String.format("%04X", profileID), HexUtils.prettyHexString(data)});
        ExplicitAddressingPacket xbeePacket = new ExplicitAddressingPacket(this.getNextFrameID(), address64Bit, address16Bit, sourceEndpoint, destEndpoint, clusterID, profileID, 0, 0, data);
        this.sendAndCheckXBeePacket(xbeePacket, false);
    }

    protected void sendExplicitData(RemoteXBeeDevice remoteXBeeDevice, int sourceEndpoint, int destEndpoint, int clusterID, int profileID, byte[] data) throws TimeoutException, XBeeException {
        if (remoteXBeeDevice == null) {
            throw new NullPointerException("Remote XBee device cannot be null.");
        }
        switch (this.getXBeeProtocol()) {
            case ZIGBEE: 
            case DIGI_POINT: {
                if (remoteXBeeDevice.get64BitAddress() != null && remoteXBeeDevice.get16BitAddress() != null) {
                    this.sendExplicitData(remoteXBeeDevice.get64BitAddress(), remoteXBeeDevice.get16BitAddress(), sourceEndpoint, destEndpoint, clusterID, profileID, data);
                    break;
                }
                this.sendExplicitData(remoteXBeeDevice.get64BitAddress(), sourceEndpoint, destEndpoint, clusterID, profileID, data);
                break;
            }
            case RAW_802_15_4: {
                throw new OperationNotSupportedException("802.15.4. protocol does not support explicit data transmissions.");
            }
            default: {
                this.sendExplicitData(remoteXBeeDevice.get64BitAddress(), sourceEndpoint, destEndpoint, clusterID, profileID, data);
            }
        }
    }

    protected void sendBroadcastExplicitData(int sourceEndpoint, int destEndpoint, int clusterID, int profileID, byte[] data) throws TimeoutException, XBeeException {
        if (this.getXBeeProtocol() == XBeeProtocol.RAW_802_15_4) {
            throw new OperationNotSupportedException("802.15.4. protocol does not support explicit data transmissions.");
        }
        this.sendExplicitData(XBee64BitAddress.BROADCAST_ADDRESS, sourceEndpoint, destEndpoint, clusterID, profileID, data);
    }

    protected void sendUserDataRelay(XBeeLocalInterface destInterface, byte[] data) throws XBeeException {
        if (destInterface == null) {
            throw new NullPointerException("Destination interface cannot be null.");
        }
        if (this.isRemote()) {
            throw new OperationNotSupportedException("Cannot send User Data Relay messages from a remote device.");
        }
        this.logger.debug(this.toString() + "Sending User Data Relay to {} >> {}.", (Object)destInterface.getDescription(), (Object)(data != null ? HexUtils.prettyHexString(data) : ""));
        UserDataRelayPacket xbeePacket = new UserDataRelayPacket(this.getNextFrameID(), destInterface, data);
        this.sendAndCheckXBeePacket(xbeePacket, true);
    }

    protected void sendBluetoothData(byte[] data) throws XBeeException {
        this.sendUserDataRelay(XBeeLocalInterface.BLUETOOTH, data);
    }

    protected void sendMicroPythonData(byte[] data) throws XBeeException {
        this.sendUserDataRelay(XBeeLocalInterface.MICROPYTHON, data);
    }

    protected void sendSerialData(byte[] data) throws XBeeException {
        this.sendUserDataRelay(XBeeLocalInterface.SERIAL, data);
    }

    protected void sendPacket(XBeePacket packet, IPacketReceiveListener packetReceiveListener) throws XBeeException {
        try {
            this.sendXBeePacket(packet, packetReceiveListener);
        }
        catch (IOException e) {
            throw new XBeeException("Error writing in the communication interface.", e);
        }
    }

    protected void sendPacketAsync(XBeePacket packet) throws XBeeException {
        try {
            this.sendXBeePacket(packet, null);
        }
        catch (IOException e) {
            throw new XBeeException("Error writing in the communication interface.", e);
        }
    }

    protected XBeePacket sendPacket(XBeePacket packet) throws TimeoutException, XBeeException {
        try {
            return this.sendXBeePacket(packet);
        }
        catch (IOException e) {
            throw new XBeeException("Error writing in the communication interface.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitForModemResetStatusPacket() {
        this.modemStatusReceived = false;
        this.addModemStatusListener(this.resetStatusListener);
        Object object = this.resetLock;
        synchronized (object) {
            try {
                this.resetLock.wait(TIMEOUT_RESET);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.removeModemStatusListener(this.resetStatusListener);
        return this.modemStatusReceived;
    }

    protected void softwareReset() throws TimeoutException, XBeeException {
        if (!this.connectionInterface.isOpen()) {
            throw new InterfaceNotOpenException();
        }
        this.logger.info(this.toString() + "Resetting the local module...");
        ATCommandResponse response = null;
        try {
            response = this.sendATCommand(new ATCommand("FR"));
        }
        catch (IOException e) {
            throw new XBeeException("Error writing in the communication interface.", e);
        }
        this.checkATCommandResponseIsValid(response);
        if (!this.waitForModemResetStatusPacket()) {
            throw new TimeoutException("Timeout waiting for the Modem Status packet.");
        }
        this.logger.info(this.toString() + "Module reset successfully.");
    }

    protected XBeePacket readPacket() {
        return this.readPacket(null, TIMEOUT_READ_PACKET);
    }

    protected XBeePacket readPacket(int timeout) {
        if (timeout < 0) {
            throw new IllegalArgumentException("Read timeout must be 0 or greater.");
        }
        return this.readPacket(null, timeout);
    }

    protected XBeePacket readPacketFrom(RemoteXBeeDevice remoteXBeeDevice) {
        if (remoteXBeeDevice == null) {
            throw new NullPointerException("Remote XBee device cannot be null.");
        }
        return this.readPacketFrom(remoteXBeeDevice, TIMEOUT_READ_PACKET);
    }

    protected XBeePacket readPacketFrom(RemoteXBeeDevice remoteXBeeDevice, int timeout) {
        if (remoteXBeeDevice == null) {
            throw new NullPointerException("Remote XBee device cannot be null.");
        }
        if (timeout < 0) {
            throw new IllegalArgumentException("Read timeout must be 0 or greater.");
        }
        return this.readPacket(remoteXBeeDevice, timeout);
    }

    private XBeePacket readPacket(RemoteXBeeDevice remoteXBeeDevice, int timeout) {
        if (!this.connectionInterface.isOpen()) {
            throw new InterfaceNotOpenException();
        }
        XBeePacketsQueue xbeePacketsQueue = this.dataReader.getXBeePacketsQueue();
        if (remoteXBeeDevice != null) {
            return xbeePacketsQueue.getFirstPacketFrom(remoteXBeeDevice, timeout);
        }
        return xbeePacketsQueue.getFirstPacket(timeout);
    }

    protected XBeeMessage readData() {
        return this.readDataPacket(null, TIMEOUT_READ_PACKET);
    }

    protected XBeeMessage readData(int timeout) {
        if (timeout < 0) {
            throw new IllegalArgumentException("Read timeout must be 0 or greater.");
        }
        return this.readDataPacket(null, timeout);
    }

    protected XBeeMessage readDataFrom(RemoteXBeeDevice remoteXBeeDevice) {
        if (remoteXBeeDevice == null) {
            throw new NullPointerException("Remote XBee device cannot be null.");
        }
        return this.readDataPacket(remoteXBeeDevice, TIMEOUT_READ_PACKET);
    }

    protected XBeeMessage readDataFrom(RemoteXBeeDevice remoteXBeeDevice, int timeout) {
        if (remoteXBeeDevice == null) {
            throw new NullPointerException("Remote XBee device cannot be null.");
        }
        if (timeout < 0) {
            throw new IllegalArgumentException("Read timeout must be 0 or greater.");
        }
        return this.readDataPacket(remoteXBeeDevice, timeout);
    }

    private XBeeMessage readDataPacket(RemoteXBeeDevice remoteXBeeDevice, int timeout) {
        if (!this.connectionInterface.isOpen()) {
            throw new InterfaceNotOpenException();
        }
        XBeePacketsQueue xbeePacketsQueue = this.dataReader.getXBeePacketsQueue();
        XBeePacket xbeePacket = null;
        xbeePacket = remoteXBeeDevice != null ? xbeePacketsQueue.getFirstDataPacketFrom(remoteXBeeDevice, timeout) : xbeePacketsQueue.getFirstDataPacket(timeout);
        if (xbeePacket == null) {
            return null;
        }
        RemoteXBeeDevice remoteDevice = null;
        try {
            remoteDevice = this.dataReader.getRemoteXBeeDeviceFromPacket((XBeeAPIPacket)xbeePacket);
            if (remoteXBeeDevice != null) {
                remoteDevice = this.getNetwork().addRemoteDevice(remoteXBeeDevice);
            }
            if (remoteDevice == null) {
                return null;
            }
        }
        catch (XBeeException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
        byte[] data = null;
        switch (((XBeeAPIPacket)xbeePacket).getFrameType()) {
            case RECEIVE_PACKET: {
                ReceivePacket receivePacket = (ReceivePacket)xbeePacket;
                data = receivePacket.getRFData();
                break;
            }
            case RX_16: {
                RX16Packet rx16Packet = (RX16Packet)xbeePacket;
                data = rx16Packet.getRFData();
                break;
            }
            case RX_64: {
                RX64Packet rx64Packet = (RX64Packet)xbeePacket;
                data = rx64Packet.getRFData();
                break;
            }
            default: {
                return null;
            }
        }
        return new XBeeMessage(remoteDevice, data, ((XBeeAPIPacket)xbeePacket).isBroadcast());
    }

    protected ExplicitXBeeMessage readExplicitData() {
        return this.readExplicitDataPacket(null, TIMEOUT_READ_PACKET);
    }

    protected ExplicitXBeeMessage readExplicitData(int timeout) {
        if (timeout < 0) {
            throw new IllegalArgumentException("Read timeout must be 0 or greater.");
        }
        return this.readExplicitDataPacket(null, timeout);
    }

    protected ExplicitXBeeMessage readExplicitDataFrom(RemoteXBeeDevice remoteXBeeDevice) {
        if (remoteXBeeDevice == null) {
            throw new NullPointerException("Remote XBee device cannot be null.");
        }
        return this.readExplicitDataPacket(remoteXBeeDevice, TIMEOUT_READ_PACKET);
    }

    protected ExplicitXBeeMessage readExplicitDataFrom(RemoteXBeeDevice remoteXBeeDevice, int timeout) {
        if (remoteXBeeDevice == null) {
            throw new NullPointerException("Remote XBee device cannot be null.");
        }
        if (timeout < 0) {
            throw new IllegalArgumentException("Read timeout must be 0 or greater.");
        }
        return this.readExplicitDataPacket(remoteXBeeDevice, timeout);
    }

    private ExplicitXBeeMessage readExplicitDataPacket(RemoteXBeeDevice remoteXBeeDevice, int timeout) {
        if (!this.connectionInterface.isOpen()) {
            throw new InterfaceNotOpenException();
        }
        if (this.isRemote()) {
            throw new RuntimeException("Remote devices cannot read explicit data.");
        }
        XBeePacketsQueue xbeePacketsQueue = this.dataReader.getXBeePacketsQueue();
        XBeePacket xbeePacket = null;
        xbeePacket = remoteXBeeDevice != null ? xbeePacketsQueue.getFirstExplicitDataPacketFrom(remoteXBeeDevice, timeout) : xbeePacketsQueue.getFirstExplicitDataPacket(timeout);
        if (xbeePacket == null) {
            return null;
        }
        APIFrameType packetType = ((XBeeAPIPacket)xbeePacket).getFrameType();
        if (packetType != APIFrameType.EXPLICIT_RX_INDICATOR) {
            return null;
        }
        ExplicitRxIndicatorPacket explicitDataPacket = (ExplicitRxIndicatorPacket)xbeePacket;
        RemoteXBeeDevice remoteDevice = this.getNetwork().getDevice(explicitDataPacket.get64BitSourceAddress());
        if (remoteDevice == null) {
            remoteDevice = remoteXBeeDevice != null ? remoteXBeeDevice : new RemoteXBeeDevice(this, explicitDataPacket.get64BitSourceAddress());
            this.getNetwork().addRemoteDevice(remoteDevice);
        }
        int sourceEndpoint = explicitDataPacket.getSourceEndpoint();
        int destEndpoint = explicitDataPacket.getDestinationEndpoint();
        int clusterID = explicitDataPacket.getClusterID();
        int profileID = explicitDataPacket.getProfileID();
        byte[] data = explicitDataPacket.getRFData();
        return new ExplicitXBeeMessage(remoteDevice, sourceEndpoint, destEndpoint, clusterID, profileID, data, ((XBeeAPIPacket)xbeePacket).isBroadcast());
    }

    protected void setAPIOutputMode(APIOutputMode apiOutputMode) throws TimeoutException, XBeeException {
        if (apiOutputMode == null) {
            throw new NullPointerException("API output mode cannot be null.");
        }
        this.setParameter("AO", new byte[]{(byte)apiOutputMode.getValue()});
    }

    protected APIOutputMode getAPIOutputMode() throws TimeoutException, XBeeException {
        byte[] apiOutputModeValue = this.getParameter("AO");
        return APIOutputMode.get(apiOutputModeValue[0]);
    }

    protected void setBluetoothPassword(String password) {
        this.bluetoothPassword = password;
    }

    static /* synthetic */ byte[] access$102(AbstractXBeeDevice x0, byte[] x1) {
        x0.ioPacketPayload = x1;
        return x1;
    }
}

