/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api;

import com.digi.xbee.api.AbstractXBeeDevice;
import com.digi.xbee.api.exceptions.BluetoothAuthenticationException;
import com.digi.xbee.api.exceptions.InterfaceNotOpenException;
import com.digi.xbee.api.exceptions.XBeeException;
import com.digi.xbee.api.listeners.IPacketReceiveListener;
import com.digi.xbee.api.models.SrpStep;
import com.digi.xbee.api.packet.APIFrameType;
import com.digi.xbee.api.packet.XBeeAPIPacket;
import com.digi.xbee.api.packet.XBeePacket;
import com.digi.xbee.api.packet.bluetooth.BluetoothUnlockPacket;
import com.digi.xbee.api.packet.bluetooth.BluetoothUnlockResponsePacket;
import com.digi.xbee.api.utils.HexUtils;
import com.digi.xbee.api.utils.srp.SrpUser;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BluetoothAuthentication {
    private static final int TIMEOUT_AUTH = 4000;
    private static final String ERROR_AUTH = "Error performing authentication";
    private static final String ERROR_AUTH_EXTENDED = "Error performing authentication > %s";
    private static final String ERROR_RESPONSE_NOT_RECEIVED = "Server response not received.";
    private static final String ERROR_BAD_PROOF = "Bad proof of key.";
    private static final String ERROR_CHALLENGE = "Could not process challenge.";
    private static final int LENGTH_SALT = 4;
    private static final int LENGTH_EPHEMERAL = 128;
    private static final int LENGTH_SESSION_PROOF = 32;
    private static final int LENGTH_NONCE = 12;
    private final AbstractXBeeDevice device;
    private final String password;
    private final Object unlockLock = new Object();
    private SrpStep expectedStep;
    private BluetoothUnlockListener bluetoothUnlockListener;
    private BluetoothUnlockResponsePacket unlockResponse;
    private byte[] key = null;
    private byte[] txNonce = null;
    private byte[] rxNonce = null;
    private Logger logger;

    BluetoothAuthentication(AbstractXBeeDevice device, String password) {
        if (device.isRemote()) {
            throw new IllegalArgumentException("The given local XBee device is remote.");
        }
        this.device = device;
        this.password = password;
        this.bluetoothUnlockListener = new BluetoothUnlockListener(this);
        this.logger = LoggerFactory.getLogger(BluetoothAuthentication.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void authenticate() throws BluetoothAuthenticationException {
        if (!this.device.isOpen()) {
            throw new InterfaceNotOpenException();
        }
        this.device.addPacketListener(this.bluetoothUnlockListener);
        try {
            SrpUser user = new SrpUser("apiservice", this.password);
            byte[] clientEphemeral = user.startAuthentication();
            this.logger.debug(String.format("%sSRP step 1 - A = %s", this.device.toString(), HexUtils.byteArrayToHexString(clientEphemeral)));
            this.expectedStep = SrpStep.STEP_2;
            this.unlockResponse = null;
            this.device.sendPacketAsync(new BluetoothUnlockPacket(SrpStep.STEP_1, clientEphemeral));
            Object object = this.unlockLock;
            synchronized (object) {
                try {
                    this.unlockLock.wait(4000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.checkResponsePacket();
            int index = 0;
            byte[] salt = new byte[4];
            System.arraycopy(this.unlockResponse.getData(), index, salt, 0, salt.length);
            byte[] serverEphemeral = new byte[128];
            System.arraycopy(this.unlockResponse.getData(), index += 4, serverEphemeral, 0, serverEphemeral.length);
            this.logger.debug(String.format("%sSRP step 2 - S = %s - B = %s", this.device.toString(), HexUtils.byteArrayToHexString(salt), HexUtils.byteArrayToHexString(serverEphemeral)));
            byte[] clientSessionProof = user.processChallenge(salt, serverEphemeral);
            if (clientSessionProof == null) {
                throw new BluetoothAuthenticationException(String.format(ERROR_AUTH_EXTENDED, ERROR_CHALLENGE));
            }
            this.logger.debug(String.format("%sSRP step 3 - M1 = %s", this.device.toString(), HexUtils.byteArrayToHexString(clientSessionProof)));
            this.expectedStep = SrpStep.STEP_4;
            this.unlockResponse = null;
            this.device.sendPacketAsync(new BluetoothUnlockPacket(SrpStep.STEP_3, clientSessionProof));
            Object object2 = this.unlockLock;
            synchronized (object2) {
                try {
                    this.unlockLock.wait(4000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.checkResponsePacket();
            index = 0;
            byte[] serverSessionProof = new byte[32];
            System.arraycopy(this.unlockResponse.getData(), index, serverSessionProof, 0, serverSessionProof.length);
            this.txNonce = new byte[12];
            System.arraycopy(this.unlockResponse.getData(), index += 32, this.txNonce, 0, this.txNonce.length);
            this.rxNonce = new byte[12];
            System.arraycopy(this.unlockResponse.getData(), index += 12, this.rxNonce, 0, this.rxNonce.length);
            this.logger.debug(String.format("%sSRP step 4 - M2 = %s - TX nonce = %s - RX nonce = %s", this.device.toString(), HexUtils.byteArrayToHexString(serverSessionProof), HexUtils.byteArrayToHexString(this.txNonce), HexUtils.byteArrayToHexString(this.rxNonce)));
            user.verifySession(serverSessionProof);
            if (!user.isAuthenticated()) {
                throw new BluetoothAuthenticationException(String.format(ERROR_AUTH_EXTENDED, ERROR_BAD_PROOF));
            }
            this.key = user.getSessionKey();
        }
        catch (BluetoothAuthenticationException e) {
            throw e;
        }
        catch (XBeeException | IOException | NoSuchAlgorithmException e) {
            throw new BluetoothAuthenticationException(String.format(ERROR_AUTH_EXTENDED, e.getMessage()));
        }
        finally {
            this.device.removePacketListener(this.bluetoothUnlockListener);
        }
    }

    byte[] getKey() {
        return this.key;
    }

    byte[] getTxNonce() {
        return this.txNonce;
    }

    byte[] getRxNonce() {
        return this.rxNonce;
    }

    private void checkResponsePacket() throws BluetoothAuthenticationException {
        if (this.unlockResponse == null) {
            throw new BluetoothAuthenticationException(String.format(ERROR_AUTH_EXTENDED, ERROR_RESPONSE_NOT_RECEIVED));
        }
        if (this.unlockResponse.getSrpStep() == null || this.unlockResponse.getSrpStep() == SrpStep.UNKNOWN) {
            throw new BluetoothAuthenticationException(String.format(ERROR_AUTH_EXTENDED, this.unlockResponse.getSrpError().getDescription()));
        }
    }

    private class BluetoothUnlockListener
    implements IPacketReceiveListener {
        private BluetoothAuthentication auth;

        BluetoothUnlockListener(BluetoothAuthentication auth) {
            this.auth = auth;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void packetReceived(XBeePacket receivedPacket) {
            if (!(receivedPacket instanceof XBeeAPIPacket) || ((XBeeAPIPacket)receivedPacket).getFrameType() != APIFrameType.BLE_UNLOCK_RESPONSE) {
                return;
            }
            BluetoothUnlockResponsePacket response = (BluetoothUnlockResponsePacket)receivedPacket;
            if (response.getSrpStep() != null && response.getSrpStep() != this.auth.expectedStep) {
                return;
            }
            this.auth.unlockResponse = response;
            Object object = this.auth.unlockLock;
            synchronized (object) {
                this.auth.unlockLock.notify();
            }
        }
    }
}

