/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api;

import com.digi.xbee.api.AbstractXBeeDevice;
import com.digi.xbee.api.RemoteDigiMeshDevice;
import com.digi.xbee.api.RemoteDigiPointDevice;
import com.digi.xbee.api.RemoteRaw802Device;
import com.digi.xbee.api.RemoteThreadDevice;
import com.digi.xbee.api.RemoteXBeeDevice;
import com.digi.xbee.api.RemoteZigBeeDevice;
import com.digi.xbee.api.XBeeNetwork;
import com.digi.xbee.api.connection.IConnectionInterface;
import com.digi.xbee.api.exceptions.XBeeException;
import com.digi.xbee.api.io.IOSample;
import com.digi.xbee.api.listeners.IDataReceiveListener;
import com.digi.xbee.api.listeners.IExplicitDataReceiveListener;
import com.digi.xbee.api.listeners.IIOSampleReceiveListener;
import com.digi.xbee.api.listeners.IIPDataReceiveListener;
import com.digi.xbee.api.listeners.IModemStatusReceiveListener;
import com.digi.xbee.api.listeners.IPacketReceiveListener;
import com.digi.xbee.api.listeners.ISMSReceiveListener;
import com.digi.xbee.api.listeners.IUserDataRelayReceiveListener;
import com.digi.xbee.api.listeners.relay.IBluetoothDataReceiveListener;
import com.digi.xbee.api.listeners.relay.IMicroPythonDataReceiveListener;
import com.digi.xbee.api.listeners.relay.ISerialDataReceiveListener;
import com.digi.xbee.api.models.ExplicitXBeeMessage;
import com.digi.xbee.api.models.IPMessage;
import com.digi.xbee.api.models.ModemStatusEvent;
import com.digi.xbee.api.models.OperatingMode;
import com.digi.xbee.api.models.SMSMessage;
import com.digi.xbee.api.models.SpecialByte;
import com.digi.xbee.api.models.UserDataRelayMessage;
import com.digi.xbee.api.models.XBee16BitAddress;
import com.digi.xbee.api.models.XBee64BitAddress;
import com.digi.xbee.api.models.XBeeMessage;
import com.digi.xbee.api.models.XBeePacketsQueue;
import com.digi.xbee.api.models.XBeeProtocol;
import com.digi.xbee.api.packet.APIFrameType;
import com.digi.xbee.api.packet.XBeeAPIPacket;
import com.digi.xbee.api.packet.XBeePacket;
import com.digi.xbee.api.packet.XBeePacketParser;
import com.digi.xbee.api.packet.cellular.RXSMSPacket;
import com.digi.xbee.api.packet.common.ExplicitRxIndicatorPacket;
import com.digi.xbee.api.packet.common.IODataSampleRxIndicatorPacket;
import com.digi.xbee.api.packet.common.ModemStatusPacket;
import com.digi.xbee.api.packet.common.ReceivePacket;
import com.digi.xbee.api.packet.ip.RXIPv4Packet;
import com.digi.xbee.api.packet.raw.RX16IOPacket;
import com.digi.xbee.api.packet.raw.RX16Packet;
import com.digi.xbee.api.packet.raw.RX64IOPacket;
import com.digi.xbee.api.packet.raw.RX64Packet;
import com.digi.xbee.api.packet.relay.UserDataRelayOutputPacket;
import com.digi.xbee.api.packet.thread.IPv6IODataSampleRxIndicator;
import com.digi.xbee.api.packet.thread.RXIPv6Packet;
import com.digi.xbee.api.utils.HexUtils;
import java.io.IOException;
import java.net.Inet6Address;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataReader
extends Thread {
    private static final int ALL_FRAME_IDS = 99999;
    private static final int MAXIMUM_PARALLEL_LISTENER_THREADS = 20;
    private boolean running = false;
    private IConnectionInterface connectionInterface;
    private volatile OperatingMode mode;
    private ArrayList<IDataReceiveListener> dataReceiveListeners = new ArrayList();
    private HashMap<IPacketReceiveListener, Integer> packetReceiveListeners = new HashMap();
    private ArrayList<IIOSampleReceiveListener> ioSampleReceiveListeners = new ArrayList();
    private ArrayList<IModemStatusReceiveListener> modemStatusListeners = new ArrayList();
    private ArrayList<IExplicitDataReceiveListener> explicitDataReceiveListeners = new ArrayList();
    private ArrayList<IIPDataReceiveListener> ipDataReceiveListeners = new ArrayList();
    private ArrayList<ISMSReceiveListener> smsReceiveListeners = new ArrayList();
    private ArrayList<IUserDataRelayReceiveListener> dataRelayReceiveListeners = new ArrayList();
    private ArrayList<IBluetoothDataReceiveListener> bluetoothDataReceiveListeners = new ArrayList();
    private ArrayList<IMicroPythonDataReceiveListener> microPythonDataReceiveListeners = new ArrayList();
    private ArrayList<ISerialDataReceiveListener> serialDataReceiveListeners = new ArrayList();
    private Logger logger;
    private XBeePacketParser parser;
    private XBeePacketsQueue xbeePacketsQueue;
    private AbstractXBeeDevice xbeeDevice;

    public DataReader(IConnectionInterface connectionInterface, OperatingMode mode, AbstractXBeeDevice xbeeDevice) {
        if (connectionInterface == null) {
            throw new NullPointerException("Connection interface cannot be null.");
        }
        if (mode == null) {
            throw new NullPointerException("Operating mode cannot be null.");
        }
        if (xbeeDevice.isRemote()) {
            throw new IllegalArgumentException("The given local XBee device is remote.");
        }
        this.connectionInterface = connectionInterface;
        this.mode = mode;
        this.xbeeDevice = xbeeDevice;
        this.logger = LoggerFactory.getLogger(DataReader.class);
        this.parser = new XBeePacketParser();
        this.xbeePacketsQueue = new XBeePacketsQueue();
    }

    public void setXBeeReaderMode(OperatingMode mode) {
        if (mode == null) {
            throw new NullPointerException("Operating mode cannot be null.");
        }
        this.mode = mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDataReceiveListener(IDataReceiveListener listener) {
        if (listener == null) {
            throw new NullPointerException("Listener cannot be null.");
        }
        ArrayList<IDataReceiveListener> arrayList = this.dataReceiveListeners;
        synchronized (arrayList) {
            if (!this.dataReceiveListeners.contains(listener)) {
                this.dataReceiveListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDataReceiveListener(IDataReceiveListener listener) {
        ArrayList<IDataReceiveListener> arrayList = this.dataReceiveListeners;
        synchronized (arrayList) {
            if (this.dataReceiveListeners.contains(listener)) {
                this.dataReceiveListeners.remove(listener);
            }
        }
    }

    public void addPacketReceiveListener(IPacketReceiveListener listener) {
        this.addPacketReceiveListener(listener, 99999);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPacketReceiveListener(IPacketReceiveListener listener, int frameID) {
        if (listener == null) {
            throw new NullPointerException("Listener cannot be null.");
        }
        HashMap<IPacketReceiveListener, Integer> hashMap = this.packetReceiveListeners;
        synchronized (hashMap) {
            if (!this.packetReceiveListeners.containsKey(listener)) {
                this.packetReceiveListeners.put(listener, frameID);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePacketReceiveListener(IPacketReceiveListener listener) {
        HashMap<IPacketReceiveListener, Integer> hashMap = this.packetReceiveListeners;
        synchronized (hashMap) {
            if (this.packetReceiveListeners.containsKey(listener)) {
                this.packetReceiveListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIOSampleReceiveListener(IIOSampleReceiveListener listener) {
        if (listener == null) {
            throw new NullPointerException("Listener cannot be null.");
        }
        ArrayList<IIOSampleReceiveListener> arrayList = this.ioSampleReceiveListeners;
        synchronized (arrayList) {
            if (!this.ioSampleReceiveListeners.contains(listener)) {
                this.ioSampleReceiveListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIOSampleReceiveListener(IIOSampleReceiveListener listener) {
        ArrayList<IIOSampleReceiveListener> arrayList = this.ioSampleReceiveListeners;
        synchronized (arrayList) {
            if (this.ioSampleReceiveListeners.contains(listener)) {
                this.ioSampleReceiveListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModemStatusReceiveListener(IModemStatusReceiveListener listener) {
        if (listener == null) {
            throw new NullPointerException("Listener cannot be null.");
        }
        ArrayList<IModemStatusReceiveListener> arrayList = this.modemStatusListeners;
        synchronized (arrayList) {
            if (!this.modemStatusListeners.contains(listener)) {
                this.modemStatusListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModemStatusReceiveListener(IModemStatusReceiveListener listener) {
        ArrayList<IModemStatusReceiveListener> arrayList = this.modemStatusListeners;
        synchronized (arrayList) {
            if (this.modemStatusListeners.contains(listener)) {
                this.modemStatusListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExplicitDataReceiveListener(IExplicitDataReceiveListener listener) {
        if (listener == null) {
            throw new NullPointerException("Listener cannot be null.");
        }
        ArrayList<IExplicitDataReceiveListener> arrayList = this.explicitDataReceiveListeners;
        synchronized (arrayList) {
            if (!this.explicitDataReceiveListeners.contains(listener)) {
                this.explicitDataReceiveListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExplicitDataReceiveListener(IExplicitDataReceiveListener listener) {
        ArrayList<IExplicitDataReceiveListener> arrayList = this.explicitDataReceiveListeners;
        synchronized (arrayList) {
            if (this.explicitDataReceiveListeners.contains(listener)) {
                this.explicitDataReceiveListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIPDataReceiveListener(IIPDataReceiveListener listener) {
        if (listener == null) {
            throw new NullPointerException("Listener cannot be null.");
        }
        ArrayList<IIPDataReceiveListener> arrayList = this.ipDataReceiveListeners;
        synchronized (arrayList) {
            if (!this.ipDataReceiveListeners.contains(listener)) {
                this.ipDataReceiveListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIPDataReceiveListener(IIPDataReceiveListener listener) {
        ArrayList<IIPDataReceiveListener> arrayList = this.ipDataReceiveListeners;
        synchronized (arrayList) {
            if (this.ipDataReceiveListeners.contains(listener)) {
                this.ipDataReceiveListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSMSReceiveListener(ISMSReceiveListener listener) {
        if (listener == null) {
            throw new NullPointerException("Listener cannot be null.");
        }
        ArrayList<ISMSReceiveListener> arrayList = this.smsReceiveListeners;
        synchronized (arrayList) {
            if (!this.smsReceiveListeners.contains(listener)) {
                this.smsReceiveListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSMSReceiveListener(ISMSReceiveListener listener) {
        ArrayList<ISMSReceiveListener> arrayList = this.smsReceiveListeners;
        synchronized (arrayList) {
            if (this.smsReceiveListeners.contains(listener)) {
                this.smsReceiveListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUserDataRelayReceiveListener(IUserDataRelayReceiveListener listener) {
        if (listener == null) {
            throw new NullPointerException("Listener cannot be null");
        }
        ArrayList<IUserDataRelayReceiveListener> arrayList = this.dataRelayReceiveListeners;
        synchronized (arrayList) {
            if (!this.dataRelayReceiveListeners.contains(listener)) {
                this.dataRelayReceiveListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUserDataRelayReceiveListener(IUserDataRelayReceiveListener listener) {
        ArrayList<IUserDataRelayReceiveListener> arrayList = this.dataRelayReceiveListeners;
        synchronized (arrayList) {
            if (this.dataRelayReceiveListeners.contains(listener)) {
                this.dataRelayReceiveListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBluetoothDataReceiveListener(IBluetoothDataReceiveListener listener) {
        if (listener == null) {
            throw new NullPointerException("Listener cannot be null");
        }
        ArrayList<IBluetoothDataReceiveListener> arrayList = this.bluetoothDataReceiveListeners;
        synchronized (arrayList) {
            if (!this.bluetoothDataReceiveListeners.contains(listener)) {
                this.bluetoothDataReceiveListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBluetoothDataReceiveListener(IBluetoothDataReceiveListener listener) {
        ArrayList<IBluetoothDataReceiveListener> arrayList = this.bluetoothDataReceiveListeners;
        synchronized (arrayList) {
            if (this.bluetoothDataReceiveListeners.contains(listener)) {
                this.bluetoothDataReceiveListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMicroPythonDataReceiveListener(IMicroPythonDataReceiveListener listener) {
        if (listener == null) {
            throw new NullPointerException("Listener cannot be null");
        }
        ArrayList<IMicroPythonDataReceiveListener> arrayList = this.microPythonDataReceiveListeners;
        synchronized (arrayList) {
            if (!this.microPythonDataReceiveListeners.contains(listener)) {
                this.microPythonDataReceiveListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMicroPythonDataReceiveListener(IMicroPythonDataReceiveListener listener) {
        ArrayList<IMicroPythonDataReceiveListener> arrayList = this.microPythonDataReceiveListeners;
        synchronized (arrayList) {
            if (this.microPythonDataReceiveListeners.contains(listener)) {
                this.microPythonDataReceiveListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSerialDataReceiveListener(ISerialDataReceiveListener listener) {
        if (listener == null) {
            throw new NullPointerException("Listener cannot be null");
        }
        ArrayList<ISerialDataReceiveListener> arrayList = this.serialDataReceiveListeners;
        synchronized (arrayList) {
            if (!this.serialDataReceiveListeners.contains(listener)) {
                this.serialDataReceiveListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSerialDataReceiveListener(ISerialDataReceiveListener listener) {
        ArrayList<ISerialDataReceiveListener> arrayList = this.serialDataReceiveListeners;
        synchronized (arrayList) {
            if (this.serialDataReceiveListeners.contains(listener)) {
                this.serialDataReceiveListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        this.logger.debug(this.connectionInterface.toString() + "Data reader started.");
        this.running = true;
        this.xbeePacketsQueue.clearQueue();
        try {
            IConnectionInterface iConnectionInterface = this.connectionInterface;
            synchronized (iConnectionInterface) {
                this.connectionInterface.wait();
            }
            while (this.running) {
                if (!this.running) {
                    return;
                }
                if (this.connectionInterface.getInputStream() != null) {
                    switch (this.mode) {
                        default: {
                            break;
                        }
                        case API: 
                        case API_ESCAPE: {
                            int headerByte = this.connectionInterface.getInputStream().read();
                            if (headerByte != SpecialByte.HEADER_BYTE.getValue()) break;
                            try {
                                XBeePacket packet = this.parser.parsePacket(this.connectionInterface.getInputStream(), this.mode);
                                this.packetReceived(packet);
                            }
                            catch (Exception e) {
                                this.logger.error("Error parsing the API packet.", (Throwable)e);
                            }
                            break;
                        }
                    }
                } else if (this.connectionInterface.getInputStream() == null) {
                    return;
                }
                if (this.connectionInterface.getInputStream() == null) {
                    return;
                }
                if (this.connectionInterface.getInputStream().available() > 0) continue;
                IConnectionInterface headerByte = this.connectionInterface;
                synchronized (headerByte) {
                    this.connectionInterface.wait();
                }
            }
            return;
        }
        catch (IOException e) {
            this.logger.error("Error reading from input stream.", (Throwable)e);
            return;
        }
        catch (InterruptedException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return;
        }
        catch (IllegalStateException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return;
        }
        finally {
            if (this.running) {
                this.running = false;
                if (this.connectionInterface.isOpen()) {
                    this.connectionInterface.close();
                }
            }
        }
    }

    private void packetReceived(XBeePacket packet) {
        this.xbeePacketsQueue.addPacket(packet);
        this.notifyPacketReceived(packet);
        if (!(packet instanceof XBeeAPIPacket)) {
            return;
        }
        XBeeAPIPacket apiPacket = (XBeeAPIPacket)packet;
        APIFrameType apiType = apiPacket.getFrameType();
        if (apiType == null) {
            return;
        }
        try {
            RemoteXBeeDevice remoteDevice = this.getRemoteXBeeDeviceFromPacket(apiPacket);
            byte[] data = null;
            switch (apiType) {
                case RECEIVE_PACKET: {
                    ReceivePacket receivePacket = (ReceivePacket)apiPacket;
                    data = receivePacket.getRFData();
                    this.notifyDataReceived(new XBeeMessage(remoteDevice, data, apiPacket.isBroadcast()));
                    break;
                }
                case RX_64: {
                    RX64Packet rx64Packet = (RX64Packet)apiPacket;
                    data = rx64Packet.getRFData();
                    this.notifyDataReceived(new XBeeMessage(remoteDevice, data, apiPacket.isBroadcast()));
                    break;
                }
                case RX_16: {
                    RX16Packet rx16Packet = (RX16Packet)apiPacket;
                    data = rx16Packet.getRFData();
                    this.notifyDataReceived(new XBeeMessage(remoteDevice, data, apiPacket.isBroadcast()));
                    break;
                }
                case IO_DATA_SAMPLE_RX_INDICATOR: {
                    IODataSampleRxIndicatorPacket ioSamplePacket = (IODataSampleRxIndicatorPacket)apiPacket;
                    this.notifyIOSampleReceived(remoteDevice, ioSamplePacket.getIOSample());
                    break;
                }
                case RX_IO_64: {
                    RX64IOPacket rx64IOPacket = (RX64IOPacket)apiPacket;
                    if (rx64IOPacket.getIOSamples() == null || rx64IOPacket.getIOSamples().size() <= 0) break;
                    for (IOSample sample : rx64IOPacket.getIOSamples()) {
                        this.notifyIOSampleReceived(remoteDevice, sample);
                    }
                    break;
                }
                case RX_IO_16: {
                    RX16IOPacket rx16IOPacket = (RX16IOPacket)apiPacket;
                    if (rx16IOPacket.getIOSamples() == null || rx16IOPacket.getIOSamples().size() <= 0) break;
                    for (IOSample sample : rx16IOPacket.getIOSamples()) {
                        this.notifyIOSampleReceived(remoteDevice, sample);
                    }
                    break;
                }
                case IPV6_IO_DATA_SAMPLE_RX_INDICATOR: {
                    IPv6IODataSampleRxIndicator ioSampleIPv6Packet = (IPv6IODataSampleRxIndicator)apiPacket;
                    this.notifyIOSampleReceived(remoteDevice, ioSampleIPv6Packet.getIOSample());
                    break;
                }
                case MODEM_STATUS: {
                    ModemStatusPacket modemStatusPacket = (ModemStatusPacket)apiPacket;
                    this.notifyModemStatusReceived(modemStatusPacket.getStatus());
                    break;
                }
                case EXPLICIT_RX_INDICATOR: {
                    ExplicitRxIndicatorPacket explicitDataPacket = (ExplicitRxIndicatorPacket)apiPacket;
                    int sourceEndpoint = explicitDataPacket.getSourceEndpoint();
                    int destEndpoint = explicitDataPacket.getDestinationEndpoint();
                    int clusterID = explicitDataPacket.getClusterID();
                    int profileID = explicitDataPacket.getProfileID();
                    data = explicitDataPacket.getRFData();
                    if (sourceEndpoint == 232 && destEndpoint == 232 && clusterID == 17 && profileID == 49413) {
                        this.notifyDataReceived(new XBeeMessage(remoteDevice, data, apiPacket.isBroadcast()));
                        this.xbeePacketsQueue.addPacket(new ReceivePacket(explicitDataPacket.get64BitSourceAddress(), explicitDataPacket.get16BitSourceAddress(), explicitDataPacket.getReceiveOptions(), explicitDataPacket.getRFData()));
                    }
                    this.notifyExplicitDataReceived(new ExplicitXBeeMessage(remoteDevice, sourceEndpoint, destEndpoint, clusterID, profileID, data, explicitDataPacket.isBroadcast()));
                    break;
                }
                case RX_IPV4: {
                    RXIPv4Packet rxIPv4Packet = (RXIPv4Packet)apiPacket;
                    this.notifyIPDataReceived(new IPMessage(rxIPv4Packet.getSourceAddress(), rxIPv4Packet.getSourcePort(), rxIPv4Packet.getDestPort(), rxIPv4Packet.getProtocol(), rxIPv4Packet.getData()));
                    break;
                }
                case RX_IPV6: {
                    RXIPv6Packet rxIPv6Packet = (RXIPv6Packet)apiPacket;
                    this.notifyIPDataReceived(new IPMessage(rxIPv6Packet.getSourceAddress(), rxIPv6Packet.getSourcePort(), rxIPv6Packet.getDestPort(), rxIPv6Packet.getProtocol(), rxIPv6Packet.getData()));
                    break;
                }
                case RX_SMS: {
                    RXSMSPacket rxSMSPacket = (RXSMSPacket)apiPacket;
                    this.notifySMSReceived(new SMSMessage(rxSMSPacket.getPhoneNumber(), rxSMSPacket.getData()));
                    break;
                }
                case USER_DATA_RELAY_OUTPUT: {
                    UserDataRelayOutputPacket relayPacket = (UserDataRelayOutputPacket)apiPacket;
                    this.notifyUserDataRelayReceived(new UserDataRelayMessage(relayPacket.getSourceInterface(), relayPacket.getData()));
                    break;
                }
            }
        }
        catch (XBeeException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public RemoteXBeeDevice getRemoteXBeeDeviceFromPacket(XBeeAPIPacket packet) throws XBeeException {
        if (packet == null) {
            throw new NullPointerException("XBee API packet cannot be null.");
        }
        XBeeAPIPacket apiPacket = packet;
        APIFrameType apiType = apiPacket.getFrameType();
        if (apiType == null || apiType == APIFrameType.UNKNOWN) {
            return null;
        }
        RemoteXBeeDevice remoteDevice = null;
        XBee64BitAddress addr64 = null;
        XBee16BitAddress addr16 = null;
        Inet6Address addrIPv6 = null;
        XBeeNetwork network = this.xbeeDevice.getNetwork();
        if (network == null && this.xbeeDevice.getXBeeProtocol() != XBeeProtocol.THREAD) {
            return null;
        }
        switch (apiType) {
            case RECEIVE_PACKET: {
                ReceivePacket receivePacket = (ReceivePacket)apiPacket;
                addr64 = receivePacket.get64bitSourceAddress();
                addr16 = receivePacket.get16bitSourceAddress();
                if (!addr64.equals(XBee64BitAddress.UNKNOWN_ADDRESS)) {
                    remoteDevice = network.getDevice(addr64);
                    break;
                }
                if (addr16.equals(XBee16BitAddress.UNKNOWN_ADDRESS)) break;
                remoteDevice = network.getDevice(addr16);
                break;
            }
            case RX_64: {
                RX64Packet rx64Packet = (RX64Packet)apiPacket;
                addr64 = rx64Packet.get64bitSourceAddress();
                remoteDevice = network.getDevice(addr64);
                break;
            }
            case RX_16: {
                RX16Packet rx16Packet = (RX16Packet)apiPacket;
                addr64 = XBee64BitAddress.UNKNOWN_ADDRESS;
                addr16 = rx16Packet.get16bitSourceAddress();
                remoteDevice = network.getDevice(addr16);
                break;
            }
            case RX_IPV6: {
                RXIPv6Packet rxIPv6Packet = (RXIPv6Packet)apiPacket;
                addrIPv6 = rxIPv6Packet.getSourceAddress();
                if (this.xbeeDevice.getXBeeProtocol() == XBeeProtocol.THREAD) {
                    remoteDevice = new RemoteThreadDevice(this.xbeeDevice, addrIPv6);
                    break;
                }
                remoteDevice = new RemoteXBeeDevice(this.xbeeDevice, addrIPv6);
                break;
            }
            case IO_DATA_SAMPLE_RX_INDICATOR: {
                IODataSampleRxIndicatorPacket ioSamplePacket = (IODataSampleRxIndicatorPacket)apiPacket;
                addr64 = ioSamplePacket.get64bitSourceAddress();
                addr16 = ioSamplePacket.get16bitSourceAddress();
                remoteDevice = network.getDevice(addr64);
                break;
            }
            case IPV6_IO_DATA_SAMPLE_RX_INDICATOR: {
                IPv6IODataSampleRxIndicator ioSampleIPv6Packet = (IPv6IODataSampleRxIndicator)apiPacket;
                addrIPv6 = ioSampleIPv6Packet.getSourceAddress();
                if (this.xbeeDevice.getXBeeProtocol() == XBeeProtocol.THREAD) {
                    remoteDevice = new RemoteThreadDevice(this.xbeeDevice, addrIPv6);
                    break;
                }
                remoteDevice = new RemoteXBeeDevice(this.xbeeDevice, addrIPv6);
                break;
            }
            case RX_IO_64: {
                RX64IOPacket rx64IOPacket = (RX64IOPacket)apiPacket;
                addr64 = rx64IOPacket.get64bitSourceAddress();
                remoteDevice = network.getDevice(addr64);
                break;
            }
            case RX_IO_16: {
                RX16IOPacket rx16IOPacket = (RX16IOPacket)apiPacket;
                addr64 = XBee64BitAddress.UNKNOWN_ADDRESS;
                addr16 = rx16IOPacket.get16bitSourceAddress();
                remoteDevice = network.getDevice(addr16);
                break;
            }
            case EXPLICIT_RX_INDICATOR: {
                ExplicitRxIndicatorPacket explicitDataPacket = (ExplicitRxIndicatorPacket)apiPacket;
                addr64 = explicitDataPacket.get64BitSourceAddress();
                addr16 = explicitDataPacket.get16BitSourceAddress();
                remoteDevice = network.getDevice(addr64);
                break;
            }
            default: {
                return remoteDevice;
            }
        }
        if (remoteDevice == null) {
            remoteDevice = this.createRemoteXBeeDevice(addr64, addr16, null);
            if (!addr64.equals(XBee64BitAddress.UNKNOWN_ADDRESS) || !addr16.equals(XBee16BitAddress.UNKNOWN_ADDRESS)) {
                network.addRemoteDevice(remoteDevice);
            }
        }
        return remoteDevice;
    }

    private RemoteXBeeDevice createRemoteXBeeDevice(XBee64BitAddress addr64, XBee16BitAddress addr16, String ni) {
        RemoteXBeeDevice device = null;
        switch (this.xbeeDevice.getXBeeProtocol()) {
            case ZIGBEE: {
                device = new RemoteZigBeeDevice(this.xbeeDevice, addr64, addr16, ni);
                break;
            }
            case DIGI_MESH: {
                device = new RemoteDigiMeshDevice(this.xbeeDevice, addr64, ni);
                break;
            }
            case DIGI_POINT: {
                device = new RemoteDigiPointDevice(this.xbeeDevice, addr64, ni);
                break;
            }
            case RAW_802_15_4: {
                device = new RemoteRaw802Device(this.xbeeDevice, addr64, addr16, ni);
                break;
            }
            default: {
                device = new RemoteXBeeDevice(this.xbeeDevice, addr64, addr16, ni);
            }
        }
        return device;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyDataReceived(final XBeeMessage xbeeMessage) {
        if (xbeeMessage.isBroadcast()) {
            this.logger.info(this.connectionInterface.toString() + "Broadcast data received from {} >> {}.", (Object)xbeeMessage.getDevice().get64BitAddress(), (Object)HexUtils.prettyHexString(xbeeMessage.getData()));
        } else {
            this.logger.info(this.connectionInterface.toString() + "Data received from {} >> {}.", (Object)xbeeMessage.getDevice().get64BitAddress(), (Object)HexUtils.prettyHexString(xbeeMessage.getData()));
        }
        try {
            ArrayList<IDataReceiveListener> arrayList = this.dataReceiveListeners;
            synchronized (arrayList) {
                ScheduledExecutorService executor = Executors.newScheduledThreadPool(Math.min(20, this.dataReceiveListeners.size()));
                for (final IDataReceiveListener listener : this.dataReceiveListeners) {
                    if (!this.running) break;
                    executor.execute(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            IDataReceiveListener iDataReceiveListener = listener;
                            synchronized (iDataReceiveListener) {
                                listener.dataReceived(xbeeMessage);
                            }
                        }
                    });
                }
                executor.shutdown();
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyPacketReceived(final XBeePacket packet) {
        this.logger.debug(this.connectionInterface.toString() + "Packet received: \n{}", (Object)packet.toPrettyString());
        try {
            HashMap<IPacketReceiveListener, Integer> hashMap = this.packetReceiveListeners;
            synchronized (hashMap) {
                final ArrayList removeListeners = new ArrayList();
                ScheduledExecutorService executor = Executors.newScheduledThreadPool(Math.min(20, this.packetReceiveListeners.size()));
                for (final IPacketReceiveListener listener : this.packetReceiveListeners.keySet()) {
                    if (!this.running) break;
                    executor.execute(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            HashMap hashMap = DataReader.this.packetReceiveListeners;
                            synchronized (hashMap) {
                                IPacketReceiveListener iPacketReceiveListener = listener;
                                synchronized (iPacketReceiveListener) {
                                    if ((Integer)DataReader.this.packetReceiveListeners.get(listener) == 99999) {
                                        listener.packetReceived(packet);
                                    } else if (((XBeeAPIPacket)packet).needsAPIFrameID() && ((XBeeAPIPacket)packet).getFrameID() == ((Integer)DataReader.this.packetReceiveListeners.get(listener)).intValue()) {
                                        listener.packetReceived(packet);
                                        removeListeners.add(listener);
                                    }
                                }
                            }
                        }
                    });
                }
                executor.shutdown();
                for (final IPacketReceiveListener listener : removeListeners) {
                    this.packetReceiveListeners.remove(listener);
                }
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyIOSampleReceived(final RemoteXBeeDevice remoteDevice, final IOSample ioSample) {
        this.logger.debug(this.connectionInterface.toString() + "IO sample received.");
        try {
            ArrayList<IIOSampleReceiveListener> arrayList = this.ioSampleReceiveListeners;
            synchronized (arrayList) {
                ScheduledExecutorService executor = Executors.newScheduledThreadPool(Math.min(20, this.ioSampleReceiveListeners.size()));
                for (final IIOSampleReceiveListener listener : this.ioSampleReceiveListeners) {
                    if (!this.running) break;
                    executor.execute(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            IIOSampleReceiveListener iIOSampleReceiveListener = listener;
                            synchronized (iIOSampleReceiveListener) {
                                listener.ioSampleReceived(remoteDevice, ioSample);
                            }
                        }
                    });
                }
                executor.shutdown();
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyModemStatusReceived(final ModemStatusEvent modemStatusEvent) {
        this.logger.debug(this.connectionInterface.toString() + "Modem Status event received.");
        try {
            ArrayList<IModemStatusReceiveListener> arrayList = this.modemStatusListeners;
            synchronized (arrayList) {
                ScheduledExecutorService executor = Executors.newScheduledThreadPool(Math.min(20, this.modemStatusListeners.size()));
                for (final IModemStatusReceiveListener listener : this.modemStatusListeners) {
                    if (!this.running) break;
                    executor.execute(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            IModemStatusReceiveListener iModemStatusReceiveListener = listener;
                            synchronized (iModemStatusReceiveListener) {
                                listener.modemStatusEventReceived(modemStatusEvent);
                            }
                        }
                    });
                }
                executor.shutdown();
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyExplicitDataReceived(final ExplicitXBeeMessage explicitXBeeMessage) {
        if (explicitXBeeMessage.isBroadcast()) {
            this.logger.info(this.connectionInterface.toString() + "Broadcast explicit data received from {} >> {}.", (Object)explicitXBeeMessage.getDevice().get64BitAddress(), (Object)HexUtils.prettyHexString(explicitXBeeMessage.getData()));
        } else {
            this.logger.info(this.connectionInterface.toString() + "Explicit data received from {} >> {}.", (Object)explicitXBeeMessage.getDevice().get64BitAddress(), (Object)HexUtils.prettyHexString(explicitXBeeMessage.getData()));
        }
        try {
            ArrayList<IExplicitDataReceiveListener> arrayList = this.explicitDataReceiveListeners;
            synchronized (arrayList) {
                ScheduledExecutorService executor = Executors.newScheduledThreadPool(Math.min(20, this.explicitDataReceiveListeners.size()));
                for (final IExplicitDataReceiveListener listener : this.explicitDataReceiveListeners) {
                    if (!this.running) break;
                    executor.execute(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            IExplicitDataReceiveListener iExplicitDataReceiveListener = listener;
                            synchronized (iExplicitDataReceiveListener) {
                                listener.explicitDataReceived(explicitXBeeMessage);
                            }
                        }
                    });
                }
                executor.shutdown();
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyIPDataReceived(final IPMessage ipMessage) {
        this.logger.info(this.connectionInterface.toString() + "IP data received from {} >> {}.", (Object)ipMessage.getHostAddress(), (Object)HexUtils.prettyHexString(ipMessage.getData()));
        try {
            ArrayList<IIPDataReceiveListener> arrayList = this.ipDataReceiveListeners;
            synchronized (arrayList) {
                ScheduledExecutorService executor = Executors.newScheduledThreadPool(Math.min(20, this.ipDataReceiveListeners.size()));
                for (final IIPDataReceiveListener listener : this.ipDataReceiveListeners) {
                    if (!this.running) break;
                    executor.execute(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            IIPDataReceiveListener iIPDataReceiveListener = listener;
                            synchronized (iIPDataReceiveListener) {
                                listener.ipDataReceived(ipMessage);
                            }
                        }
                    });
                }
                executor.shutdown();
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifySMSReceived(final SMSMessage smsMessage) {
        this.logger.info(this.connectionInterface.toString() + "SMS received from {} >> {}.", (Object)smsMessage.getPhoneNumber(), (Object)smsMessage.getData());
        try {
            ArrayList<ISMSReceiveListener> arrayList = this.smsReceiveListeners;
            synchronized (arrayList) {
                ScheduledExecutorService executor = Executors.newScheduledThreadPool(Math.min(20, this.smsReceiveListeners.size()));
                for (final ISMSReceiveListener listener : this.smsReceiveListeners) {
                    if (!this.running) break;
                    executor.execute(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            ISMSReceiveListener iSMSReceiveListener = listener;
                            synchronized (iSMSReceiveListener) {
                                listener.smsReceived(smsMessage);
                            }
                        }
                    });
                }
                executor.shutdown();
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void notifyUserDataRelayReceived(UserDataRelayMessage relayMessage) {
        this.logger.info(this.connectionInterface.toString() + "User Data Relay received from {} >> {}.", (Object)relayMessage.getSourceInterface().getDescription(), (Object)(relayMessage.getData() != null ? HexUtils.prettyHexString(relayMessage.getData()) : ""));
        this.notifyUserDataRelayReceived(relayMessage, true);
        this.notifyUserDataRelayReceived(relayMessage, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyUserDataRelayReceived(final UserDataRelayMessage relayMessage, final boolean notifyGeneric) {
        ArrayList<Object> listenerList = new ArrayList();
        if (notifyGeneric) {
            listenerList = this.dataRelayReceiveListeners;
        } else {
            switch (relayMessage.getSourceInterface()) {
                case SERIAL: {
                    listenerList = this.serialDataReceiveListeners;
                    break;
                }
                case BLUETOOTH: {
                    listenerList = this.bluetoothDataReceiveListeners;
                    break;
                }
                case MICROPYTHON: {
                    listenerList = this.microPythonDataReceiveListeners;
                    break;
                }
            }
        }
        try {
            ArrayList<Object> arrayList = listenerList;
            synchronized (arrayList) {
                ScheduledExecutorService executor = Executors.newScheduledThreadPool(Math.min(20, listenerList.size()));
                for (final Object listener : listenerList) {
                    if (!this.running) break;
                    executor.execute(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Object object = listener;
                            synchronized (object) {
                                if (notifyGeneric) {
                                    ((IUserDataRelayReceiveListener)listener).userDataRelayReceived(relayMessage);
                                } else {
                                    switch (relayMessage.getSourceInterface()) {
                                        case SERIAL: {
                                            ((ISerialDataReceiveListener)listener).dataReceived(relayMessage.getData());
                                            break;
                                        }
                                        case BLUETOOTH: {
                                            ((IBluetoothDataReceiveListener)listener).dataReceived(relayMessage.getData());
                                            break;
                                        }
                                        case MICROPYTHON: {
                                            ((IMicroPythonDataReceiveListener)listener).dataReceived(relayMessage.getData());
                                            break;
                                        }
                                    }
                                }
                            }
                        }
                    });
                }
                executor.shutdown();
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopReader() {
        this.running = false;
        IConnectionInterface iConnectionInterface = this.connectionInterface;
        synchronized (iConnectionInterface) {
            this.connectionInterface.notify();
        }
        this.logger.debug(this.connectionInterface.toString() + "Data reader stopped.");
    }

    public XBeePacketsQueue getXBeePacketsQueue() {
        return this.xbeePacketsQueue;
    }
}

