/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api;

import com.digi.xbee.api.RemoteXBeeDevice;
import com.digi.xbee.api.XBee;
import com.digi.xbee.api.XBeeDevice;
import com.digi.xbee.api.XBeeNetwork;
import com.digi.xbee.api.connection.IConnectionInterface;
import com.digi.xbee.api.connection.serial.SerialPortParameters;
import com.digi.xbee.api.exceptions.InterfaceNotOpenException;
import com.digi.xbee.api.exceptions.OperationNotSupportedException;
import com.digi.xbee.api.exceptions.TimeoutException;
import com.digi.xbee.api.exceptions.XBeeException;
import com.digi.xbee.api.listeners.IDataReceiveListener;
import com.digi.xbee.api.listeners.IIPDataReceiveListener;
import com.digi.xbee.api.models.IPMessage;
import com.digi.xbee.api.models.IPProtocol;
import com.digi.xbee.api.models.XBee16BitAddress;
import com.digi.xbee.api.models.XBee64BitAddress;
import com.digi.xbee.api.models.XBeeMessage;
import com.digi.xbee.api.models.XBeePacketsQueue;
import com.digi.xbee.api.packet.XBeeAPIPacket;
import com.digi.xbee.api.packet.XBeePacket;
import com.digi.xbee.api.packet.ip.RXIPv4Packet;
import com.digi.xbee.api.packet.ip.TXIPv4Packet;
import com.digi.xbee.api.utils.ByteUtils;
import com.digi.xbee.api.utils.HexUtils;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.UnknownHostException;

public class IPDevice
extends XBeeDevice {
    public static final String BROADCAST_IP = "255.255.255.255";
    private static final String OPERATION_EXCEPTION = "Operation not supported in this module.";
    protected static final short DEFAULT_SOURCE_PORT = 9750;
    protected static final IPProtocol DEFAULT_PROTOCOL = IPProtocol.TCP;
    protected Inet4Address ipAddress;
    protected int sourcePort = 9750;

    protected IPDevice(String port, int baudRate) {
        this(XBee.createConnectiontionInterface(port, baudRate));
    }

    protected IPDevice(String port, int baudRate, int dataBits, int stopBits, int parity, int flowControl) {
        this(port, new SerialPortParameters(baudRate, dataBits, stopBits, parity, flowControl));
    }

    protected IPDevice(String port, SerialPortParameters serialPortParameters) {
        this(XBee.createConnectiontionInterface(port, serialPortParameters));
    }

    protected IPDevice(IConnectionInterface connectionInterface) {
        super(connectionInterface);
    }

    @Override
    public XBeeNetwork getNetwork() {
        return null;
    }

    @Override
    public void readDeviceInfo() throws TimeoutException, XBeeException {
        super.readDeviceInfo();
        byte[] response = this.getParameter("MY");
        try {
            this.ipAddress = (Inet4Address)Inet4Address.getByAddress(response);
        }
        catch (UnknownHostException e) {
            throw new XBeeException(e);
        }
        try {
            response = this.getParameter("C0");
            this.sourcePort = ByteUtils.byteArrayToInt(response);
        }
        catch (TimeoutException timeoutException) {
        }
        catch (XBeeException xBeeException) {
            // empty catch block
        }
    }

    public Inet4Address getIPAddress() {
        return this.ipAddress;
    }

    public void setDestinationIPAddress(Inet4Address address) throws TimeoutException, XBeeException {
        if (address == null) {
            throw new NullPointerException("Destination IP address cannot be null.");
        }
        this.setParameter("DL", address.getAddress());
    }

    public Inet4Address getDestinationIPAddress() throws TimeoutException, XBeeException {
        try {
            return (Inet4Address)Inet4Address.getByAddress(this.getParameter("DL"));
        }
        catch (UnknownHostException e) {
            throw new XBeeException(e);
        }
    }

    @Override
    public Inet6Address getIPv6Address() {
        return null;
    }

    @Override
    public Inet6Address getIPv6DestinationAddress() throws TimeoutException, XBeeException {
        throw new UnsupportedOperationException(OPERATION_EXCEPTION);
    }

    @Override
    public void setIPv6DestinationAddress(Inet6Address ipv6Address) throws TimeoutException, XBeeException {
        throw new UnsupportedOperationException(OPERATION_EXCEPTION);
    }

    @Override
    public XBee16BitAddress get16BitAddress() {
        return null;
    }

    @Override
    public XBee64BitAddress getDestinationAddress() throws TimeoutException, XBeeException {
        throw new UnsupportedOperationException(OPERATION_EXCEPTION);
    }

    @Override
    public void setDestinationAddress(XBee64BitAddress xbee64BitAddress) throws TimeoutException, XBeeException {
        throw new UnsupportedOperationException(OPERATION_EXCEPTION);
    }

    @Override
    public byte[] getPANID() throws TimeoutException, XBeeException {
        throw new UnsupportedOperationException(OPERATION_EXCEPTION);
    }

    @Override
    public void setPANID(byte[] panID) throws TimeoutException, XBeeException {
        throw new UnsupportedOperationException(OPERATION_EXCEPTION);
    }

    @Override
    public void addDataListener(IDataReceiveListener listener) {
        throw new UnsupportedOperationException(OPERATION_EXCEPTION);
    }

    @Override
    public void removeDataListener(IDataReceiveListener listener) {
        throw new UnsupportedOperationException(OPERATION_EXCEPTION);
    }

    @Override
    public XBeeMessage readData() {
        throw new UnsupportedOperationException(OPERATION_EXCEPTION);
    }

    @Override
    public XBeeMessage readData(int timeout) {
        throw new UnsupportedOperationException(OPERATION_EXCEPTION);
    }

    @Override
    public XBeeMessage readDataFrom(RemoteXBeeDevice remoteXBeeDevice) {
        throw new UnsupportedOperationException(OPERATION_EXCEPTION);
    }

    @Override
    public XBeeMessage readDataFrom(RemoteXBeeDevice remoteXBeeDevice, int timeout) {
        throw new UnsupportedOperationException(OPERATION_EXCEPTION);
    }

    @Override
    public void sendBroadcastData(byte[] data) throws TimeoutException, XBeeException {
        throw new UnsupportedOperationException(OPERATION_EXCEPTION);
    }

    @Override
    public void sendData(RemoteXBeeDevice remoteXBeeDevice, byte[] data) throws TimeoutException, XBeeException {
        throw new UnsupportedOperationException(OPERATION_EXCEPTION);
    }

    @Override
    public void sendDataAsync(RemoteXBeeDevice remoteXBeeDevice, byte[] data) throws XBeeException {
        throw new UnsupportedOperationException(OPERATION_EXCEPTION);
    }

    @Override
    public void addIPDataListener(IIPDataReceiveListener listener) {
        super.addIPDataListener(listener);
    }

    @Override
    public void removeIPDataListener(IIPDataReceiveListener listener) {
        super.removeIPDataListener(listener);
    }

    public void startListening(int sourcePort) throws TimeoutException, XBeeException {
        if (sourcePort < 0 || sourcePort > 65535) {
            throw new IllegalArgumentException("Source port must be between 0 and 65535.");
        }
        this.setParameter("C0", ByteUtils.shortToByteArray((short)sourcePort));
        this.sourcePort = sourcePort;
    }

    public void stopListening() throws TimeoutException, XBeeException {
        this.setParameter("C0", ByteUtils.shortToByteArray((short)0));
        this.sourcePort = 0;
    }

    public void sendIPData(Inet4Address ipAddress, int destPort, IPProtocol protocol, boolean closeSocket, byte[] data) throws TimeoutException, XBeeException {
        this.sendIPDataImpl(ipAddress, destPort, protocol, closeSocket, data);
    }

    public void sendIPData(Inet4Address ipAddress, int destPort, IPProtocol protocol, byte[] data) throws TimeoutException, XBeeException {
        this.sendIPDataImpl(ipAddress, destPort, protocol, false, data);
    }

    public void sendIPDataAsync(Inet4Address ipAddress, int destPort, IPProtocol protocol, boolean closeSocket, byte[] data) throws XBeeException {
        this.sendIPDataAsyncImpl(ipAddress, destPort, protocol, closeSocket, data);
    }

    public void sendIPDataAsync(Inet4Address ipAddress, int destPort, IPProtocol protocol, byte[] data) throws TimeoutException, XBeeException {
        this.sendIPDataAsyncImpl(ipAddress, destPort, protocol, false, data);
    }

    public void sendBroadcastIPData(int destPort, byte[] data) throws TimeoutException, XBeeException {
        try {
            this.sendIPData((Inet4Address)Inet4Address.getByName(BROADCAST_IP), destPort, IPProtocol.UDP, false, data);
        }
        catch (UnknownHostException e) {
            throw new XBeeException(e);
        }
    }

    public IPMessage readIPData() {
        return this.readIPDataPacket(null, TIMEOUT_READ_PACKET);
    }

    public IPMessage readIPData(int timeout) {
        if (timeout < 0) {
            throw new IllegalArgumentException("Read timeout must be 0 or greater.");
        }
        return this.readIPDataPacket(null, timeout);
    }

    public IPMessage readIPDataFrom(Inet4Address ipAddress) {
        if (ipAddress == null) {
            throw new NullPointerException("IP address cannot be null.");
        }
        return this.readIPDataPacket(ipAddress, TIMEOUT_READ_PACKET);
    }

    public IPMessage readIPDataFrom(Inet4Address ipAddress, int timeout) {
        if (ipAddress == null) {
            throw new NullPointerException("IP address cannot be null.");
        }
        if (timeout < 0) {
            throw new IllegalArgumentException("Read timeout must be 0 or greater.");
        }
        return this.readIPDataPacket(ipAddress, timeout);
    }

    private IPMessage readIPDataPacket(Inet4Address remoteIPAddress, int timeout) {
        int destPort;
        int sourcePort;
        if (!this.connectionInterface.isOpen()) {
            throw new InterfaceNotOpenException();
        }
        XBeePacketsQueue xbeePacketsQueue = this.dataReader.getXBeePacketsQueue();
        XBeePacket xbeePacket = null;
        xbeePacket = remoteIPAddress != null ? xbeePacketsQueue.getFirstIPDataPacketFrom(remoteIPAddress, timeout) : xbeePacketsQueue.getFirstIPDataPacket(timeout);
        if (xbeePacket == null) {
            return null;
        }
        byte[] data = null;
        Inet4Address ipAddress = null;
        IPProtocol protocol = IPProtocol.TCP;
        switch (((XBeeAPIPacket)xbeePacket).getFrameType()) {
            case RX_IPV4: {
                RXIPv4Packet receivePacket = (RXIPv4Packet)xbeePacket;
                data = receivePacket.getData();
                ipAddress = receivePacket.getSourceAddress();
                sourcePort = receivePacket.getSourcePort();
                destPort = receivePacket.getDestPort();
                break;
            }
            default: {
                return null;
            }
        }
        return new IPMessage(ipAddress, sourcePort, destPort, protocol, data);
    }

    private void sendIPDataImpl(Inet4Address ipAddress, int destPort, IPProtocol protocol, boolean closeSocket, byte[] data) throws TimeoutException, XBeeException {
        if (ipAddress == null) {
            throw new NullPointerException("IP address cannot be null");
        }
        if (protocol == null) {
            throw new NullPointerException("Protocol cannot be null");
        }
        if (data == null) {
            throw new NullPointerException("Data cannot be null");
        }
        if (destPort < 0 || destPort > 65535) {
            throw new IllegalArgumentException("Destination port must be between 0 and 65535.");
        }
        if (this.isRemote()) {
            throw new OperationNotSupportedException("Cannot send IP data from a remote device.");
        }
        int sourcePort = this.sourcePort;
        if (protocol != IPProtocol.UDP) {
            sourcePort = 0;
        }
        this.logger.debug(this.toString() + "Sending IP data to {}:{} >> {}.", new Object[]{ipAddress, destPort, HexUtils.prettyHexString(data)});
        TXIPv4Packet xbeePacket = new TXIPv4Packet(this.getNextFrameID(), ipAddress, destPort, sourcePort, protocol, closeSocket ? 2 : 0, data);
        this.sendAndCheckXBeePacket(xbeePacket, false);
    }

    private void sendIPDataAsyncImpl(Inet4Address ipAddress, int destPort, IPProtocol protocol, boolean closeSocket, byte[] data) throws XBeeException {
        if (ipAddress == null) {
            throw new NullPointerException("IP address cannot be null");
        }
        if (protocol == null) {
            throw new NullPointerException("Protocol cannot be null");
        }
        if (data == null) {
            throw new NullPointerException("Data cannot be null");
        }
        if (destPort < 0 || destPort > 65535) {
            throw new IllegalArgumentException("Destination port must be between 0 and 65535.");
        }
        if (this.isRemote()) {
            throw new OperationNotSupportedException("Cannot send IP data from a remote device.");
        }
        int sourcePort = this.sourcePort;
        if (protocol != IPProtocol.UDP) {
            sourcePort = 0;
        }
        this.logger.debug(this.toString() + "Sending IP data asynchronously to {}:{} >> {}.", new Object[]{ipAddress, destPort, HexUtils.prettyHexString(data)});
        TXIPv4Packet xbeePacket = new TXIPv4Packet(this.getNextFrameID(), ipAddress, destPort, sourcePort, protocol, closeSocket ? 2 : 0, data);
        this.sendAndCheckXBeePacket(xbeePacket, true);
    }
}

