/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api;

import com.digi.xbee.api.RemoteXBeeDevice;
import com.digi.xbee.api.XBee;
import com.digi.xbee.api.XBeeDevice;
import com.digi.xbee.api.XBeeNetwork;
import com.digi.xbee.api.connection.IConnectionInterface;
import com.digi.xbee.api.connection.serial.SerialPortParameters;
import com.digi.xbee.api.exceptions.InterfaceNotOpenException;
import com.digi.xbee.api.exceptions.OperationNotSupportedException;
import com.digi.xbee.api.exceptions.TimeoutException;
import com.digi.xbee.api.exceptions.XBeeException;
import com.digi.xbee.api.listeners.IDataReceiveListener;
import com.digi.xbee.api.listeners.IIPDataReceiveListener;
import com.digi.xbee.api.models.IPMessage;
import com.digi.xbee.api.models.IPProtocol;
import com.digi.xbee.api.models.XBee16BitAddress;
import com.digi.xbee.api.models.XBee64BitAddress;
import com.digi.xbee.api.models.XBeeMessage;
import com.digi.xbee.api.models.XBeePacketsQueue;
import com.digi.xbee.api.packet.XBeeAPIPacket;
import com.digi.xbee.api.packet.XBeePacket;
import com.digi.xbee.api.packet.thread.RXIPv6Packet;
import com.digi.xbee.api.packet.thread.TXIPv6Packet;
import com.digi.xbee.api.utils.ByteUtils;
import com.digi.xbee.api.utils.HexUtils;
import java.net.Inet6Address;
import java.net.UnknownHostException;

public class IPv6Device
extends XBeeDevice {
    private static final String OPERATION_EXCEPTION = "Operation not supported in this module.";
    protected static final short DEFAULT_SOURCE_PORT = 9750;
    protected static final IPProtocol DEFAULT_PROTOCOL = IPProtocol.TCP;
    protected int sourcePort = 9750;

    protected IPv6Device(String port, int baudRate) {
        this(XBee.createConnectiontionInterface(port, baudRate));
    }

    protected IPv6Device(String port, int baudRate, int dataBits, int stopBits, int parity, int flowControl) {
        this(port, new SerialPortParameters(baudRate, dataBits, stopBits, parity, flowControl));
    }

    protected IPv6Device(String port, SerialPortParameters serialPortParameters) {
        this(XBee.createConnectiontionInterface(port, serialPortParameters));
    }

    protected IPv6Device(IConnectionInterface connectionInterface) {
        super(connectionInterface);
    }

    @Override
    public XBeeNetwork getNetwork() {
        return null;
    }

    @Override
    public void readDeviceInfo() throws TimeoutException, XBeeException {
        super.readDeviceInfo();
        byte[] response = this.getParameter("MY");
        try {
            this.ipv6Address = (Inet6Address)Inet6Address.getByAddress(response);
        }
        catch (UnknownHostException e) {
            throw new XBeeException(e);
        }
        try {
            response = this.getParameter("C0");
            this.sourcePort = ByteUtils.byteArrayToInt(response);
        }
        catch (TimeoutException timeoutException) {
        }
        catch (XBeeException xBeeException) {
            // empty catch block
        }
    }

    @Override
    public XBee16BitAddress get16BitAddress() {
        return null;
    }

    @Override
    public XBee64BitAddress getDestinationAddress() throws TimeoutException, XBeeException {
        throw new UnsupportedOperationException(OPERATION_EXCEPTION);
    }

    @Override
    public void setDestinationAddress(XBee64BitAddress xbee64BitAddress) throws TimeoutException, XBeeException {
        throw new UnsupportedOperationException(OPERATION_EXCEPTION);
    }

    @Override
    public void addDataListener(IDataReceiveListener listener) {
        throw new UnsupportedOperationException(OPERATION_EXCEPTION);
    }

    @Override
    public void removeDataListener(IDataReceiveListener listener) {
        throw new UnsupportedOperationException(OPERATION_EXCEPTION);
    }

    @Override
    public XBeeMessage readData() {
        throw new UnsupportedOperationException(OPERATION_EXCEPTION);
    }

    @Override
    public XBeeMessage readData(int timeout) {
        throw new UnsupportedOperationException(OPERATION_EXCEPTION);
    }

    @Override
    public XBeeMessage readDataFrom(RemoteXBeeDevice remoteXBeeDevice) {
        throw new UnsupportedOperationException(OPERATION_EXCEPTION);
    }

    @Override
    public XBeeMessage readDataFrom(RemoteXBeeDevice remoteXBeeDevice, int timeout) {
        throw new UnsupportedOperationException(OPERATION_EXCEPTION);
    }

    @Override
    public void sendBroadcastData(byte[] data) throws TimeoutException, XBeeException {
        throw new UnsupportedOperationException(OPERATION_EXCEPTION);
    }

    @Override
    public void sendData(RemoteXBeeDevice remoteXBeeDevice, byte[] data) throws TimeoutException, XBeeException {
        throw new UnsupportedOperationException(OPERATION_EXCEPTION);
    }

    @Override
    public void sendDataAsync(RemoteXBeeDevice remoteXBeeDevice, byte[] data) throws XBeeException {
        throw new UnsupportedOperationException(OPERATION_EXCEPTION);
    }

    @Override
    public void addIPDataListener(IIPDataReceiveListener listener) {
        super.addIPDataListener(listener);
    }

    @Override
    public void removeIPDataListener(IIPDataReceiveListener listener) {
        super.removeIPDataListener(listener);
    }

    public void startListening(int sourcePort) throws TimeoutException, XBeeException {
        if (sourcePort < 0 || sourcePort > 65535) {
            throw new IllegalArgumentException("Source port must be between 0 and 65535.");
        }
        this.setParameter("C0", ByteUtils.shortToByteArray((short)sourcePort));
        this.sourcePort = sourcePort;
    }

    public void stopListening() throws TimeoutException, XBeeException {
        this.setParameter("C0", ByteUtils.shortToByteArray((short)0));
        this.sourcePort = 0;
    }

    public void sendIPData(Inet6Address ipv6Address, int destPort, IPProtocol protocol, byte[] data) throws TimeoutException, XBeeException {
        this.sendIPData(ipv6Address, destPort, protocol, data, false);
    }

    public void sendIPDataAsync(Inet6Address ipv6Address, int destPort, IPProtocol protocol, byte[] data) throws XBeeException {
        this.sendIPData(ipv6Address, destPort, protocol, data, true);
    }

    private void sendIPData(Inet6Address ipv6Address, int destPort, IPProtocol protocol, byte[] data, boolean async) throws XBeeException {
        if (ipv6Address == null) {
            throw new NullPointerException("IPv6 address cannot be null");
        }
        if (data == null) {
            throw new NullPointerException("Data cannot be null");
        }
        if (destPort < 0 || destPort > 65535) {
            throw new IllegalArgumentException("Destination port must be between 0 and 65535.");
        }
        if (this.isRemote()) {
            throw new OperationNotSupportedException("Cannot send IPv6 data from a remote device.");
        }
        int sourcePort = this.sourcePort;
        if (protocol != IPProtocol.UDP) {
            sourcePort = 0;
        }
        if (async) {
            this.logger.debug(this.toString() + "Sending IPv6 data asynchronously to {}:{} >> {}.", new Object[]{ipv6Address, destPort, HexUtils.prettyHexString(data)});
        } else {
            this.logger.debug(this.toString() + "Sending IPv6 data to {}:{} >> {}.", new Object[]{ipv6Address, destPort, HexUtils.prettyHexString(data)});
        }
        TXIPv6Packet xbeePacket = new TXIPv6Packet(this.getNextFrameID(), ipv6Address, destPort, sourcePort, protocol, data);
        this.sendAndCheckXBeePacket(xbeePacket, async);
    }

    public IPMessage readIPData() {
        return this.readIPDataPacket(null, TIMEOUT_READ_PACKET);
    }

    public IPMessage readIPData(int timeout) {
        if (timeout < 0) {
            throw new IllegalArgumentException("Read timeout must be 0 or greater.");
        }
        return this.readIPDataPacket(null, timeout);
    }

    public IPMessage readIPDataFrom(Inet6Address ipv6Address) {
        if (ipv6Address == null) {
            throw new NullPointerException("IPv6 address cannot be null.");
        }
        return this.readIPDataPacket(ipv6Address, TIMEOUT_READ_PACKET);
    }

    public IPMessage readIPDataFrom(Inet6Address ipv6Address, int timeout) {
        if (ipv6Address == null) {
            throw new NullPointerException("IPv6 address cannot be null.");
        }
        if (timeout < 0) {
            throw new IllegalArgumentException("Read timeout must be 0 or greater.");
        }
        return this.readIPDataPacket(ipv6Address, timeout);
    }

    private IPMessage readIPDataPacket(Inet6Address remoteIPAddress, int timeout) {
        int destPort;
        int sourcePort;
        if (!this.connectionInterface.isOpen()) {
            throw new InterfaceNotOpenException();
        }
        XBeePacketsQueue xbeePacketsQueue = this.dataReader.getXBeePacketsQueue();
        XBeePacket xbeePacket = null;
        xbeePacket = remoteIPAddress != null ? xbeePacketsQueue.getFirstIPv6DataPacketFrom(remoteIPAddress, timeout) : xbeePacketsQueue.getFirstIPv6DataPacket(timeout);
        if (xbeePacket == null) {
            return null;
        }
        byte[] data = null;
        Inet6Address ipv6Address = null;
        IPProtocol protocol = IPProtocol.TCP;
        switch (((XBeeAPIPacket)xbeePacket).getFrameType()) {
            case RX_IPV6: {
                RXIPv6Packet receivePacket = (RXIPv6Packet)xbeePacket;
                data = receivePacket.getData();
                ipv6Address = receivePacket.getSourceAddress();
                sourcePort = receivePacket.getSourcePort();
                destPort = receivePacket.getDestPort();
                break;
            }
            default: {
                return null;
            }
        }
        return new IPMessage(ipv6Address, sourcePort, destPort, protocol, data);
    }
}

