/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api;

import com.digi.xbee.api.Raw802Network;
import com.digi.xbee.api.XBee;
import com.digi.xbee.api.XBeeDevice;
import com.digi.xbee.api.XBeeNetwork;
import com.digi.xbee.api.connection.IConnectionInterface;
import com.digi.xbee.api.connection.serial.SerialPortParameters;
import com.digi.xbee.api.exceptions.InterfaceNotOpenException;
import com.digi.xbee.api.exceptions.OperationNotSupportedException;
import com.digi.xbee.api.exceptions.TimeoutException;
import com.digi.xbee.api.exceptions.XBeeDeviceException;
import com.digi.xbee.api.exceptions.XBeeException;
import com.digi.xbee.api.models.AssociationIndicationStatus;
import com.digi.xbee.api.models.XBee16BitAddress;
import com.digi.xbee.api.models.XBee64BitAddress;
import com.digi.xbee.api.models.XBeeProtocol;
import com.digi.xbee.api.packet.raw.TX16Packet;
import com.digi.xbee.api.utils.HexUtils;
import java.net.Inet6Address;

public class Raw802Device
extends XBeeDevice {
    private static final String OPERATION_EXCEPTION = "Operation not supported in 802.15.4 protocol.";

    public Raw802Device(String port, int baudRate) {
        this(XBee.createConnectiontionInterface(port, baudRate));
    }

    public Raw802Device(String port, int baudRate, int dataBits, int stopBits, int parity, int flowControl) {
        this(port, new SerialPortParameters(baudRate, dataBits, stopBits, parity, flowControl));
    }

    public Raw802Device(String port, SerialPortParameters serialPortParameters) {
        this(XBee.createConnectiontionInterface(port, serialPortParameters));
    }

    public Raw802Device(IConnectionInterface connectionInterface) {
        super(connectionInterface);
    }

    @Override
    public void open() throws XBeeException {
        super.open();
        if (this.isRemote()) {
            return;
        }
        if (this.xbeeProtocol != XBeeProtocol.RAW_802_15_4) {
            throw new XBeeDeviceException("XBee device is not a " + this.getXBeeProtocol().getDescription() + " device, it is a " + this.xbeeProtocol.getDescription() + " device.");
        }
    }

    @Override
    public XBeeNetwork getNetwork() {
        if (!this.isOpen()) {
            throw new InterfaceNotOpenException();
        }
        if (this.network == null) {
            this.network = new Raw802Network(this);
        }
        return this.network;
    }

    @Override
    public XBeeProtocol getXBeeProtocol() {
        return XBeeProtocol.RAW_802_15_4;
    }

    @Override
    public void sendDataAsync(XBee64BitAddress address, byte[] data) throws XBeeException {
        super.sendDataAsync(address, data);
    }

    public void sendDataAsync(XBee16BitAddress address, byte[] data) throws XBeeException {
        if (address == null) {
            throw new NullPointerException("Address cannot be null");
        }
        if (data == null) {
            throw new NullPointerException("Data cannot be null");
        }
        if (this.isRemote()) {
            throw new OperationNotSupportedException("Cannot send data to a remote device from a remote device.");
        }
        this.logger.info(this.toString() + "Sending data asynchronously to {} >> {}.", (Object)address, (Object)HexUtils.prettyHexString(data));
        TX16Packet xbeePacket = new TX16Packet(this.getNextFrameID(), address, 0, data);
        this.sendAndCheckXBeePacket(xbeePacket, true);
    }

    @Override
    public void sendData(XBee64BitAddress address, byte[] data) throws TimeoutException, XBeeException {
        super.sendData(address, data);
    }

    public void sendData(XBee16BitAddress address, byte[] data) throws TimeoutException, XBeeException {
        if (address == null) {
            throw new NullPointerException("Address cannot be null");
        }
        if (data == null) {
            throw new NullPointerException("Data cannot be null");
        }
        if (this.isRemote()) {
            throw new OperationNotSupportedException("Cannot send data to a remote device from a remote device.");
        }
        this.logger.info(this.toString() + "Sending data to {} >> {}.", (Object)address, (Object)HexUtils.prettyHexString(data));
        TX16Packet xbeePacket = new TX16Packet(this.getNextFrameID(), address, 0, data);
        this.sendAndCheckXBeePacket(xbeePacket, false);
    }

    @Override
    public void set16BitAddress(XBee16BitAddress xbee16BitAddress) throws TimeoutException, XBeeException {
        super.set16BitAddress(xbee16BitAddress);
    }

    @Override
    public AssociationIndicationStatus getAssociationIndicationStatus() throws TimeoutException, XBeeException {
        return super.getAssociationIndicationStatus();
    }

    @Override
    public Inet6Address getIPv6Address() {
        return null;
    }

    @Override
    public Inet6Address getIPv6DestinationAddress() throws TimeoutException, XBeeException {
        throw new UnsupportedOperationException(OPERATION_EXCEPTION);
    }

    @Override
    public void setIPv6DestinationAddress(Inet6Address ipv6Address) throws TimeoutException, XBeeException {
        throw new UnsupportedOperationException(OPERATION_EXCEPTION);
    }
}

