/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api;

import com.digi.xbee.api.AbstractXBeeDevice;
import com.digi.xbee.api.DigiPointDevice;
import com.digi.xbee.api.RemoteXBeeDevice;
import com.digi.xbee.api.exceptions.TimeoutException;
import com.digi.xbee.api.exceptions.XBeeException;
import com.digi.xbee.api.models.XBee64BitAddress;
import com.digi.xbee.api.models.XBeeProtocol;
import java.net.Inet6Address;

public class RemoteDigiPointDevice
extends RemoteXBeeDevice {
    private static final String OPERATION_EXCEPTION = "Operation not supported in DigiPoint protocol.";

    public RemoteDigiPointDevice(DigiPointDevice localXBeeDevice, XBee64BitAddress addr64) {
        super((AbstractXBeeDevice)localXBeeDevice, addr64);
    }

    public RemoteDigiPointDevice(AbstractXBeeDevice localXBeeDevice, XBee64BitAddress addr64) {
        super(localXBeeDevice, addr64);
        if (localXBeeDevice.getXBeeProtocol() != XBeeProtocol.DIGI_POINT) {
            throw new IllegalArgumentException("The protocol of the local XBee device is not " + XBeeProtocol.DIGI_POINT.getDescription() + ".");
        }
    }

    public RemoteDigiPointDevice(AbstractXBeeDevice localXBeeDevice, XBee64BitAddress addr64, String id) {
        super(localXBeeDevice, addr64, null, id);
        if (localXBeeDevice.getXBeeProtocol() != XBeeProtocol.DIGI_POINT) {
            throw new IllegalArgumentException("The protocol of the local XBee device is not " + XBeeProtocol.DIGI_POINT.getDescription() + ".");
        }
    }

    @Override
    public XBeeProtocol getXBeeProtocol() {
        return XBeeProtocol.DIGI_POINT;
    }

    @Override
    public Inet6Address getIPv6Address() {
        return null;
    }

    @Override
    public Inet6Address getIPv6DestinationAddress() throws TimeoutException, XBeeException {
        throw new UnsupportedOperationException(OPERATION_EXCEPTION);
    }

    @Override
    public void setIPv6DestinationAddress(Inet6Address ipv6Address) throws TimeoutException, XBeeException {
        throw new UnsupportedOperationException(OPERATION_EXCEPTION);
    }
}

