/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api;

import com.digi.xbee.api.AbstractXBeeDevice;
import com.digi.xbee.api.Raw802Device;
import com.digi.xbee.api.RemoteXBeeDevice;
import com.digi.xbee.api.exceptions.TimeoutException;
import com.digi.xbee.api.exceptions.XBeeException;
import com.digi.xbee.api.models.AssociationIndicationStatus;
import com.digi.xbee.api.models.XBee16BitAddress;
import com.digi.xbee.api.models.XBee64BitAddress;
import com.digi.xbee.api.models.XBeeProtocol;
import java.net.Inet6Address;

public class RemoteRaw802Device
extends RemoteXBeeDevice {
    private static final String OPERATION_EXCEPTION = "Operation not supported in 802.15.4 protocol.";

    public RemoteRaw802Device(Raw802Device localXBeeDevice, XBee64BitAddress addr64) {
        super((AbstractXBeeDevice)localXBeeDevice, addr64);
    }

    public RemoteRaw802Device(AbstractXBeeDevice localXBeeDevice, XBee64BitAddress addr64, XBee16BitAddress addr16, String id) {
        super(localXBeeDevice, addr64, addr16, id);
        if (localXBeeDevice.getXBeeProtocol() != XBeeProtocol.RAW_802_15_4) {
            throw new IllegalArgumentException("The protocol of the local XBee device is not " + XBeeProtocol.RAW_802_15_4.getDescription() + ".");
        }
    }

    public RemoteRaw802Device(Raw802Device localXBeeDevice, XBee16BitAddress addr16) {
        super((AbstractXBeeDevice)localXBeeDevice, XBee64BitAddress.UNKNOWN_ADDRESS);
        this.xbee16BitAddress = addr16;
    }

    public RemoteRaw802Device(AbstractXBeeDevice localXBeeDevice, XBee16BitAddress addr16) {
        super(localXBeeDevice, XBee64BitAddress.UNKNOWN_ADDRESS);
        if (localXBeeDevice.getXBeeProtocol() != XBeeProtocol.RAW_802_15_4) {
            throw new IllegalArgumentException("The protocol of the local XBee device is not " + XBeeProtocol.RAW_802_15_4.getDescription() + ".");
        }
        this.xbee16BitAddress = addr16;
    }

    public void set64BitAddress(XBee64BitAddress addr64) {
        this.xbee64BitAddress = addr64;
    }

    @Override
    public XBeeProtocol getXBeeProtocol() {
        return XBeeProtocol.RAW_802_15_4;
    }

    @Override
    public void set16BitAddress(XBee16BitAddress xbee16BitAddress) throws TimeoutException, XBeeException {
        super.set16BitAddress(xbee16BitAddress);
    }

    @Override
    public AssociationIndicationStatus getAssociationIndicationStatus() throws TimeoutException, XBeeException {
        return super.getAssociationIndicationStatus();
    }

    @Override
    public Inet6Address getIPv6Address() {
        return null;
    }

    @Override
    public Inet6Address getIPv6DestinationAddress() throws TimeoutException, XBeeException {
        throw new UnsupportedOperationException(OPERATION_EXCEPTION);
    }

    @Override
    public void setIPv6DestinationAddress(Inet6Address ipv6Address) throws TimeoutException, XBeeException {
        throw new UnsupportedOperationException(OPERATION_EXCEPTION);
    }
}

