/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api;

import com.digi.xbee.api.AbstractXBeeDevice;
import com.digi.xbee.api.RemoteXBeeDevice;
import com.digi.xbee.api.ZigBeeDevice;
import com.digi.xbee.api.exceptions.TimeoutException;
import com.digi.xbee.api.exceptions.XBeeException;
import com.digi.xbee.api.models.AssociationIndicationStatus;
import com.digi.xbee.api.models.XBee16BitAddress;
import com.digi.xbee.api.models.XBee64BitAddress;
import com.digi.xbee.api.models.XBeeProtocol;
import java.net.Inet6Address;

public class RemoteZigBeeDevice
extends RemoteXBeeDevice {
    private static final String OPERATION_EXCEPTION = "Operation not supported in ZigBee protocol.";

    public RemoteZigBeeDevice(ZigBeeDevice localXBeeDevice, XBee64BitAddress addr64) {
        super((AbstractXBeeDevice)localXBeeDevice, addr64);
    }

    public RemoteZigBeeDevice(AbstractXBeeDevice localXBeeDevice, XBee64BitAddress addr64) {
        super(localXBeeDevice, addr64);
        if (localXBeeDevice.getXBeeProtocol() != XBeeProtocol.ZIGBEE) {
            throw new IllegalArgumentException("The protocol of the local XBee device is not " + XBeeProtocol.ZIGBEE.getDescription() + ".");
        }
    }

    public RemoteZigBeeDevice(AbstractXBeeDevice localXBeeDevice, XBee64BitAddress addr64, XBee16BitAddress addr16, String ni) {
        super(localXBeeDevice, addr64, addr16, ni);
        if (localXBeeDevice.getXBeeProtocol() != XBeeProtocol.ZIGBEE) {
            throw new IllegalArgumentException("The protocol of the local XBee device is not " + XBeeProtocol.ZIGBEE.getDescription() + ".");
        }
    }

    @Override
    public XBeeProtocol getXBeeProtocol() {
        return XBeeProtocol.ZIGBEE;
    }

    @Override
    public AssociationIndicationStatus getAssociationIndicationStatus() throws TimeoutException, XBeeException {
        return super.getAssociationIndicationStatus();
    }

    @Override
    public void forceDisassociate() throws TimeoutException, XBeeException {
        super.forceDisassociate();
    }

    @Override
    public Inet6Address getIPv6Address() {
        return null;
    }

    @Override
    public Inet6Address getIPv6DestinationAddress() throws TimeoutException, XBeeException {
        throw new UnsupportedOperationException(OPERATION_EXCEPTION);
    }

    @Override
    public void setIPv6DestinationAddress(Inet6Address ipv6Address) throws TimeoutException, XBeeException {
        throw new UnsupportedOperationException(OPERATION_EXCEPTION);
    }
}

