/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api;

import com.digi.xbee.api.IPDevice;
import com.digi.xbee.api.XBee;
import com.digi.xbee.api.connection.IConnectionInterface;
import com.digi.xbee.api.connection.serial.SerialPortParameters;
import com.digi.xbee.api.exceptions.InterfaceNotOpenException;
import com.digi.xbee.api.exceptions.InvalidOperatingModeException;
import com.digi.xbee.api.exceptions.TimeoutException;
import com.digi.xbee.api.exceptions.XBeeDeviceException;
import com.digi.xbee.api.exceptions.XBeeException;
import com.digi.xbee.api.listeners.IPacketReceiveListener;
import com.digi.xbee.api.models.ATCommandStatus;
import com.digi.xbee.api.models.AccessPoint;
import com.digi.xbee.api.models.IPAddressingMode;
import com.digi.xbee.api.models.WiFiAssociationIndicationStatus;
import com.digi.xbee.api.models.WiFiEncryptionType;
import com.digi.xbee.api.models.XBeeProtocol;
import com.digi.xbee.api.packet.APIFrameType;
import com.digi.xbee.api.packet.XBeeAPIPacket;
import com.digi.xbee.api.packet.XBeePacket;
import com.digi.xbee.api.packet.common.ATCommandPacket;
import com.digi.xbee.api.packet.common.ATCommandResponsePacket;
import com.digi.xbee.api.utils.ByteUtils;
import java.io.ByteArrayInputStream;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;

public class WiFiDevice
extends IPDevice {
    private static final int DEFAULT_ACCESS_POINT_TIMETOUT = 15000;
    private static final String AS_COMMAND = "AS";
    private static final String ERROR_ALREADY_CONNECTED = "Device is already connected to an access point.";
    private static final int DISCOVER_TIMEOUT = 30000;
    private boolean scanningAccessPoints = false;
    private boolean scanningAccessPointsError = false;
    protected int accessPointTimeout = 15000;

    public WiFiDevice(String port, int baudRate) {
        this(XBee.createConnectiontionInterface(port, baudRate));
    }

    public WiFiDevice(String port, int baudRate, int dataBits, int stopBits, int parity, int flowControl) {
        this(port, new SerialPortParameters(baudRate, dataBits, stopBits, parity, flowControl));
    }

    public WiFiDevice(String port, SerialPortParameters serialPortParameters) {
        this(XBee.createConnectiontionInterface(port, serialPortParameters));
    }

    public WiFiDevice(IConnectionInterface connectionInterface) {
        super(connectionInterface);
    }

    @Override
    public void open() throws XBeeException {
        super.open();
        if (this.xbeeProtocol != XBeeProtocol.XBEE_WIFI) {
            throw new XBeeDeviceException("XBee device is not a " + this.getXBeeProtocol().getDescription() + " device, it is a " + this.xbeeProtocol.getDescription() + " device.");
        }
    }

    @Override
    public XBeeProtocol getXBeeProtocol() {
        return XBeeProtocol.XBEE_WIFI;
    }

    public WiFiAssociationIndicationStatus getWiFiAssociationIndicationStatus() throws TimeoutException, XBeeException {
        byte[] associationIndicationValue = this.getParameter("AI");
        return WiFiAssociationIndicationStatus.get(ByteUtils.byteArrayToInt(associationIndicationValue));
    }

    public AccessPoint getAccessPoint(String ssid) throws XBeeException {
        if (ssid == null) {
            throw new NullPointerException("SSID cannot be null.");
        }
        this.logger.debug("{}AS for '{}' access point.", (Object)this.toString(), (Object)ssid);
        List<AccessPoint> accessPointsList = this.scanAccessPoints();
        for (AccessPoint accessPoint : accessPointsList) {
            if (!accessPoint.getSSID().equals(ssid)) continue;
            return accessPoint;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AccessPoint> scanAccessPoints() throws XBeeException {
        if (!this.isOpen()) {
            throw new InterfaceNotOpenException();
        }
        final ArrayList<AccessPoint> accessPointsList = new ArrayList<AccessPoint>();
        switch (this.getOperatingMode()) {
            default: {
                throw new InvalidOperatingModeException(this.operatingMode);
            }
            case API: 
            case API_ESCAPE: 
        }
        IPacketReceiveListener packetReceiveListener = new IPacketReceiveListener(){

            @Override
            public void packetReceived(XBeePacket receivedPacket) {
                if (!WiFiDevice.this.scanningAccessPoints) {
                    return;
                }
                try {
                    if (((XBeeAPIPacket)receivedPacket).getFrameType() != APIFrameType.AT_COMMAND_RESPONSE) {
                        return;
                    }
                    ATCommandResponsePacket response = (ATCommandResponsePacket)receivedPacket;
                    if (!response.getCommand().equals(WiFiDevice.AS_COMMAND)) {
                        return;
                    }
                    if (response.getStatus() == ATCommandStatus.ERROR) {
                        WiFiDevice.this.scanningAccessPointsError = true;
                        WiFiDevice.this.scanningAccessPoints = false;
                    } else if (response.getCommandValue() == null || response.getCommandValue().length == 0) {
                        WiFiDevice.this.scanningAccessPoints = false;
                    } else {
                        AccessPoint accessPoint = WiFiDevice.this.parseDiscoveredAccessPoint(response.getCommandValue());
                        if (accessPoint != null) {
                            accessPointsList.add(accessPoint);
                        }
                    }
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
        };
        this.logger.debug("{}Start scanning access points.", (Object)this.toString());
        this.addPacketListener(packetReceiveListener);
        try {
            this.scanningAccessPoints = true;
            this.sendPacketAsync(new ATCommandPacket(this.getNextFrameID(), AS_COMMAND, ""));
            long deadLine = System.currentTimeMillis() + 30000L;
            while (this.scanningAccessPoints && System.currentTimeMillis() < deadLine) {
                this.sleep(100);
            }
            if (this.scanningAccessPoints) {
                throw new TimeoutException();
            }
            if (this.scanningAccessPointsError) {
                throw new XBeeException(ERROR_ALREADY_CONNECTED);
            }
        }
        finally {
            this.scanningAccessPoints = false;
            this.scanningAccessPointsError = false;
            this.removePacketListener(packetReceiveListener);
            this.logger.debug("{}Stop scanning access points.", (Object)this.toString());
        }
        return accessPointsList;
    }

    public boolean connect(String ssid, String password) throws TimeoutException, XBeeException {
        if (ssid == null) {
            throw new NullPointerException("SSID cannot be null.");
        }
        AccessPoint accessPoint = this.getAccessPoint(ssid);
        if (accessPoint == null) {
            throw new XBeeException("Couldn't find any access point with the proviced SSID.");
        }
        return this.connect(accessPoint, password);
    }

    public boolean connect(AccessPoint accessPoint, String password) throws TimeoutException, XBeeException {
        if (accessPoint == null) {
            throw new NullPointerException("Access point cannot be null.");
        }
        this.setParameter("ID", accessPoint.getSSID().getBytes());
        this.setParameter("EE", new byte[]{(byte)accessPoint.getEncryptionType().getID()});
        if (password != null && accessPoint.getEncryptionType() != WiFiEncryptionType.NONE) {
            this.setParameter("PK", password.getBytes());
        }
        long deadLine = System.currentTimeMillis() + (long)this.accessPointTimeout;
        while (System.currentTimeMillis() < deadLine) {
            this.sleep(100);
            byte[] status = this.getParameter("AI");
            if (status == null || status.length < 1 || status[0] != 0) continue;
            return true;
        }
        return false;
    }

    public boolean disconnect() throws TimeoutException, XBeeException {
        this.executeParameter("NR");
        long deadLine = System.currentTimeMillis() + (long)this.accessPointTimeout;
        while (System.currentTimeMillis() < deadLine) {
            this.sleep(100);
            byte[] status = this.getParameter("AI");
            if (status == null || status.length < 1 || status[0] != 35) continue;
            return true;
        }
        return false;
    }

    public boolean isConnected() throws TimeoutException, XBeeException {
        WiFiAssociationIndicationStatus status = this.getWiFiAssociationIndicationStatus();
        return status == WiFiAssociationIndicationStatus.SUCCESSFULLY_JOINED;
    }

    private AccessPoint parseDiscoveredAccessPoint(byte[] data) {
        AccessPoint accessPoint = null;
        String ssidName = "";
        ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
        if (inputStream.available() == 0) {
            return null;
        }
        int version = ByteUtils.byteArrayToInt(ByteUtils.readBytes(1, inputStream));
        if (inputStream.available() == 0) {
            return null;
        }
        int channel = ByteUtils.byteArrayToInt(ByteUtils.readBytes(1, inputStream));
        if (inputStream.available() == 0) {
            return null;
        }
        int security = ByteUtils.byteArrayToInt(ByteUtils.readBytes(1, inputStream));
        if (inputStream.available() == 0) {
            return null;
        }
        int signalStrength = ByteUtils.byteArrayToInt(ByteUtils.readBytes(1, inputStream));
        int signalQuality = this.getSignalQuality(version, signalStrength);
        if (inputStream.available() == 0) {
            return null;
        }
        int readByte = -1;
        while ((readByte = inputStream.read()) != -1) {
            ssidName = ssidName + new String(new byte[]{(byte)(readByte & 0xFF)});
        }
        accessPoint = new AccessPoint(ssidName, WiFiEncryptionType.get(security), channel, signalQuality);
        this.logger.debug("{}Discovered: SSID[{}], encryption[{}], channel[{}], signal quality[{}].", new Object[]{this.toString(), ssidName, WiFiEncryptionType.get(security).name(), channel, signalQuality});
        return accessPoint;
    }

    private int getSignalQuality(int wifiVersion, int signalStrength) {
        int quality = wifiVersion == 1 ? (signalStrength <= -100 ? 0 : (signalStrength >= -50 ? 100 : 2 * (signalStrength + 100))) : 2 * signalStrength;
        if (quality > 100) {
            quality = 100;
        }
        if (quality < 0) {
            quality = 0;
        }
        return quality;
    }

    private void sleep(int milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public int getAccessPointTimeout() {
        return this.accessPointTimeout;
    }

    public void setAccessPointTimeout(int accessPointTimeout) {
        if (accessPointTimeout < 0) {
            throw new IllegalArgumentException("Access point timeout cannot be less than 0.");
        }
        this.accessPointTimeout = accessPointTimeout;
    }

    public void setIPAddressingMode(IPAddressingMode mode) throws TimeoutException, XBeeException {
        if (mode == null) {
            throw new NullPointerException("IP addressing mode cannot be null.");
        }
        this.setParameter("MA", ByteUtils.intToByteArray(mode.getID()));
    }

    public IPAddressingMode getIPAddressingMode() throws TimeoutException, XBeeException {
        return IPAddressingMode.get(ByteUtils.byteArrayToInt(this.getParameter("MA")));
    }

    public void setIPAddress(Inet4Address address) throws TimeoutException, XBeeException {
        if (address == null) {
            throw new NullPointerException("IP address cannot be null.");
        }
        this.setParameter("MY", address.getAddress());
    }

    public void setIPAddressMask(Inet4Address address) throws TimeoutException, XBeeException {
        if (address == null) {
            throw new NullPointerException("Address mask cannot be null.");
        }
        this.setParameter("MK", address.getAddress());
    }

    public Inet4Address getIPAddressMask() throws TimeoutException, XBeeException {
        try {
            return (Inet4Address)Inet4Address.getByAddress(this.getParameter("MK"));
        }
        catch (UnknownHostException e) {
            throw new XBeeException(e);
        }
    }

    public void setGatewayIPAddress(Inet4Address address) throws TimeoutException, XBeeException {
        if (address == null) {
            throw new NullPointerException("Gateway address cannot be null.");
        }
        this.setParameter("GW", address.getAddress());
    }

    public Inet4Address getGatewayIPAddress() throws TimeoutException, XBeeException {
        try {
            return (Inet4Address)Inet4Address.getByAddress(this.getParameter("GW"));
        }
        catch (UnknownHostException e) {
            throw new XBeeException(e);
        }
    }

    public void setDNSAddress(Inet4Address address) throws TimeoutException, XBeeException {
        if (address == null) {
            throw new NullPointerException("DNS address cannot be null.");
        }
        this.setParameter("NS", address.getAddress());
    }

    public Inet4Address getDNSAddress() throws TimeoutException, XBeeException {
        try {
            return (Inet4Address)Inet4Address.getByAddress(this.getParameter("NS"));
        }
        catch (UnknownHostException e) {
            throw new XBeeException(e);
        }
    }
}

