/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.connection;

import java.util.HashMap;

public enum ConnectionType {
    SERIAL(0, "Serial connection"),
    BLUETOOTH(1, "Bluetooth connection"),
    UNKNOWN(255, "Unknown");

    private int id;
    private String name;
    private static HashMap<Integer, ConnectionType> lookupTable;

    private ConnectionType(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public int getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public static ConnectionType get(int id) {
        ConnectionType connectionType = lookupTable.get(id);
        if (connectionType != null) {
            return connectionType;
        }
        return UNKNOWN;
    }

    public String toString() {
        return this.name;
    }

    static {
        lookupTable = new HashMap();
        for (ConnectionType connectionType : ConnectionType.values()) {
            lookupTable.put(connectionType.getID(), connectionType);
        }
    }
}

