/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.connection.bluetooth;

import com.digi.xbee.api.connection.ConnectionType;
import com.digi.xbee.api.connection.IConnectionInterface;
import com.digi.xbee.api.exceptions.XBeeException;
import com.digi.xbee.api.utils.ByteUtils;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public abstract class AbstractBluetoothInterface
implements IConnectionInterface {
    protected static final String SERVICE_GUID = "53DA53B9-0447-425A-B9EA-9837505EB59A";
    protected static final String TX_CHAR_GUID = "7DDDCA00-3E05-4651-9254-44074792C590";
    protected static final String RX_CHAR_GUID = "F9279EE9-2CD0-410C-81CC-ADF11E4E5AEA";
    protected static final String AES_CIPHER = "AES/CTR/NoPadding";
    protected static final int LENGTH_COUNTER = 16;
    protected Cipher cipherEnc;
    protected Cipher cipherDec;
    protected boolean encrypt = false;

    public void setEncryptionKeys(byte[] key, byte[] txNonce, byte[] rxNonce) throws XBeeException {
        byte[] txCounter = this.getCounter(txNonce, 1);
        byte[] rxCounter = this.getCounter(rxNonce, 1);
        SecretKeySpec secretKeySpec = new SecretKeySpec(key, "AES");
        try {
            this.cipherEnc = Cipher.getInstance(AES_CIPHER);
            this.cipherEnc.init(1, (Key)secretKeySpec, new IvParameterSpec(txCounter));
            this.cipherDec = Cipher.getInstance(AES_CIPHER);
            this.cipherDec.init(2, (Key)secretKeySpec, new IvParameterSpec(rxCounter));
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new XBeeException("Could not set the encryption keys", e);
        }
        this.encrypt = true;
    }

    private byte[] getCounter(byte[] nonce, int count) {
        byte[] counter = new byte[16];
        System.arraycopy(nonce, 0, counter, 0, nonce.length);
        byte[] countBytes = ByteUtils.intToByteArray(count);
        System.arraycopy(countBytes, 0, counter, nonce.length, countBytes.length);
        return counter;
    }

    @Override
    public ConnectionType getConnectionType() {
        return ConnectionType.BLUETOOTH;
    }
}

