/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.connection.serial;

public final class SerialPortParameters {
    private static final int HASH_SEED = 23;
    public final int baudrate;
    public final int dataBits;
    public final int stopBits;
    public final int parity;
    public final int flowControl;

    public SerialPortParameters(int baudrate, int dataBits, int stopBits, int parity, int flowControl) {
        if (baudrate < 0) {
            throw new IllegalArgumentException("Baudrate cannot be less than 0.");
        }
        if (dataBits < 0) {
            throw new IllegalArgumentException("Number of data bits cannot be less than 0.");
        }
        if (stopBits < 0) {
            throw new IllegalArgumentException("Number of stop bits cannot be less than 0.");
        }
        if (parity < 0) {
            throw new IllegalArgumentException("Illegal parity value.");
        }
        if (flowControl < 0) {
            throw new IllegalArgumentException("Illegal flow control value.");
        }
        this.baudrate = baudrate;
        this.dataBits = dataBits;
        this.stopBits = stopBits;
        this.parity = parity;
        this.flowControl = flowControl;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SerialPortParameters) {
            return ((SerialPortParameters)obj).baudrate == this.baudrate && ((SerialPortParameters)obj).dataBits == this.dataBits && ((SerialPortParameters)obj).stopBits == this.stopBits && ((SerialPortParameters)obj).parity == this.parity && ((SerialPortParameters)obj).flowControl == this.flowControl;
        }
        return false;
    }

    public int hashCode() {
        int hash = 23;
        hash *= hash + this.baudrate;
        hash *= hash + this.dataBits;
        hash *= hash + this.stopBits;
        hash *= hash + this.parity;
        hash *= hash + this.flowControl;
        return hash;
    }

    public String toString() {
        return "Baud Rate: " + this.baudrate + ", Data Bits: " + this.dataBits + ", Stop Bits: " + this.stopBits + ", Parity: " + this.parity + ", Flow Control: " + this.flowControl;
    }
}

