/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.connection.serial;

import com.digi.xbee.api.connection.serial.AbstractSerialPort;
import com.digi.xbee.api.connection.serial.SerialPortInfo;
import com.digi.xbee.api.connection.serial.SerialPortParameters;
import com.digi.xbee.api.exceptions.ConnectionException;
import com.digi.xbee.api.exceptions.InterfaceInUseException;
import com.digi.xbee.api.exceptions.InvalidConfigurationException;
import com.digi.xbee.api.exceptions.InvalidInterfaceException;
import com.digi.xbee.api.exceptions.PermissionDeniedException;
import gnu.io.CommPortIdentifier;
import gnu.io.CommPortOwnershipListener;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.RXTXPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.TooManyListenersException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialPortRxTx
extends AbstractSerialPort
implements SerialPortEventListener,
CommPortOwnershipListener {
    private final Object lock = new Object();
    private RXTXPort serialPort;
    private InputStream inputStream;
    private OutputStream outputStream;
    private Thread breakThread;
    private boolean breakEnabled = false;
    private CommPortIdentifier portIdentifier = null;
    private Logger logger = LoggerFactory.getLogger(SerialPortRxTx.class);

    public SerialPortRxTx(String port, SerialPortParameters parameters) {
        this(port, parameters, 10);
    }

    public SerialPortRxTx(String port, SerialPortParameters parameters, int receiveTimeout) {
        super(port, parameters, receiveTimeout);
    }

    public SerialPortRxTx(String port, int baudRate) {
        this(port, baudRate, 10);
    }

    public SerialPortRxTx(String port, int baudRate, int receiveTimeout) {
        super(port, baudRate, receiveTimeout);
    }

    @Override
    public void open() throws InterfaceInUseException, InvalidInterfaceException, InvalidConfigurationException, PermissionDeniedException {
        try {
            this.portIdentifier = CommPortIdentifier.getPortIdentifier((String)this.port);
        }
        catch (NoSuchPortException e) {
            throw new InvalidInterfaceException("No such port: " + this.port, e);
        }
        try {
            this.serialPort = (RXTXPort)this.portIdentifier.open("Serial Port " + this.port, this.receiveTimeout);
            this.connectionOpen = true;
            if (this.parameters == null) {
                this.parameters = new SerialPortParameters(this.baudRate, 8, 1, 0, 0);
            }
            this.serialPort.setSerialPortParams(this.baudRate, this.parameters.dataBits, this.parameters.stopBits, this.parameters.parity);
            this.serialPort.setFlowControlMode(this.parameters.flowControl);
            this.serialPort.enableReceiveTimeout(this.receiveTimeout);
            this.portIdentifier.addPortOwnershipListener((CommPortOwnershipListener)this);
            this.inputStream = this.serialPort.getInputStream();
            this.outputStream = this.serialPort.getOutputStream();
            this.serialPort.notifyOnDataAvailable(true);
            this.serialPort.addEventListener((SerialPortEventListener)this);
        }
        catch (PortInUseException e) {
            throw new InterfaceInUseException("Port " + this.port + " is already in use by other application(s)", e);
        }
        catch (UnsupportedCommOperationException e) {
            throw new InvalidConfigurationException(e.getMessage(), e);
        }
        catch (TooManyListenersException e) {
            throw new InvalidConfigurationException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
                this.inputStream = null;
            }
            if (this.outputStream != null) {
                this.outputStream.close();
                this.outputStream = null;
            }
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.serialPort != null) {
                try {
                    this.serialPort.notifyOnDataAvailable(false);
                    this.serialPort.removeEventListener();
                    this.portIdentifier.removePortOwnershipListener((CommPortOwnershipListener)this);
                    this.serialPort.close();
                    this.serialPort = null;
                    this.connectionOpen = false;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void serialEvent(SerialPortEvent event) {
        switch (event.getEventType()) {
            case 1: {
                try {
                    this.getInputStream().available();
                }
                catch (Exception e) {
                    this.close();
                    SerialPortRxTx serialPortRxTx = this;
                    synchronized (serialPortRxTx) {
                        this.notify();
                        return;
                    }
                }
                try {
                    if (this.getInputStream().available() <= 0) return;
                    SerialPortRxTx e = this;
                    synchronized (e) {
                        this.notify();
                        return;
                    }
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public void setBreak(boolean enabled) {
        this.breakEnabled = enabled;
        if (this.breakEnabled) {
            if (this.breakThread == null) {
                this.breakThread = new Thread(){

                    @Override
                    public void run() {
                        while (SerialPortRxTx.this.breakEnabled && SerialPortRxTx.this.serialPort != null) {
                            SerialPortRxTx.this.serialPort.sendBreak(100);
                        }
                    }
                };
                this.breakThread.start();
            }
        } else {
            if (this.breakThread != null) {
                this.breakThread.interrupt();
            }
            this.breakThread = null;
            this.serialPort.sendBreak(0);
        }
    }

    @Override
    public InputStream getInputStream() {
        return this.inputStream;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    @Override
    public void setReadTimeout(int timeout) {
        this.serialPort.disableReceiveTimeout();
        this.serialPort.enableReceiveTimeout(timeout);
    }

    @Override
    public int getReadTimeout() {
        return this.serialPort.getReceiveTimeout();
    }

    @Override
    public void setDTR(boolean state) {
        this.serialPort.setDTR(state);
    }

    @Override
    public void setRTS(boolean state) {
        this.serialPort.setRTS(state);
    }

    @Override
    public void setPortParameters(int baudRate, int dataBits, int stopBits, int parity, int flowControl) throws InvalidConfigurationException, ConnectionException {
        this.parameters = new SerialPortParameters(baudRate, dataBits, stopBits, parity, flowControl);
        if (this.serialPort != null) {
            try {
                this.serialPort.setSerialPortParams(baudRate, dataBits, stopBits, parity);
                this.serialPort.setFlowControlMode(flowControl);
            }
            catch (UnsupportedCommOperationException e) {
                throw new InvalidConfigurationException(e.getMessage(), e);
            }
        }
    }

    @Override
    public void sendBreak(int duration) {
        if (this.serialPort != null) {
            this.serialPort.sendBreak(duration);
        }
    }

    public void ownershipChange(int nType) {
        switch (nType) {
            case 3: {
                this.onSerialOwnershipRequested(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSerialOwnershipRequested(Object data) {
        try {
            throw new Exception();
        }
        catch (Exception e) {
            StackTraceElement[] elems = e.getStackTrace();
            String requester = elems[elems.length - 4].getClassName();
            SerialPortRxTx serialPortRxTx = this;
            synchronized (serialPortRxTx) {
                this.notify();
            }
            this.close();
            String myPackage = this.getClass().getPackage().getName();
            if (requester.startsWith(myPackage)) {
                requester = "another AT connection";
            }
            this.logger.warn("Connection for port {} canceled due to ownership request from {}.", (Object)this.port, (Object)requester);
            return;
        }
    }

    public static String[] listSerialPorts() {
        ArrayList<String> serialPorts = new ArrayList<String>();
        Enumeration comPorts = CommPortIdentifier.getPortIdentifiers();
        if (comPorts == null) {
            return serialPorts.toArray(new String[serialPorts.size()]);
        }
        while (comPorts.hasMoreElements()) {
            CommPortIdentifier identifier = (CommPortIdentifier)comPorts.nextElement();
            if (identifier == null) continue;
            String strName = identifier.getName();
            serialPorts.add(strName);
        }
        return serialPorts.toArray(new String[serialPorts.size()]);
    }

    public static ArrayList<SerialPortInfo> listSerialPortsInfo() {
        ArrayList<SerialPortInfo> ports = new ArrayList<SerialPortInfo>();
        Enumeration comPorts = CommPortIdentifier.getPortIdentifiers();
        if (comPorts == null) {
            return ports;
        }
        while (comPorts.hasMoreElements()) {
            CommPortIdentifier identifier = (CommPortIdentifier)comPorts.nextElement();
            if (identifier == null) continue;
            ports.add(new SerialPortInfo(identifier.getName()));
        }
        return ports;
    }

    @Override
    public boolean isCTS() {
        return this.serialPort.isCTS();
    }

    @Override
    public boolean isDSR() {
        return this.serialPort.isDSR();
    }

    @Override
    public boolean isCD() {
        return this.serialPort.isCD();
    }
}

