/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.io;

import java.util.HashMap;

public enum IOLine {
    DIO0_AD0("DIO0/AD0", 0, "D0", null),
    DIO1_AD1("DIO1/AD1", 1, "D1", null),
    DIO2_AD2("DIO2/AD2", 2, "D2", null),
    DIO3_AD3("DIO3/AD3", 3, "D3", null),
    DIO4_AD4("DIO4/AD4", 4, "D4", null),
    DIO5_AD5("DIO5/AD5", 5, "D5", null),
    DIO6("DIO6", 6, "D6", null),
    DIO7("DIO7", 7, "D7", null),
    DIO8("DIO8", 8, "D8", null),
    DIO9("DIO9", 9, "D9", null),
    DIO10_PWM0("DIO10/PWM0", 10, "P0", "M0"),
    DIO11_PWM1("DIO11/PWM1", 11, "P1", "M1"),
    DIO12("DIO12", 12, "P2", null),
    DIO13("DIO13", 13, "P3", null),
    DIO14("DIO14", 14, "P4", null),
    DIO15("DIO15", 15, "P5", null),
    DIO16("DIO16", 16, "P6", null),
    DIO17("DIO17", 17, "P7", null),
    DIO18("DIO18", 18, "P8", null),
    DIO19("DIO19", 19, "P9", null);

    private static final HashMap<Integer, IOLine> lookupTableIndex;
    private final String name;
    private final String atCommand;
    private final String atPWMCommand;
    private final int index;

    private IOLine(String name, int index, String atCommand, String atPWMCommand) {
        this.name = name;
        this.index = index;
        this.atCommand = atCommand;
        this.atPWMCommand = atPWMCommand;
    }

    public String getName() {
        return this.name;
    }

    public int getIndex() {
        return this.index;
    }

    public String getConfigurationATCommand() {
        return this.atCommand;
    }

    public boolean hasPWMCapability() {
        return this.atPWMCommand != null;
    }

    public String getPWMDutyCycleATCommand() {
        return this.atPWMCommand;
    }

    public static IOLine getDIO(int index) {
        if (lookupTableIndex.containsKey(index)) {
            return lookupTableIndex.get(index);
        }
        return null;
    }

    public String toString() {
        return this.name;
    }

    static {
        lookupTableIndex = new HashMap();
        for (IOLine dio : IOLine.values()) {
            lookupTableIndex.put(dio.getIndex(), dio);
        }
    }
}

