/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.models;

import com.digi.xbee.api.utils.HexUtils;
import java.util.HashMap;

public enum APIOutputMode {
    MODE_NATIVE(0, "Native"),
    MODE_EXPLICIT(1, "Explicit"),
    MODE_EXPLICIT_ZDO_PASSTHRU(3, "Explicit with ZDO Passthru");

    private final int value;
    private final String description;
    private static final HashMap<Integer, APIOutputMode> lookupTable;

    private APIOutputMode(int value, String description) {
        this.value = value;
        this.description = description;
    }

    public int getValue() {
        return this.value;
    }

    public String getDescription() {
        return this.description;
    }

    public static APIOutputMode get(int value) {
        APIOutputMode apiOutputMode = lookupTable.get(value);
        if (apiOutputMode != null) {
            return apiOutputMode;
        }
        return null;
    }

    public String toString() {
        return HexUtils.byteToHexString((byte)this.value) + ": " + this.description;
    }

    static {
        lookupTable = new HashMap();
        for (APIOutputMode apiOutputMode : APIOutputMode.values()) {
            lookupTable.put(apiOutputMode.getValue(), apiOutputMode);
        }
    }
}

