/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.models;

import com.digi.xbee.api.models.WiFiEncryptionType;

public class AccessPoint {
    private static final String ERROR_CHANNEL = "Channel cannot be negative.";
    private static final String ERROR_SIGNAL_QUALITY = "Signal quality must be between 0 and 100.";
    private final String ssid;
    private final WiFiEncryptionType encryptionType;
    private int channel;
    private int signalQuality;

    public AccessPoint(String ssid, WiFiEncryptionType encryptionType) {
        this(ssid, encryptionType, 0, 0);
    }

    public AccessPoint(String ssid, WiFiEncryptionType encryptionType, int channel, int signalQuality) {
        if (ssid == null) {
            throw new NullPointerException("SSID cannot be null.");
        }
        if (encryptionType == null) {
            throw new NullPointerException("Encryption type cannot be null.");
        }
        if (ssid.length() == 0) {
            throw new IllegalArgumentException("SSID cannot be empty.");
        }
        if (channel < 0) {
            throw new IllegalArgumentException(ERROR_CHANNEL);
        }
        if (signalQuality < 0 || signalQuality > 100) {
            throw new IllegalArgumentException(ERROR_SIGNAL_QUALITY);
        }
        this.ssid = ssid;
        this.encryptionType = encryptionType;
        this.channel = channel;
        this.signalQuality = signalQuality;
    }

    public String getSSID() {
        return this.ssid;
    }

    public WiFiEncryptionType getEncryptionType() {
        return this.encryptionType;
    }

    public int getChannel() {
        return this.channel;
    }

    public void setChannel(int channel) {
        if (channel < 0) {
            throw new IllegalArgumentException(ERROR_CHANNEL);
        }
        this.channel = channel;
    }

    public int getSignalQuality() {
        return this.signalQuality;
    }

    public void setSignalQuality(int signalQuality) {
        if (signalQuality < 0 || signalQuality > 100) {
            throw new IllegalArgumentException(ERROR_SIGNAL_QUALITY);
        }
        this.signalQuality = signalQuality;
    }

    public String toString() {
        StringBuilder message = new StringBuilder();
        message.append(this.ssid);
        message.append(" (");
        message.append(this.encryptionType.name());
        message.append(") - CH: ");
        message.append(this.channel);
        message.append(" - Signal: ");
        message.append(this.signalQuality);
        message.append("%");
        return message.toString();
    }
}

