/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.models;

import com.digi.xbee.api.utils.HexUtils;
import java.util.HashMap;

public enum AssociationIndicationStatus {
    SUCCESSFULLY_JOINED(0, "Successfully formed or joined a network."),
    AS_TIMEOUT(1, "Active Scan Timeout."),
    AS_NO_PANS_FOUND(2, "Active Scan found no PANs."),
    AS_ASSOCIATION_NOT_ALLOED(3, "Active Scan found PAN, but the CoordinatorAllowAssociation bit is not set."),
    AS_BEACONS_NOT_SUPPORTED(4, "Active Scan found PAN, but Coordinator and End Device are not configured to support beacons."),
    AS_ID_DOESNT_MATCH(5, "Active Scan found PAN, but the Coordinator ID parameter does not match the ID parameter of the End Device."),
    AS_CHANNEL_DOESNT_MATCH(6, "Active Scan found PAN, but the Coordinator CH parameter does not match the CH parameter of the End Device."),
    ENERGY_SCAN_TIMEOUT(7, "Energy Scan Timeout."),
    COORDINATOR_START_REQUEST_FAILED(8, "Coordinator start request failed."),
    COORDINATOR_INVALID_PARAMETER(9, "Coordinator could not start due to invalid parameter."),
    COORDINATOR_REALIGNMENT(10, "Coordinator Realignment is in progress."),
    AR_NOT_SENT(11, "Association Request not sent."),
    AR_TIMED_OUT(12, "Association Request timed out - no reply was received."),
    AR_INVALID_PARAMETER(13, "Association Request had an Invalid Parameter."),
    AR_CHANNEL_ACCESS_FAILURE(14, "Association Request Channel Access Failure. Request was not transmitted - CCA failure."),
    AR_COORDINATOT_ACK_WASNT_RECEIVED(15, "Remote Coordinator did not send an ACK after Association Request was sent."),
    AR_COORDINATOT_DIDNT_REPLY(16, "Remote Coordinator did not reply to the Association Request, but an ACK was received after sending the request."),
    SYNCHRONIZATION_LOST(18, "Sync-Loss - Lost synchronization with a Beaconing Coordinator."),
    DISSASOCIATED(19, " Disassociated - No longer associated to Coordinator."),
    NO_PANS_FOUND(33, "Scan found no PANs."),
    NO_PANS_WITH_ID_FOUND(34, "Scan found no valid PANs based on current SC and ID settings."),
    NJ_EXPIRED(35, "Valid Coordinator or Routers found, but they are not allowing joining (NJ expired)."),
    NO_JOINABLE_BEACONS_FOUND(36, "No joinable beacons were found."),
    UNEXPECTED_STATE(37, "Unexpected state, node should not be attempting to join at this time."),
    JOIN_FAILED(39, "Node Joining attempt failed (typically due to incompatible security settings)."),
    COORDINATOR_START_FAILED(42, "Coordinator Start attempt failed."),
    CHECKING_FOR_COORDINATOR(43, "Checking for an existing coordinator."),
    NETWORK_LEAVE_FAILED(44, "Attempt to leave the network failed."),
    DEVICE_DIDNT_RESPOND(171, "Attempted to join a device that did not respond."),
    UNSECURED_KEY_RECEIVED(172, "Secure join error - network security key received unsecured."),
    KEY_NOT_RECEIVED(173, "Secure join error - network security key not received."),
    INVALID_SECURITY_KEY(175, "Secure join error - joining device does not have the right preconfigured link key."),
    SCANNING_NETWORK(255, "Scanning for a network/Attempting to associate.");

    private final int value;
    private final String description;
    private static final HashMap<Integer, AssociationIndicationStatus> lookupTable;

    private AssociationIndicationStatus(int value, String description) {
        this.value = value;
        this.description = description;
    }

    public int getValue() {
        return this.value;
    }

    public String getDescription() {
        return this.description;
    }

    public static AssociationIndicationStatus get(int value) {
        return lookupTable.get(value);
    }

    public String toString() {
        return HexUtils.byteToHexString((byte)this.value) + ": " + this.description;
    }

    static {
        lookupTable = new HashMap();
        for (AssociationIndicationStatus associationIndicationStatus : AssociationIndicationStatus.values()) {
            lookupTable.put(associationIndicationStatus.getValue(), associationIndicationStatus);
        }
    }
}

