/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.models;

import com.digi.xbee.api.utils.HexUtils;
import java.util.HashMap;

public enum CellularAssociationIndicationStatus {
    SUCCESSFULLY_CONNECTED(0, "Connected to the Internet."),
    REGISTERING_CELLULAR_NETWORK(34, "Registering to cellular network"),
    CONNECTING_INTERNET(35, "Connecting to the Internet"),
    MISSING_CORRUPT(36, "The cellular component is missing, corrupt, or otherwise in error"),
    REGISTRATION_DENIED(37, "Cellular network registration denied"),
    AIRPLANE_MODE(42, "Airplane mode"),
    DIRECT_USB_MODE(43, "Direct USB mode"),
    PSM_LOW_POWER(44, "The cellular component is in the PSM low-power state"),
    BYPASS_MODE(47, "Bypass mode active"),
    INITIALIZING(255, "Initializing"),
    UNKNOWN(-1, "Unknown");

    private final int value;
    private final String description;
    private static final HashMap<Integer, CellularAssociationIndicationStatus> lookupTable;

    private CellularAssociationIndicationStatus(int value, String description) {
        this.value = value;
        this.description = description;
    }

    public int getValue() {
        return this.value;
    }

    public String getDescription() {
        return this.description;
    }

    public static CellularAssociationIndicationStatus get(int value) {
        if (lookupTable.get(value) != null) {
            return lookupTable.get(value);
        }
        return UNKNOWN;
    }

    public String toString() {
        return HexUtils.byteToHexString((byte)this.value) + ": " + this.description;
    }

    static {
        lookupTable = new HashMap();
        for (CellularAssociationIndicationStatus associationIndicationStatus : CellularAssociationIndicationStatus.values()) {
            lookupTable.put(associationIndicationStatus.getValue(), associationIndicationStatus);
        }
    }
}

