/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.models;

import com.digi.xbee.api.models.XBeeProtocol;
import java.util.Set;

public enum DiscoveryOptions {
    APPEND_DD(1, "Append device type identifier (DD)"),
    DISCOVER_MYSELF(2, "Local device sends response frame"),
    APPEND_RSSI(4, "Append RSSI (of the last hop)");

    private final int value;
    private final String description;

    private DiscoveryOptions(int value, String description) {
        this.value = value;
        this.description = description;
    }

    public int getValue() {
        return this.value;
    }

    public String getDescription() {
        return this.description;
    }

    public static int calculateDiscoveryValue(XBeeProtocol protocol, Set<DiscoveryOptions> options) {
        int value = 0;
        switch (protocol) {
            case ZIGBEE: 
            case ZNET: {
                for (DiscoveryOptions op : options) {
                    if (op == APPEND_RSSI) continue;
                    value += op.getValue();
                }
                break;
            }
            case DIGI_MESH: 
            case DIGI_POINT: 
            case XLR: 
            case XLR_DM: {
                for (DiscoveryOptions op : options) {
                    value += op.getValue();
                }
                break;
            }
            default: {
                if (!options.contains((Object)DISCOVER_MYSELF)) break;
                value = 1;
            }
        }
        return value;
    }

    public String toString() {
        return String.format("%s (%d)", this.description, this.value);
    }
}

