/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.models;

import com.digi.xbee.api.RemoteXBeeDevice;
import com.digi.xbee.api.models.XBeeMessage;

public class ExplicitXBeeMessage
extends XBeeMessage {
    private final int sourceEndpoint;
    private final int destEndpoint;
    private final int clusterID;
    private final int profileID;

    public ExplicitXBeeMessage(RemoteXBeeDevice remoteXBeeDevice, int sourceEndpoint, int destEndpoint, int clusterID, int profileID, byte[] data) {
        this(remoteXBeeDevice, sourceEndpoint, destEndpoint, clusterID, profileID, data, false);
    }

    public ExplicitXBeeMessage(RemoteXBeeDevice remoteXBeeDevice, int sourceEndpoint, int destEndpoint, int clusterID, int profileID, byte[] data, boolean isBroadcast) {
        super(remoteXBeeDevice, data, isBroadcast);
        if (sourceEndpoint < 0 || sourceEndpoint > 255) {
            throw new IllegalArgumentException("Source endpoint must be between 0 and 0xFF.");
        }
        if (destEndpoint < 0 || destEndpoint > 255) {
            throw new IllegalArgumentException("Destination endpoint must be between 0 and 0xFF.");
        }
        if (clusterID < 0 || clusterID > 65535) {
            throw new IllegalArgumentException("Cluster ID must be between 0 and 0xFF.");
        }
        if (profileID < 0 || profileID > 65535) {
            throw new IllegalArgumentException("Profile ID must be between 0 and 0xFF.");
        }
        this.sourceEndpoint = sourceEndpoint;
        this.destEndpoint = destEndpoint;
        this.clusterID = clusterID;
        this.profileID = profileID;
    }

    public int getSourceEndpoint() {
        return this.sourceEndpoint;
    }

    public int getDestinationEndpoint() {
        return this.destEndpoint;
    }

    public int getClusterID() {
        return this.clusterID;
    }

    public int getProfileID() {
        return this.profileID;
    }
}

