/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.models;

import java.util.HashMap;

public enum FrameError {
    INVALID_TYPE(2, "Invalid frame type"),
    INVALID_LENGTH(3, "Invalid frame length"),
    INVALID_CHECKSUM(4, "Erroneous checksum on last frame"),
    PAYLOAD_TOO_BIG(5, "Payload of last API frame was too big to fit into a buffer"),
    STRING_ENTRY_TOO_BIG(6, "String entry was too big on last API frame sent"),
    WRONG_STATE(7, "Wrong state to receive frame"),
    WRONG_REQUEST_ID(8, "Device request ID of device response didn't match the number in the request");

    private int id;
    private String name;
    private static HashMap<Integer, FrameError> lookupTable;

    private FrameError(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public int getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public static FrameError get(int id) {
        return lookupTable.get(id);
    }

    public String toString() {
        return this.name;
    }

    static {
        lookupTable = new HashMap();
        for (FrameError frameError : FrameError.values()) {
            lookupTable.put(frameError.getID(), frameError);
        }
    }
}

