/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.models;

import com.digi.xbee.api.models.HardwareVersionEnum;

public class HardwareVersion {
    private static final int HASH_SEED = 23;
    private final int value;
    private final String description;

    private HardwareVersion(int value, String description) {
        if (description == null) {
            throw new NullPointerException("Description cannot be null.");
        }
        if (value < 0) {
            throw new IllegalArgumentException("Value cannot be less than 0.");
        }
        if (description.length() < 1) {
            throw new IllegalArgumentException("Description cannot be empty.");
        }
        this.value = value;
        this.description = description;
    }

    public int getValue() {
        return this.value;
    }

    public String getDescription() {
        return this.description;
    }

    public static HardwareVersion get(int value) {
        HardwareVersionEnum hvEnum = HardwareVersionEnum.get(value);
        if (hvEnum == null) {
            return new HardwareVersion(value, "Unknown");
        }
        return new HardwareVersion(hvEnum.getValue(), hvEnum.getDescription());
    }

    public static HardwareVersion get(int value, String description) {
        return new HardwareVersion(value, description);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof HardwareVersion)) {
            return false;
        }
        HardwareVersion hwVersion = (HardwareVersion)obj;
        return hwVersion.getValue() == this.getValue() && hwVersion.getDescription().equals(this.getDescription());
    }

    public int hashCode() {
        int hash = 23 * (23 + this.value);
        return hash;
    }

    public String toString() {
        return "" + this.value;
    }
}

