/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.models;

import com.digi.xbee.api.models.IPProtocol;
import java.net.Inet4Address;
import java.net.Inet6Address;

public class IPMessage {
    private final Inet4Address ipAddress;
    private final Inet6Address ipv6Address;
    private final byte[] data;
    private final int sourcePort;
    private final int destPort;
    private final IPProtocol protocol;

    public IPMessage(Inet4Address ipAddress, int sourcePort, int destPort, IPProtocol protocol, byte[] data) {
        this(ipAddress, null, sourcePort, destPort, protocol, data);
    }

    public IPMessage(Inet6Address ipv6Address, int sourcePort, int destPort, IPProtocol protocol, byte[] data) {
        this(null, ipv6Address, sourcePort, destPort, protocol, data);
    }

    private IPMessage(Inet4Address ipAddress, Inet6Address ipv6Address, int sourcePort, int destPort, IPProtocol protocol, byte[] data) {
        if (ipAddress == null && ipv6Address == null) {
            throw new NullPointerException("IP address cannot be null.");
        }
        if (protocol == null) {
            throw new NullPointerException("Protocol cannot be null.");
        }
        if (data == null) {
            throw new NullPointerException("Data cannot be null.");
        }
        if (ipAddress != null && ipv6Address != null) {
            throw new IllegalArgumentException("There cannot be 2 types of IP addresses (IPv4 and IPv6) for one message.");
        }
        if (sourcePort < 0 || sourcePort > 65535) {
            throw new IllegalArgumentException("Source port must be between 0 and 65535.");
        }
        if (destPort < 0 || destPort > 65535) {
            throw new IllegalArgumentException("Destination port must be between 0 and 65535.");
        }
        this.ipAddress = ipAddress;
        this.ipv6Address = ipv6Address;
        this.sourcePort = sourcePort;
        this.destPort = destPort;
        this.protocol = protocol;
        this.data = data;
    }

    public Inet4Address getIPAddress() {
        return this.ipAddress;
    }

    public Inet6Address getIPv6Address() {
        return this.ipv6Address;
    }

    public String getHostAddress() {
        if (this.ipAddress == null) {
            return this.ipv6Address.getHostAddress();
        }
        return this.ipAddress.getHostAddress();
    }

    public int getSourcePort() {
        return this.sourcePort;
    }

    public int getDestPort() {
        return this.destPort;
    }

    public IPProtocol getProtocol() {
        return this.protocol;
    }

    public byte[] getData() {
        return this.data;
    }

    public String getDataString() {
        return new String(this.data);
    }
}

