/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.models;

import java.util.HashMap;

public enum ModemStatusEvent {
    STATUS_HARDWARE_RESET(0, "Hardware reset"),
    STATUS_WATCHDOG_TIMER_RESET(1, "Watchdog reset"),
    STATUS_JOINED_NETWORK(2, "Device associated"),
    STATUS_DISASSOCIATED(3, "Device disassociated"),
    STATUS_ERROR_SYNCHRONIZATION_LOST(4, "Configuration error/synchronization lost"),
    STATUS_COORDINATOR_REALIGNMENT(5, "Coordinator realignment"),
    STATUS_COORDINATOR_STARTED(6, "The coordinator started"),
    STATUS_NETWORK_SECURITY_KEY_UPDATED(7, "Network security key was updated"),
    STATUS_SYNCH_SENT(8, "Reserved, see twiki"),
    STATUS_SYNCH_RX(9, "Reserved, see twiki"),
    STATUS_SYNCH_MISS(10, "Reserved, see twiki"),
    STATUS_NETWORK_WOKE_UP(11, "Network Woke Up"),
    STATUS_NETWORK_WENT_TO_SLEEP(12, "Network Went To Sleep"),
    STATUS_VOLTAGE_SUPPLY_LIMIT_EXCEEDED(13, "Overvoltage"),
    STATUS_DEVICE_CLOUD_CONNECTED(14, "Device Cloud connected"),
    STATUS_DEVICE_CLOUD_DISCONNECTED(15, "Device Cloud disconnected"),
    STATUS_MODEM_KEY_ESTABLISHMT_DONE(16, "Modem key established"),
    STATUS_MODEM_CONFIG_CHANGED_WHILE_JOINING(17, "Modem configuration changed while joining"),
    STATUS_ACESS_FAULT(18, "Access fault"),
    STATUS_FATAL_STACK_ERROR(19, "Fatal stack error"),
    STATUS_MODEM_PLKE_INITIATED(20, "PLKE table initiated"),
    STATUS_MODEM_PLKE_SUCCESS(21, "PLKE table success"),
    STATUS_MODEM_PLKE_TABLE_FULL(22, "PLKE table is full"),
    STATUS_MODEM_PLKE_NOT_AUTHORIZED(23, "PLKE Not authorized"),
    STATUS_MODEM_PLKE_INVALID_TC_REQ(24, "PLKE Invalid Trust Center Request"),
    STATUS_MODEM_PLKE_TC_UPDATE_FAIL(25, "PLKE Trust Center update fail"),
    STATUS_MODEM_PLKE_BAD_EUI64(26, "PLKE Bad EUI address"),
    STATUS_MODEM_PLKE_LK_REJECTED(27, "PLKE Link Key rejected"),
    STATUS_MODEM_PLKE_UPDATE(28, "PLKE update occurred"),
    STATUS_MODEM_PLKE_CLEAR_LK_TABLE(29, "PLKE Link Key table clear"),
    STATUS_MODEM_FREQUENCY_AGILITY(30, "Zigbee Frequency agility has requested channel change"),
    STATUS_MODEM_FR_NOASSOC(31, "Zigbee special case execute ATFR when there's no joinable beacon responses after 60 seconds"),
    STATUS_MODEM_TOKENS_RECOVERED(32, "Zigbee tokens space recovered"),
    STATUS_MODEM_TOKENS_UNRECOVERABLE(33, "Zigbee tokens space unrecoverable"),
    STATUS_MODEM_TOKENS_CORRUPTED(34, "Zigbee tokens space corrupted"),
    STATUS_MODEM_METAFRAME_ERROR(48, "Zigbee Dual Mode metaframe error"),
    STATUS_BLE_CONNECT(50, "BLE Connect"),
    STATUS_BLE_DISCONNECT(51, "BLE Disconnect"),
    STATUS_BANDMASK_CONFIG_FAILED(52, "Bandmask Configuration Failed"),
    STATUS_ERROR_STACK(128, "Stack reset"),
    STATUS_FIB_BOOTLOADER_RESET(129, "FIB Bootloader reset"),
    STATUS_ERROR_AP_NOT_CONNECTED(130, "Send/join command issued without connecting from AP"),
    STATUS_ERROR_AP_NOT_FOUND(131, "Access point not found"),
    STATUS_ERROR_PSK_NOT_CONFIGURED(132, "PSK not configured"),
    STATUS_ERROR_SSID_NOT_FOUND(135, "SSID not found"),
    STATUS_ERROR_FAILED_JOIN_SECURITY(136, "Failed to join with security enabled"),
    STATUS_CORE_LOCKUP_FAILURE(137, "Core lockup or crystal failure reset"),
    STATUS_ERROR_INVALID_CHANNEL(138, "Invalid channel"),
    STATUS_LOW_VCC_RESET(139, "Low Vcc reset"),
    STATUS_ERROR_FAILED_JOIN_AP(142, "Failed to join access point"),
    STATUS_UNKNOWN(255, "UNKNOWN");

    private final int id;
    private final String description;
    private static final HashMap<Integer, ModemStatusEvent> lookupTable;

    private ModemStatusEvent(int id, String description) {
        this.id = id;
        this.description = description;
    }

    public int getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public static ModemStatusEvent get(int id) {
        ModemStatusEvent status = lookupTable.get(id);
        if (status != null) {
            return status;
        }
        return STATUS_UNKNOWN;
    }

    public String toString() {
        return String.format("0x%02X: %s", this.id, this.description);
    }

    static {
        lookupTable = new HashMap();
        for (ModemStatusEvent at : ModemStatusEvent.values()) {
            lookupTable.put(at.getId(), at);
        }
    }
}

