/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.models;

import java.util.HashMap;

public enum OperatingMode {
    AT(0, "AT mode"),
    API(1, "API mode"),
    API_ESCAPE(2, "API mode with escaped characters"),
    MICROPYTHON(4, "MicroPython REPL"),
    BYPASS(5, "Bypass mode"),
    UNKNOWN(3, "Unknown");

    private final int id;
    private final String name;
    private static final HashMap<Integer, OperatingMode> lookupTable;

    private OperatingMode(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public int getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public static OperatingMode get(int value) {
        OperatingMode operatingMode = lookupTable.get(value);
        if (operatingMode != null) {
            return operatingMode;
        }
        return UNKNOWN;
    }

    public String toString() {
        return this.name;
    }

    static {
        lookupTable = new HashMap();
        for (OperatingMode operatingMode : OperatingMode.values()) {
            lookupTable.put(operatingMode.getID(), operatingMode);
        }
    }
}

