/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.models;

import com.digi.xbee.api.utils.HexUtils;
import java.util.HashMap;

public enum PowerLevel {
    LEVEL_LOWEST(0, "Lowest"),
    LEVEL_LOW(1, "Low"),
    LEVEL_MEDIUM(2, "Medium"),
    LEVEL_HIGH(3, "High"),
    LEVEL_HIGHEST(4, "Highest"),
    LEVEL_UNKNOWN(255, "Unknown");

    private final int value;
    private final String description;
    private static final HashMap<Integer, PowerLevel> lookupTable;

    private PowerLevel(int value, String description) {
        this.value = value;
        this.description = description;
    }

    public int getValue() {
        return this.value;
    }

    public String getDescription() {
        return this.description;
    }

    public static PowerLevel get(int value) {
        PowerLevel powerLevel = lookupTable.get(value);
        if (powerLevel != null) {
            return powerLevel;
        }
        return LEVEL_UNKNOWN;
    }

    public String toString() {
        return HexUtils.byteToHexString((byte)this.value) + ": " + this.description;
    }

    static {
        lookupTable = new HashMap();
        for (PowerLevel powerLevel : PowerLevel.values()) {
            lookupTable.put(powerLevel.getValue(), powerLevel);
        }
    }
}

