/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.models;

import java.util.regex.Pattern;

public class SMSMessage {
    private static final String PHONE_NUMBER_PATTERN = "^\\+?\\d+$";
    private final String phoneNumber;
    private final String data;

    public SMSMessage(String phoneNumber, String data) {
        if (phoneNumber == null) {
            throw new NullPointerException("Phone number cannot be null.");
        }
        if (data == null) {
            throw new NullPointerException("Data cannot be null.");
        }
        if (!Pattern.matches(PHONE_NUMBER_PATTERN, phoneNumber)) {
            throw new IllegalArgumentException("Invalid phone number.");
        }
        this.phoneNumber = phoneNumber;
        this.data = data;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public String getData() {
        return this.data;
    }
}

