/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.models;

import java.util.HashMap;

public enum SpecialByte {
    ESCAPE_BYTE(125),
    HEADER_BYTE(126),
    XON_BYTE(17),
    XOFF_BYTE(19);

    private static final HashMap<Integer, SpecialByte> lookupTable;
    private final int value;

    private SpecialByte(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static SpecialByte get(int value) {
        return lookupTable.get(value);
    }

    public int escapeByte() {
        return this.value ^ 0x20;
    }

    public static boolean isSpecialByte(int byteToCheck) {
        return SpecialByte.get(byteToCheck) != null;
    }

    static {
        lookupTable = new HashMap();
        for (SpecialByte sb : SpecialByte.values()) {
            lookupTable.put(sb.getValue(), sb);
        }
    }
}

