/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.models;

import java.util.HashMap;

public enum SrpError {
    UNABLE_OFFER_B(128, "Unable to offer B (cryptographic error with content, usually due to A mod N == 0)"),
    INCORRECT_PAYLOAD_LENGTH(129, "Incorrect payload length"),
    BAD_PROOF_KEY(130, "Bad proof of key"),
    RESOURCE_ALLOCATION_ERROR(131, "Resource allocation error"),
    NOT_CORRECT_SEQUENCE(132, "Request contained a step not in the correct sequence"),
    UNKNOWN(-1, "Unknown");

    private int id;
    private String description;
    private static HashMap<Integer, SrpError> lookupTable;

    private SrpError(int id, String description) {
        this.id = id;
        this.description = description;
    }

    public int getID() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public static SrpError get(int id) {
        if (lookupTable.get(id) != null) {
            return lookupTable.get(id);
        }
        return UNKNOWN;
    }

    static {
        lookupTable = new HashMap();
        for (SrpError error : SrpError.values()) {
            lookupTable.put(error.getID(), error);
        }
    }
}

