/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.models;

import java.util.HashMap;

public enum SrpStep {
    STEP_1(1, "Step 1: client presents A value"),
    STEP_2(2, "Step 2: server presents B and salt"),
    STEP_3(3, "Step 3: client presents M1 session key validation value"),
    STEP_4(4, "Step 4: server presents M2 session key validation value and two 12-byte nonces"),
    UNKNOWN(-1, "Unknown");

    private int id;
    private String description;
    private static HashMap<Integer, SrpStep> lookupTable;

    private SrpStep(int id, String description) {
        this.id = id;
        this.description = description;
    }

    public int getID() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public static SrpStep get(int id) {
        if (lookupTable.get(id) != null) {
            return lookupTable.get(id);
        }
        return UNKNOWN;
    }

    static {
        lookupTable = new HashMap();
        for (SrpStep step : SrpStep.values()) {
            lookupTable.put(step.getID(), step);
        }
    }
}

