/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.models;

import com.digi.xbee.api.utils.HexUtils;
import java.util.HashMap;

public enum WiFiAssociationIndicationStatus {
    SUCCESSFULLY_JOINED(0, "Successfully joined to access point."),
    INITIALIZING(1, "Initialization in progress."),
    INITIALIZED(2, "Initialized, but not yet scanning."),
    DISCONNECTING(19, "Disconnecting from access point."),
    SSID_NOT_CONFIGURED(35, "SSID not configured"),
    INVALID_KEY(36, "Encryption key invalid (NULL or invalid length)."),
    JOIN_FAILED(39, "SSID found, but join failed."),
    WAITING_FOR_AUTH(64, "Waiting for WPA or WPA2 authentication."),
    WAITING_FOR_IP(65, "Joined to a network and waiting for IP address."),
    SETTING_UP_SOCKETS(66, "Joined to a network and IP configured. Setting up listening sockets."),
    SCANNING_FOR_SSID(255, "Scanning for the configured SSID.");

    private final int value;
    private final String description;
    private static final HashMap<Integer, WiFiAssociationIndicationStatus> lookupTable;

    private WiFiAssociationIndicationStatus(int value, String description) {
        this.value = value;
        this.description = description;
    }

    public int getValue() {
        return this.value;
    }

    public String getDescription() {
        return this.description;
    }

    public static WiFiAssociationIndicationStatus get(int value) {
        return lookupTable.get(value);
    }

    public String toString() {
        return HexUtils.byteToHexString((byte)this.value) + ": " + this.description;
    }

    static {
        lookupTable = new HashMap();
        for (WiFiAssociationIndicationStatus associationIndicationStatus : WiFiAssociationIndicationStatus.values()) {
            lookupTable.put(associationIndicationStatus.getValue(), associationIndicationStatus);
        }
    }
}

