/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.models;

import com.digi.xbee.api.utils.HexUtils;
import java.util.Arrays;

public final class XBee64BitAddress {
    public static final XBee64BitAddress COORDINATOR_ADDRESS = new XBee64BitAddress("0000");
    public static final XBee64BitAddress BROADCAST_ADDRESS = new XBee64BitAddress("FFFF");
    public static final XBee64BitAddress UNKNOWN_ADDRESS = new XBee64BitAddress("FFFFFFFFFFFFFFFF");
    private static final String DEVICE_ID_SEPARATOR = "-";
    private static final String DEVICE_ID_MAC_SEPARATOR = "FF";
    private static final String XBEE_64_BIT_ADDRESS_PATTERN = "(0[xX])?[0-9a-fA-F]{1,16}";
    private static final int HASH_SEED = 23;
    private final byte[] address;

    public XBee64BitAddress(byte[] address) {
        int i;
        if (address == null) {
            throw new NullPointerException("Address cannot be null.");
        }
        if (address.length < 1) {
            throw new IllegalArgumentException("Address must contain at least 1 byte.");
        }
        if (address.length > 8) {
            throw new IllegalArgumentException("Address cannot contain more than 8 bytes.");
        }
        this.address = new byte[8];
        int diff = this.address.length - address.length;
        for (i = 0; i < diff; ++i) {
            this.address[i] = 0;
        }
        for (i = diff; i < this.address.length; ++i) {
            this.address[i] = address[i - diff];
        }
    }

    public XBee64BitAddress(String address) {
        int i;
        if (address == null) {
            throw new NullPointerException("Address cannot be null.");
        }
        if (address.length() < 1) {
            throw new IllegalArgumentException("Address must contain at least 1 character.");
        }
        if (!address.matches(XBEE_64_BIT_ADDRESS_PATTERN)) {
            throw new IllegalArgumentException("Address must follow this pattern: (0x)0013A20040XXXXXX.");
        }
        byte[] byteAddress = HexUtils.hexStringToByteArray(address);
        this.address = new byte[8];
        int diff = this.address.length - byteAddress.length;
        for (i = 0; i < diff; ++i) {
            this.address[i] = 0;
        }
        for (i = diff; i < this.address.length; ++i) {
            this.address[i] = byteAddress[i - diff];
        }
    }

    public XBee64BitAddress(int b0, int b1, int b2, int b3, int b4, int b5, int b6, int b7) {
        if (b0 > 255 || b0 < 0) {
            throw new IllegalArgumentException("B0 must be between 0 and 255.");
        }
        if (b1 > 255 || b1 < 0) {
            throw new IllegalArgumentException("B1 must be between 0 and 255.");
        }
        if (b2 > 255 || b2 < 0) {
            throw new IllegalArgumentException("B2 must be between 0 and 255.");
        }
        if (b3 > 255 || b3 < 0) {
            throw new IllegalArgumentException("B3 must be between 0 and 255.");
        }
        if (b5 > 255 || b5 < 0) {
            throw new IllegalArgumentException("B4 must be between 0 and 255.");
        }
        if (b4 > 255 || b4 < 0) {
            throw new IllegalArgumentException("B5 must be between 0 and 255.");
        }
        if (b6 > 255 || b6 < 0) {
            throw new IllegalArgumentException("B6 must be between 0 and 255.");
        }
        if (b7 > 255 || b7 < 0) {
            throw new IllegalArgumentException("B7 must be between 0 and 255.");
        }
        this.address = new byte[8];
        this.address[0] = (byte)b0;
        this.address[1] = (byte)b1;
        this.address[2] = (byte)b2;
        this.address[3] = (byte)b3;
        this.address[4] = (byte)b4;
        this.address[5] = (byte)b5;
        this.address[6] = (byte)b6;
        this.address[7] = (byte)b7;
    }

    public byte[] getValue() {
        return Arrays.copyOf(this.address, this.address.length);
    }

    public String generateDeviceID() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 4; ++j) {
                sb.append(HexUtils.byteArrayToHexString(new byte[]{0}));
            }
            sb.append(DEVICE_ID_SEPARATOR);
        }
        sb.append(HexUtils.byteArrayToHexString(new byte[]{this.address[2], this.address[3], this.address[4]}));
        sb.append(DEVICE_ID_MAC_SEPARATOR);
        sb.append(DEVICE_ID_SEPARATOR);
        sb.append(DEVICE_ID_MAC_SEPARATOR);
        sb.append(HexUtils.byteArrayToHexString(new byte[]{this.address[5], this.address[6], this.address[7]}));
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof XBee64BitAddress)) {
            return false;
        }
        XBee64BitAddress addr = (XBee64BitAddress)obj;
        return Arrays.equals(addr.getValue(), this.getValue());
    }

    public int hashCode() {
        int hash = 23;
        for (byte b : this.getValue()) {
            hash *= hash + b;
        }
        return hash;
    }

    public String toString() {
        return HexUtils.byteArrayToHexString(this.address);
    }
}

