/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.models;

import java.util.HashMap;

public enum XBeeDiscoveryStatus {
    DISCOVERY_STATUS_NO_DISCOVERY_OVERHEAD(0, "No discovery overhead"),
    DISCOVERY_STATUS_ADDRESS_DISCOVERY(1, "Address discovery"),
    DISCOVERY_STATUS_ROUTE_DISCOVERY(2, "Route discovery"),
    DISCOVERY_STATUS_ADDRESS_AND_ROUTE(3, "Address and route"),
    DISCOVERY_STATUS_EXTENDED_TIMEOUT_DISCOVERY(64, "Extended timeout discovery"),
    DISCOVERY_STATUS_UNKNOWN(255, "Unknown");

    private final int id;
    private final String description;
    private static final HashMap<Integer, XBeeDiscoveryStatus> lookupTable;

    private XBeeDiscoveryStatus(int id, String description) {
        this.id = id;
        this.description = description;
    }

    public int getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public static XBeeDiscoveryStatus get(int id) {
        XBeeDiscoveryStatus status = lookupTable.get(id);
        if (status != null) {
            return status;
        }
        return DISCOVERY_STATUS_UNKNOWN;
    }

    public String toString() {
        return String.format("%s (0x%02X)", this.description, this.id);
    }

    static {
        lookupTable = new HashMap();
        for (XBeeDiscoveryStatus at : XBeeDiscoveryStatus.values()) {
            lookupTable.put(at.getId(), at);
        }
    }
}

