/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.models;

import java.util.HashMap;

public enum XBeeLocalInterface {
    SERIAL(0, "Serial port"),
    BLUETOOTH(1, "Bluetooth Low Energy"),
    MICROPYTHON(2, "MicroPython"),
    UNKNOWN(-1, "Unknown");

    private int id;
    private String description;
    private static HashMap<Integer, XBeeLocalInterface> lookupTable;

    private XBeeLocalInterface(int id, String description) {
        this.id = id;
        this.description = description;
    }

    public int getID() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public static XBeeLocalInterface get(int id) {
        if (lookupTable.get(id) != null) {
            return lookupTable.get(id);
        }
        return UNKNOWN;
    }

    static {
        lookupTable = new HashMap();
        for (XBeeLocalInterface localInterface : XBeeLocalInterface.values()) {
            lookupTable.put(localInterface.getID(), localInterface);
        }
    }
}

