/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.models;

import java.util.HashMap;

public enum XBeeTransmitStatus {
    SUCCESS(0, "Success"),
    NO_ACK(1, "No acknowledgement received"),
    CCA_FAILURE(2, "CCA failure"),
    PURGED(3, "Transmission purged, it was attempted before stack was up"),
    WIFI_PHYSICAL_ERROR(4, "Physical error occurred on the interface with the WiFi transceiver"),
    INVALID_DESTINATION(21, "Invalid destination endpoint"),
    NO_BUFFERS(24, "No buffers"),
    NETWORK_ACK_FAILURE(33, "Network ACK Failure"),
    NOT_JOINED_NETWORK(34, "Not joined to network"),
    SELF_ADDRESSED(35, "Self-addressed"),
    ADDRESS_NOT_FOUND(36, "Address not found"),
    ROUTE_NOT_FOUND(37, "Route not found"),
    BROADCAST_FAILED(38, "Broadcast source failed to hear a neighbor relay the message"),
    INVALID_BINDING_TABLE_INDEX(43, "Invalid binding table index"),
    INVALID_ENDPOINT(44, "Invalid endpoint"),
    BROADCAST_ERROR_APS(45, "Attempted broadcast with APS transmission"),
    BROADCAST_ERROR_APS_EE0(46, "Attempted broadcast with APS transmission, but EE=0"),
    SOFTWARE_ERROR(49, "A software error occurred"),
    RESOURCE_ERROR(50, "Resource error lack of free buffers, timers, etc."),
    COAP_URI_LENGTH(64, "CoAP message URI requires a nonzero length URI string terminated with a zero byte"),
    UNRECOGNIZED_DIGI_FRAME(65, "Unrecognized Digi API Frame type"),
    BADLY_COAP_REQUEST(66, "Client made a badly formed CoAP request"),
    SERVER_FAILED_COAP(67, "Server failed to handle CoAP request, perhaps due to a lack of internal resources.  The client may try again"),
    COAP_INVALID_STATUS(68, "CoAP Invalid Status"),
    COAP_MESSAGE_TIMEOUT(69, "CoAP Message Timeout, Server did not respond within the expected time"),
    COAP_MESSAGE_RESET(70, "CoAP Message Reset"),
    PAYLOAD_TOO_LARGE(116, "Data payload too large"),
    INDIRECT_MESSAGE_UNREQUESTED(117, "Indirect message unrequested"),
    SOCKET_CREATION_FAILED(118, "Attempt to create a client socket failed"),
    IP_PORT_NOT_EXIST(119, "TCP connection to given IP address and port doesn't exist. Source port is non-zero so that a new connection is not attempted"),
    UDP_SRC_PORT_NOT_MATCH_LISTENING_PORT(120, "Source port on a UDP transmission doesn't match a listening port on the transmitting module."),
    INVALID_UDP_PORT(120, "Invalid UDP port"),
    INVALID_TCP_PORT(121, "Invalid TCP port"),
    INVALID_HOST(122, "Invalid host"),
    INVALID_DATA_MODE(123, "Invalid data mode"),
    INVALID_INTERFACE(124, "Invalid interface"),
    NOT_ACCEPT_FRAMES(125, "Interface not accepting frames"),
    CONNECTION_REFUSED(128, "Connection refused"),
    CONNECTION_LOST(129, "Connection lost"),
    NO_SERVER(130, "No server"),
    SOCKET_CLOSED(131, "Socket closed"),
    UNKNOWN_SERVER(132, "Unknown server"),
    UNKNOWN_ERROR(133, "Unknown error"),
    INVALID_TLS_CONFIGURATION(134, "Invalid TLS configuration"),
    KEY_NOT_AUTHORIZED(187, "Key not authorized"),
    UNKNOWN(255, "Unknown");

    private final int id;
    private final String description;
    private static final HashMap<Integer, XBeeTransmitStatus> lookupTable;

    private XBeeTransmitStatus(int id, String description) {
        this.id = id;
        this.description = description;
    }

    public int getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public static XBeeTransmitStatus get(int id) {
        XBeeTransmitStatus status = lookupTable.get(id);
        if (status != null) {
            return status;
        }
        return UNKNOWN;
    }

    public String toString() {
        if (this.id != SUCCESS.getId()) {
            return String.format("Error: %s (0x%02X)", this.description, this.id);
        }
        return String.format("%s (0x%02X)", this.description, this.id);
    }

    static {
        lookupTable = new HashMap();
        for (XBeeTransmitStatus ts : XBeeTransmitStatus.values()) {
            lookupTable.put(ts.getId(), ts);
        }
    }
}

