/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.packet;

import com.digi.xbee.api.utils.ByteUtils;
import com.digi.xbee.api.utils.HexUtils;
import java.util.HashMap;

public enum APIFrameType {
    UNKNOWN(-1, "Unknown packet"),
    TX_64(0, "TX (Transmit) Request 64-bit address"),
    TX_16(1, "TX (Transmit) Request 16-bit address"),
    REMOTE_AT_COMMAND_REQUEST_WIFI(7, "Remote AT Command Request (Wi-Fi)"),
    AT_COMMAND(8, "AT Command"),
    AT_COMMAND_QUEUE(9, "AT Command Queue"),
    TRANSMIT_REQUEST(16, "Transmit Request"),
    EXPLICIT_ADDRESSING_COMMAND_FRAME(17, "Explicit Addressing Command Frame"),
    REMOTE_AT_COMMAND_REQUEST(23, "Remote AT Command Request"),
    TX_IPV6(26, "IPv6 Tx Request"),
    IPV6_REMOTE_AT_COMMAND_REQUEST(27, "IPv6 Remote AT Command"),
    COAP_TX_REQUEST(28, "CoAP Tx Request"),
    TX_SMS(31, "TX SMS"),
    TX_IPV4(32, "TX IPv4"),
    TX_REQUEST_TLS_PROFILE(35, "TX Request with TLS Profile"),
    SEND_DATA_REQUEST(40, "Send Data Request"),
    DEVICE_RESPONSE(42, "Device Response"),
    BLE_UNLOCK(44, "Bluetooth Unlock"),
    USER_DATA_RELAY(45, "User Data Relay"),
    RX_64(128, "RX (Receive) Packet 64-bit Address"),
    RX_16(129, "RX (Receive) Packet 16-bit Address"),
    RX_IO_64(130, "IO Data Sample RX 64-bit Address Indicator"),
    RX_IO_16(131, "IO Data Sample RX 16-bit Address Indicator"),
    REMOTE_AT_COMMAND_RESPONSE_WIFI(135, "Remote AT Command Response (Wi-Fi)"),
    AT_COMMAND_RESPONSE(136, "AT Command Response"),
    TX_STATUS(137, "TX (Transmit) Status"),
    MODEM_STATUS(138, "Modem Status"),
    TRANSMIT_STATUS(139, "Transmit Status"),
    IO_DATA_SAMPLE_RX_INDICATOR_WIFI(143, "IO Data Sample RX Indicator (Wi-Fi)"),
    RECEIVE_PACKET(144, "Receive Packet"),
    EXPLICIT_RX_INDICATOR(145, "Explicit RX Indicator"),
    IO_DATA_SAMPLE_RX_INDICATOR(146, "IO Data Sample RX Indicator"),
    REMOTE_AT_COMMAND_RESPONSE(151, "Remote Command Response"),
    RX_IPV6(154, "IPv6 Rx Response"),
    IPV6_REMOTE_AT_COMMAND_RESPONSE(155, "IPv6 Remote AT Command Response"),
    COAP_RX_RESPONSE(156, "CoAP Rx Response"),
    RX_SMS(159, "RX SMS"),
    IPV6_IO_DATA_SAMPLE_RX_INDICATOR(167, "IPv6 IO Data Sample Rx Indicator"),
    BLE_UNLOCK_RESPONSE(172, "Bluetooth Unlock Response"),
    USER_DATA_RELAY_OUTPUT(173, "User Data Relay Output"),
    RX_IPV4(176, "RX IPv4"),
    SEND_DATA_RESPONSE(184, "Send Data Response"),
    DEVICE_REQUEST(185, "Device Request"),
    DEVICE_RESPONSE_STATUS(186, "Device Response Status"),
    FRAME_ERROR(254, "Frame Error"),
    GENERIC(255, "Generic");

    private final int idValue;
    private final String name;
    private static final HashMap<Integer, APIFrameType> lookupTable;

    private APIFrameType(int idValue, String name) {
        this.idValue = idValue;
        this.name = name;
    }

    public static APIFrameType get(int value) {
        APIFrameType type = lookupTable.get(value);
        if (type == null) {
            return UNKNOWN;
        }
        return type;
    }

    public int getValue() {
        return this.idValue;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "(" + HexUtils.byteArrayToHexString(ByteUtils.intToByteArray(this.idValue)) + ") " + this.name;
    }

    static {
        lookupTable = new HashMap();
        for (APIFrameType type : APIFrameType.values()) {
            lookupTable.put(type.getValue(), type);
        }
    }
}

