/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.packet;

import com.digi.xbee.api.packet.XBeeAPIPacket;
import com.digi.xbee.api.utils.HexUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnknownXBeePacket
extends XBeeAPIPacket {
    private static final int MIN_API_PAYLOAD_LENGTH = 1;
    protected byte[] rfData;
    private Logger logger;

    public static UnknownXBeePacket createPacket(byte[] payload) {
        if (payload == null) {
            throw new NullPointerException("Unknown packet payload cannot be null.");
        }
        if (payload.length < 1) {
            throw new IllegalArgumentException("Incomplete Unknown packet.");
        }
        int apiID = payload[0] & 0xFF;
        int index = 1;
        byte[] commandData = null;
        if (index < payload.length) {
            commandData = Arrays.copyOfRange(payload, index, payload.length);
        }
        return new UnknownXBeePacket(apiID, commandData);
    }

    public UnknownXBeePacket(int apiIDValue, byte[] rfData) {
        super(apiIDValue);
        this.rfData = rfData;
        this.logger = LoggerFactory.getLogger(UnknownXBeePacket.class);
    }

    @Override
    protected byte[] getAPIPacketSpecificData() {
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        try {
            if (this.rfData != null) {
                data.write(this.rfData);
            }
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return data.toByteArray();
    }

    @Override
    public boolean needsAPIFrameID() {
        return false;
    }

    public void setRFData(byte[] rfData) {
        this.rfData = (byte[])(rfData == null ? null : Arrays.copyOf(rfData, rfData.length));
    }

    public byte[] getRFData() {
        if (this.rfData == null) {
            return null;
        }
        return Arrays.copyOf(this.rfData, this.rfData.length);
    }

    @Override
    public boolean isBroadcast() {
        return false;
    }

    @Override
    protected LinkedHashMap<String, String> getAPIPacketParameters() {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        if (this.rfData != null) {
            parameters.put("RF Data", HexUtils.prettyHexString(HexUtils.byteArrayToHexString(this.rfData)));
        }
        return parameters;
    }
}

