/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.packet;

import com.digi.xbee.api.exceptions.InvalidPacketException;
import com.digi.xbee.api.models.OperatingMode;
import com.digi.xbee.api.models.SpecialByte;
import com.digi.xbee.api.packet.XBeeChecksum;
import com.digi.xbee.api.packet.XBeePacketParser;
import com.digi.xbee.api.utils.ByteUtils;
import com.digi.xbee.api.utils.HexUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import java.util.LinkedHashMap;

public abstract class XBeePacket {
    private static final int HASH_SEED = 23;
    private XBeeChecksum checksum = new XBeeChecksum();

    protected XBeePacket() {
    }

    public byte[] generateByteArray() {
        this.checksum.reset();
        byte[] packetData = this.getPacketData();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        os.write(SpecialByte.HEADER_BYTE.getValue());
        if (packetData != null) {
            byte[] length = ByteUtils.shortToByteArray((short)packetData.length);
            byte msb = length[0];
            byte lsb = length[1];
            os.write(msb);
            os.write(lsb);
            for (int i = 0; i < packetData.length; ++i) {
                this.checksum.add(packetData[i]);
                os.write(packetData[i]);
            }
        } else {
            os.write(0);
            os.write(0);
        }
        os.write((byte)this.checksum.generate() & 0xFF);
        return os.toByteArray();
    }

    public byte[] generateByteArrayEscaped() {
        byte[] unescapedArray = this.generateByteArray();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        os.write(SpecialByte.HEADER_BYTE.getValue());
        for (int i = 1; i < unescapedArray.length; ++i) {
            if (SpecialByte.isSpecialByte(unescapedArray[i])) {
                os.write(SpecialByte.ESCAPE_BYTE.getValue());
                SpecialByte specialByte = SpecialByte.get(unescapedArray[i]);
                os.write(specialByte.escapeByte());
                continue;
            }
            os.write(unescapedArray[i]);
        }
        return os.toByteArray();
    }

    public abstract byte[] getPacketData();

    public int getPacketLength() {
        byte[] packetData = this.getPacketData();
        if (packetData == null) {
            return 0;
        }
        return packetData.length;
    }

    public int getChecksum() {
        this.checksum.reset();
        byte[] packetData = this.getPacketData();
        if (packetData != null) {
            this.checksum.add(packetData);
        }
        return (byte)this.checksum.generate() & 0xFF;
    }

    public LinkedHashMap<String, String> getParameters() {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put("Start delimiter", HexUtils.integerToHexString(SpecialByte.HEADER_BYTE.getValue(), 1));
        parameters.put("Length", HexUtils.prettyHexString(HexUtils.integerToHexString(this.getPacketLength(), 2)) + " (" + this.getPacketLength() + ")");
        parameters.putAll(this.getPacketParameters());
        parameters.put("Checksum", this.toString().substring(this.toString().length() - 2));
        return parameters;
    }

    protected abstract LinkedHashMap<String, String> getPacketParameters();

    public boolean equals(Object obj) {
        if (!(obj instanceof XBeePacket)) {
            return false;
        }
        XBeePacket packet = (XBeePacket)obj;
        return Arrays.equals(packet.generateByteArray(), this.generateByteArray());
    }

    public int hashCode() {
        byte[] array;
        int hash = 23;
        for (byte b : array = this.generateByteArray()) {
            hash = 31 * (hash + b);
        }
        return hash;
    }

    public String toString() {
        return HexUtils.byteArrayToHexString(this.generateByteArray());
    }

    public String toPrettyString() {
        String value = "Packet: " + this.toString() + "\n";
        LinkedHashMap<String, String> parameters = this.getParameters();
        for (String parameter : parameters.keySet()) {
            value = value + parameter + ": " + parameters.get(parameter) + "\n";
        }
        return value;
    }

    public static XBeePacket parsePacket(String packet, OperatingMode mode) throws InvalidPacketException {
        if (packet == null) {
            throw new NullPointerException("Packet cannot be null.");
        }
        return XBeePacket.parsePacket(HexUtils.hexStringToByteArray(packet.trim().replace(" ", "")), mode);
    }

    public static XBeePacket parsePacket(byte[] packet, OperatingMode mode) throws InvalidPacketException {
        if (packet == null) {
            throw new NullPointerException("Packet byte array cannot be null.");
        }
        if (mode != OperatingMode.API && mode != OperatingMode.API_ESCAPE) {
            throw new IllegalArgumentException("Operating mode must be API or API Escaped.");
        }
        if (packet.length == 0) {
            throw new IllegalArgumentException("Packet length should be greater than 0.");
        }
        if (packet.length > 1 && (packet[0] & 0xFF) != SpecialByte.HEADER_BYTE.getValue()) {
            throw new InvalidPacketException("Invalid start delimiter.");
        }
        XBeePacketParser parser = new XBeePacketParser();
        XBeePacket xbeePacket = parser.parsePacket(new ByteArrayInputStream(packet, 1, packet.length - 1), mode);
        return xbeePacket;
    }
}

