/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.packet.bluetooth;

import com.digi.xbee.api.models.SrpStep;
import com.digi.xbee.api.packet.APIFrameType;
import com.digi.xbee.api.packet.XBeeAPIPacket;
import com.digi.xbee.api.utils.HexUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BluetoothUnlockPacket
extends XBeeAPIPacket {
    private static final int MIN_API_PAYLOAD_LENGTH = 34;
    private static final String ERROR_PAYLOAD_NULL = "Bluetooth Unlock packet payload cannot be null.";
    private static final String ERROR_INCOMPLETE_PACKET = "Incomplete Bluetooth Unlock packet.";
    private static final String ERROR_NOT_BLE_UNLOCK = "Payload is not a Bluetooth Unlock packet.";
    private static final String ERROR_STEP_NULL = "SRP step cannot be null.";
    private static final String ERROR_DATA_NULL = "Data cannot be null.";
    private SrpStep srpStep;
    private byte[] data;
    private Logger logger;

    public static BluetoothUnlockPacket createPacket(byte[] payload) {
        if (payload == null) {
            throw new NullPointerException(ERROR_PAYLOAD_NULL);
        }
        if (payload.length < 34) {
            throw new IllegalArgumentException(ERROR_INCOMPLETE_PACKET);
        }
        if ((payload[0] & 0xFF) != APIFrameType.BLE_UNLOCK.getValue()) {
            throw new IllegalArgumentException(ERROR_NOT_BLE_UNLOCK);
        }
        int index = 1;
        SrpStep srpStep = SrpStep.get(payload[index] & 0xFF);
        byte[] data = Arrays.copyOfRange(payload, ++index, payload.length);
        return new BluetoothUnlockPacket(srpStep, data);
    }

    public BluetoothUnlockPacket(SrpStep srpStep, byte[] data) {
        super(APIFrameType.BLE_UNLOCK);
        if (srpStep == null) {
            throw new NullPointerException(ERROR_STEP_NULL);
        }
        if (data == null) {
            throw new NullPointerException(ERROR_DATA_NULL);
        }
        this.srpStep = srpStep;
        this.data = data;
        this.logger = LoggerFactory.getLogger(BluetoothUnlockPacket.class);
    }

    @Override
    public byte[] getAPIPacketSpecificData() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            os.write(this.srpStep.getID());
            os.write(this.data);
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return os.toByteArray();
    }

    @Override
    public boolean needsAPIFrameID() {
        return false;
    }

    @Override
    public boolean isBroadcast() {
        return false;
    }

    public void setSrpStep(SrpStep srpStep) {
        if (srpStep == null) {
            throw new NullPointerException(ERROR_STEP_NULL);
        }
        this.srpStep = srpStep;
    }

    public SrpStep getSrpStep() {
        return this.srpStep;
    }

    public void setData(byte[] data) {
        if (data == null) {
            throw new NullPointerException(ERROR_DATA_NULL);
        }
        this.data = data;
    }

    public byte[] getData() {
        return this.data;
    }

    @Override
    public LinkedHashMap<String, String> getAPIPacketParameters() {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put("SRP step", String.format("%s (%s)", HexUtils.prettyHexString(HexUtils.integerToHexString(this.srpStep.getID(), 1)), this.srpStep.getDescription()));
        parameters.put("Data", HexUtils.prettyHexString(HexUtils.byteArrayToHexString(this.data)));
        return parameters;
    }
}

