/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.packet.bluetooth;

import com.digi.xbee.api.models.SrpError;
import com.digi.xbee.api.models.SrpStep;
import com.digi.xbee.api.packet.APIFrameType;
import com.digi.xbee.api.packet.XBeeAPIPacket;
import com.digi.xbee.api.utils.HexUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BluetoothUnlockResponsePacket
extends XBeeAPIPacket {
    private static final int MIN_API_PAYLOAD_LENGTH = 2;
    private static final String ERROR_PAYLOAD_NULL = "Bluetooth Unlock Response packet payload cannot be null.";
    private static final String ERROR_INCOMPLETE_PACKET = "Incomplete Bluetooth Unlock Response packet.";
    private static final String ERROR_NOT_BLE_UNLOCK_RESPONSE = "Payload is not a Bluetooth Unlock Response packet.";
    private static final String ERROR_STEP_NULL = "SRP step cannot be null.";
    private static final String ERROR_DATA_NULL = "Data cannot be null.";
    private SrpStep srpStep = null;
    private SrpError srpError = null;
    private byte[] data;
    private Logger logger;

    public static BluetoothUnlockResponsePacket createPacket(byte[] payload) {
        if (payload == null) {
            throw new NullPointerException(ERROR_PAYLOAD_NULL);
        }
        if (payload.length < 2) {
            throw new IllegalArgumentException(ERROR_INCOMPLETE_PACKET);
        }
        if ((payload[0] & 0xFF) != APIFrameType.BLE_UNLOCK_RESPONSE.getValue()) {
            throw new IllegalArgumentException(ERROR_NOT_BLE_UNLOCK_RESPONSE);
        }
        int index = 1;
        SrpStep srpStep = SrpStep.get(payload[index] & 0xFF);
        if (srpStep == null || srpStep == SrpStep.UNKNOWN) {
            return new BluetoothUnlockResponsePacket(SrpError.get(payload[index] & 0xFF));
        }
        byte[] data = null;
        if (++index < payload.length) {
            data = Arrays.copyOfRange(payload, index, payload.length);
        }
        return new BluetoothUnlockResponsePacket(srpStep, data);
    }

    public BluetoothUnlockResponsePacket(SrpStep srpStep, byte[] data) {
        super(APIFrameType.BLE_UNLOCK_RESPONSE);
        if (srpStep == null) {
            throw new NullPointerException(ERROR_STEP_NULL);
        }
        if (data == null) {
            throw new NullPointerException(ERROR_DATA_NULL);
        }
        this.srpStep = srpStep;
        this.data = data;
        this.logger = LoggerFactory.getLogger(BluetoothUnlockResponsePacket.class);
    }

    public BluetoothUnlockResponsePacket(SrpError srpError) {
        super(APIFrameType.BLE_UNLOCK_RESPONSE);
        if (srpError == null) {
            throw new NullPointerException(ERROR_STEP_NULL);
        }
        this.srpError = srpError;
        this.logger = LoggerFactory.getLogger(BluetoothUnlockResponsePacket.class);
    }

    @Override
    public byte[] getAPIPacketSpecificData() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            if (this.srpStep != null && this.srpStep != SrpStep.UNKNOWN) {
                os.write(this.srpStep.getID());
                os.write(this.data);
            } else {
                os.write(this.srpError.getID());
            }
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return os.toByteArray();
    }

    @Override
    public boolean needsAPIFrameID() {
        return false;
    }

    @Override
    public boolean isBroadcast() {
        return false;
    }

    public void setSrpStep(SrpStep srpStep) {
        if (srpStep == null) {
            throw new NullPointerException(ERROR_STEP_NULL);
        }
        this.srpStep = srpStep;
    }

    public SrpStep getSrpStep() {
        return this.srpStep;
    }

    public void setSrpError(SrpError srpError) {
        if (srpError == null) {
            throw new NullPointerException(ERROR_STEP_NULL);
        }
        this.srpError = srpError;
    }

    public SrpError getSrpError() {
        return this.srpError;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public byte[] getData() {
        return this.data;
    }

    @Override
    public LinkedHashMap<String, String> getAPIPacketParameters() {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        if (this.srpStep != null && this.srpStep != SrpStep.UNKNOWN) {
            parameters.put("SRP step", String.format("%s (%s)", HexUtils.prettyHexString(HexUtils.integerToHexString(this.srpStep.getID(), 1)), this.srpStep.getDescription()));
            parameters.put("Data", HexUtils.prettyHexString(HexUtils.byteArrayToHexString(this.data)));
        } else {
            parameters.put("SRP error", String.format("%s (%s)", HexUtils.prettyHexString(HexUtils.integerToHexString(this.srpError.getID(), 1)), this.srpError.getDescription()));
        }
        return parameters;
    }
}

