/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.packet.common;

import com.digi.xbee.api.models.ATStringCommands;
import com.digi.xbee.api.packet.APIFrameType;
import com.digi.xbee.api.packet.XBeeAPIPacket;
import com.digi.xbee.api.utils.HexUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ATCommandPacket
extends XBeeAPIPacket {
    private static final int MIN_API_PAYLOAD_LENGTH = 4;
    private final String command;
    private byte[] parameter;
    private Logger logger;

    public static ATCommandPacket createPacket(byte[] payload) {
        if (payload == null) {
            throw new NullPointerException("AT Command packet payload cannot be null.");
        }
        if (payload.length < 4) {
            throw new IllegalArgumentException("Incomplete AT Command packet.");
        }
        if ((payload[0] & 0xFF) != APIFrameType.AT_COMMAND.getValue()) {
            throw new IllegalArgumentException("Payload is not an AT Command packet.");
        }
        int index = 1;
        int frameID = payload[index] & 0xFF;
        String command = new String(new byte[]{payload[++index], payload[index + 1]});
        byte[] parameterData = null;
        if ((index += 2) < payload.length) {
            parameterData = Arrays.copyOfRange(payload, index, payload.length);
        }
        return new ATCommandPacket(frameID, command, parameterData);
    }

    public ATCommandPacket(int frameID, String command, String parameter) {
        this(frameID, command, parameter == null ? null : parameter.getBytes());
    }

    public ATCommandPacket(int frameID, String command, byte[] parameter) {
        super(APIFrameType.AT_COMMAND);
        if (command == null) {
            throw new NullPointerException("AT command cannot be null.");
        }
        if (frameID < 0 || frameID > 255) {
            throw new IllegalArgumentException("Frame ID must be between 0 and 255.");
        }
        this.frameID = frameID;
        this.command = command;
        this.parameter = parameter;
        this.logger = LoggerFactory.getLogger(ATCommandPacket.class);
    }

    @Override
    protected byte[] getAPIPacketSpecificData() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            os.write(this.command.getBytes());
            if (this.parameter != null) {
                os.write(this.parameter);
            }
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return os.toByteArray();
    }

    @Override
    public boolean needsAPIFrameID() {
        return true;
    }

    public String getCommand() {
        return this.command;
    }

    public void setParameter(String parameter) {
        this.parameter = (byte[])(parameter == null ? null : parameter.getBytes());
    }

    public void setParameter(byte[] parameter) {
        this.parameter = parameter;
    }

    public byte[] getParameter() {
        return this.parameter;
    }

    public String getParameterAsString() {
        if (this.parameter == null) {
            return null;
        }
        return new String(this.parameter);
    }

    @Override
    public boolean isBroadcast() {
        return false;
    }

    @Override
    public LinkedHashMap<String, String> getAPIPacketParameters() {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put("AT Command", HexUtils.prettyHexString(HexUtils.byteArrayToHexString(this.command.getBytes())) + " (" + this.command + ")");
        if (this.parameter != null) {
            if (ATStringCommands.get(this.command) != null) {
                parameters.put("Parameter", HexUtils.prettyHexString(HexUtils.byteArrayToHexString(this.parameter)) + " (" + new String(this.parameter) + ")");
            } else {
                parameters.put("Parameter", HexUtils.prettyHexString(HexUtils.byteArrayToHexString(this.parameter)));
            }
        }
        return parameters;
    }
}

