/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.packet.common;

import com.digi.xbee.api.models.XBee16BitAddress;
import com.digi.xbee.api.models.XBee64BitAddress;
import com.digi.xbee.api.packet.APIFrameType;
import com.digi.xbee.api.packet.XBeeAPIPacket;
import com.digi.xbee.api.utils.HexUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExplicitAddressingPacket
extends XBeeAPIPacket {
    private static final int MIN_API_PAYLOAD_LENGTH = 20;
    private final XBee64BitAddress destAddress64;
    private final XBee16BitAddress destAddress16;
    private final int broadcastRadius;
    private final int transmitOptions;
    private final int sourceEndpoint;
    private final int destEndpoint;
    private final int clusterID;
    private final int profileID;
    private byte[] rfData;
    private Logger logger;

    public static ExplicitAddressingPacket createPacket(byte[] payload) {
        if (payload == null) {
            throw new NullPointerException("Explicit Addressing packet payload cannot be null.");
        }
        if (payload.length < 20) {
            throw new IllegalArgumentException("Incomplete Explicit Addressing packet.");
        }
        if ((payload[0] & 0xFF) != APIFrameType.EXPLICIT_ADDRESSING_COMMAND_FRAME.getValue()) {
            throw new IllegalArgumentException("Payload is not an Explicit Addressing packet.");
        }
        int index = 1;
        int frameID = payload[index] & 0xFF;
        XBee64BitAddress destAddress64 = new XBee64BitAddress(Arrays.copyOfRange(payload, ++index, index + 8));
        XBee16BitAddress destAddress16 = new XBee16BitAddress(payload[index += 8] & 0xFF, payload[index + 1] & 0xFF);
        int sourceEndpoint = payload[index += 2] & 0xFF;
        int destEndpoint = payload[++index] & 0xFF;
        int clusterID = (payload[++index] & 0xFF) << 8 | payload[index + 1] & 0xFF;
        int profileID = (payload[index += 2] & 0xFF) << 8 | payload[index + 1] & 0xFF;
        int broadcastRadius = payload[index += 2] & 0xFF;
        int options = payload[++index] & 0xFF;
        byte[] rfData = null;
        if (++index < payload.length) {
            rfData = Arrays.copyOfRange(payload, index, payload.length);
        }
        return new ExplicitAddressingPacket(frameID, destAddress64, destAddress16, sourceEndpoint, destEndpoint, clusterID, profileID, broadcastRadius, options, rfData);
    }

    public ExplicitAddressingPacket(int frameID, XBee64BitAddress destAddress64, XBee16BitAddress destAddress16, int sourceEndpoint, int destEndpoint, int clusterID, int profileID, int broadcastRadius, int transmitOptions, byte[] rfData) {
        super(APIFrameType.EXPLICIT_ADDRESSING_COMMAND_FRAME);
        if (destAddress64 == null) {
            throw new NullPointerException("64-bit destination address cannot be null.");
        }
        if (destAddress16 == null) {
            throw new NullPointerException("16-bit destination address cannot be null.");
        }
        if (frameID < 0 || frameID > 255) {
            throw new IllegalArgumentException("Frame ID must be between 0 and 255.");
        }
        if (sourceEndpoint < 0 || sourceEndpoint > 255) {
            throw new IllegalArgumentException("Source endpoint must be between 0 and 255.");
        }
        if (destEndpoint < 0 || destEndpoint > 255) {
            throw new IllegalArgumentException("Destination endpoint must be between 0 and 255.");
        }
        if (clusterID < 0 || clusterID > 65535) {
            throw new IllegalArgumentException("Cluster ID must be between 0 and 65535.");
        }
        if (profileID < 0 || profileID > 65535) {
            throw new IllegalArgumentException("Profile ID must be between 0 and 65535.");
        }
        if (broadcastRadius < 0 || broadcastRadius > 255) {
            throw new IllegalArgumentException("Broadcast radius must be between 0 and 255.");
        }
        if (transmitOptions < 0 || transmitOptions > 255) {
            throw new IllegalArgumentException("Transmit options must be between 0 and 255.");
        }
        this.frameID = frameID;
        this.destAddress64 = destAddress64;
        this.destAddress16 = destAddress16;
        this.sourceEndpoint = sourceEndpoint;
        this.destEndpoint = destEndpoint;
        this.clusterID = clusterID;
        this.profileID = profileID;
        this.broadcastRadius = broadcastRadius;
        this.transmitOptions = transmitOptions;
        this.rfData = rfData;
        this.logger = LoggerFactory.getLogger(ExplicitAddressingPacket.class);
    }

    @Override
    public byte[] getAPIPacketSpecificData() {
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        try {
            data.write(this.destAddress64.getValue());
            data.write(this.destAddress16.getValue());
            data.write(this.sourceEndpoint);
            data.write(this.destEndpoint);
            data.write(this.clusterID >> 8);
            data.write(this.clusterID);
            data.write(this.profileID >> 8);
            data.write(this.profileID);
            data.write(this.broadcastRadius);
            data.write(this.transmitOptions);
            if (this.rfData != null) {
                data.write(this.rfData);
            }
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return data.toByteArray();
    }

    @Override
    public boolean needsAPIFrameID() {
        return true;
    }

    @Override
    public boolean isBroadcast() {
        return this.get64BitDestinationAddress().equals(XBee64BitAddress.BROADCAST_ADDRESS) || this.get16BitDestinationAddress().equals(XBee16BitAddress.BROADCAST_ADDRESS);
    }

    public XBee64BitAddress get64BitDestinationAddress() {
        return this.destAddress64;
    }

    public XBee16BitAddress get16BitDestinationAddress() {
        return this.destAddress16;
    }

    public int getSourceEndpoint() {
        return this.sourceEndpoint;
    }

    public int getDestinationEndpoint() {
        return this.destEndpoint;
    }

    public int getClusterID() {
        return this.clusterID;
    }

    public int getProfileID() {
        return this.profileID;
    }

    public int getBroadcastRadius() {
        return this.broadcastRadius;
    }

    public int getTransmitOptions() {
        return this.transmitOptions;
    }

    public void setRFData(byte[] rfData) {
        this.rfData = (byte[])(rfData == null ? null : Arrays.copyOf(rfData, rfData.length));
    }

    public byte[] getRFData() {
        if (this.rfData == null) {
            return null;
        }
        return Arrays.copyOf(this.rfData, this.rfData.length);
    }

    @Override
    public LinkedHashMap<String, String> getAPIPacketParameters() {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put("Frame ID", HexUtils.prettyHexString(HexUtils.integerToHexString(this.frameID, 1)) + " (" + this.frameID + ")");
        parameters.put("64-bit dest. address", HexUtils.prettyHexString(this.destAddress64.toString()));
        parameters.put("16-bit dest. address", HexUtils.prettyHexString(this.destAddress16.toString()));
        parameters.put("Source endpoint", HexUtils.prettyHexString(HexUtils.integerToHexString(this.sourceEndpoint, 1)));
        parameters.put("Dest. endpoint", HexUtils.prettyHexString(HexUtils.integerToHexString(this.destEndpoint, 1)));
        parameters.put("Cluster ID", HexUtils.prettyHexString(HexUtils.integerToHexString(this.clusterID, 2)));
        parameters.put("Profile ID", HexUtils.prettyHexString(HexUtils.integerToHexString(this.profileID, 2)));
        parameters.put("Broadcast radius", HexUtils.prettyHexString(HexUtils.integerToHexString(this.broadcastRadius, 1)) + " (" + this.broadcastRadius + ")");
        parameters.put("Transmit options", HexUtils.prettyHexString(HexUtils.integerToHexString(this.transmitOptions, 1)));
        if (this.rfData != null) {
            parameters.put("RF data", HexUtils.prettyHexString(HexUtils.byteArrayToHexString(this.rfData)));
        }
        return parameters;
    }
}

